/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtil {
    public static String getImplementationVersion(File file) {
        return JarUtil.getManifestAttributeValue(file, "Implementation-Version");
    }

    public static String getManifestValues(File file, String ... keys) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            sb.append(key).append(" = ").append(JarUtil.getManifestAttributeValue(file, key));
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }

    public static String getManifestAttributeValue(File file, String key) {
        Manifest manifest;
        JarFile jarfile;
        try {
            jarfile = new JarFile(file);
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        try {
            manifest = jarfile.getManifest();
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        if (manifest == null) {
            return "No Manifest!";
        }
        Attributes attrs = manifest.getMainAttributes();
        return attrs.getValue(key);
    }
}

