/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.exec;

import com.trs.dev4.jdk16.exec.ExecuteResult;
import com.trs.dev4.jdk16.exec.ProcessHelper;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.HashMap;
import java.util.Map;

public class CommandExecUtil {
    public static ExecuteResult executeCommand(String cmd, String workDir, Map<String, String> env) {
        ProcessHelper ph = new ProcessHelper(cmd, workDir);
        ph.setEnv(env);
        ph.startAndWait();
        return new ExecuteResult(ph);
    }

    public static ExecuteResult executeCommand(String cmd, String workDir, String pathEnv, String libPathEnv) {
        ProcessHelper ph = new ProcessHelper(cmd, workDir);
        HashMap<String, String> env = new HashMap<String, String>();
        if (!StringHelper.isEmpty(pathEnv)) {
            env.put("PATH", pathEnv);
        }
        if (!StringHelper.isEmpty(libPathEnv)) {
            env.put("LD_LIBRARY_PATH", libPathEnv);
        }
        ph.setEnv(env);
        ph.startAndWait();
        return new ExecuteResult(ph);
    }

    public static ExecuteResult justWaitCommand(String cmd, String workDir, Map<String, String> env) {
        ProcessHelper ph = new ProcessHelper(cmd, workDir);
        ph.setEnv(env);
        ph.setOmitOutput(true);
        ph.startAndWait();
        return new ExecuteResult(ph);
    }

    public static ProcessHelper justStartCommand(String cmd, String workDir, Map<String, String> env) {
        ProcessHelper ph = new ProcessHelper(cmd, workDir);
        ph.setEnv(env);
        return ph.startProcess();
    }

    public static ExecuteResult executeCommand(String cmd) {
        return CommandExecUtil.executeCommand(cmd, null, null);
    }

    public static ExecuteResult executeCommand(String cmd, String workDir) {
        return CommandExecUtil.executeCommand(cmd, workDir, null);
    }
}

