/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cms.impl;

import com.trs.dev4.jdk16.cms.ICMSPublisher;
import com.trs.dev4.jdk16.cms.IContentProvider;
import com.trs.dev4.jdk16.cms.IPublisherServer;
import com.trs.dev4.jdk16.cms.impl.PublisherJob;
import com.trs.dev4.jdk16.model.Configuration;
import com.trs.dev4.jdk16.model.IConfigurable;
import com.trs.dev4.jdk16.model.IConfigurationManager;
import com.trs.dev4.jdk16.model.IModuleLifecycle;
import com.trs.dev4.jdk16.model.ValidationErrors;
import com.trs.dev4.jdk16.thread.DaemonThreadControllor;
import com.trs.dev4.jdk16.thread.IThreadWorkload;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.log4j.Logger;

public class PublisherServer
implements IPublisherServer,
IModuleLifecycle,
IConfigurable {
    private static final Logger logger = Logger.getLogger(PublisherServer.class);
    private static final String CONFIG_OUTPUT_DIR = "publish.dir";
    private ICMSPublisher publisher;
    private DaemonThreadControllor publishThread;
    private String outputDirectory;
    private List<PublisherJob> publisherJobs = new ArrayList<PublisherJob>();
    @Resource(name="configurationManager")
    private IConfigurationManager configurationManager;

    @Override
    public void publish(String templateName, Map<String, Object> inputObjects, String fileName) {
        this.publisher.publish(templateName, inputObjects, String.valueOf(this.outputDirectory) + fileName);
    }

    @Override
    public String getPrefix() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void refreshConfigs() {
        this.outputDirectory = StringHelper.smartAppendSlashToEnd(this.configurationManager.getConfiguration(this, CONFIG_OUTPUT_DIR));
    }

    void doPublish() {
        ArrayList<PublisherJob> executedJobs = new ArrayList<PublisherJob>();
        while (this.publisherJobs.size() > 0) {
            PublisherJob job = this.publisherJobs.remove(0);
            job.publish();
            if (job.getDuration() <= 0) continue;
            executedJobs.add(job);
        }
        if (executedJobs.size() > 0) {
            this.publisherJobs.addAll(executedJobs);
        }
    }

    protected String buildConfigurationDescMessageKey(String configurationKey) {
        return (String.valueOf(this.getPrefix()) + "." + configurationKey + ".desc").toLowerCase();
    }

    @Override
    public ValidationErrors validateConfigs(Map<String, Configuration> configs) {
        return null;
    }

    @Override
    public String getModuleName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void start() {
        this.initConfigurations();
        this.refreshConfigs();
        this.publishThread = new DaemonThreadControllor();
        this.publishThread.start("Publisher.THREAD", 60, new IThreadWorkload(){

            @Override
            public void onExecute() {
                PublisherServer.this.doPublish();
            }
        });
    }

    private void initConfigurations() {
        if (!this.configurationManager.existsOrConfigured(this, CONFIG_OUTPUT_DIR)) {
            String classPath = this.getClass().getClassLoader().getResource("").getPath();
            this.configurationManager.addConfigKey(this, CONFIG_OUTPUT_DIR, "\u53d1\u5e03\u6587\u4ef6\u5939", this.buildConfigurationDescMessageKey(CONFIG_OUTPUT_DIR), classPath);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void restart() {
    }

    @Override
    public void publish(String templateName, IContentProvider contentProvider, Map<String, Object> parameters, int duration) {
        PublisherJob job = new PublisherJob();
        job.setDuration(duration);
        job.setParameters(parameters);
        job.setTemplateName(templateName);
        job.setContentProvider(contentProvider);
        job.setPublisher(this.publisher);
        job.setOutputDirectory(this.outputDirectory);
        this.publisherJobs.add(job);
        logger.debug((Object)("PublisherJob(" + job + ") built successfully."));
    }

    public void setPublisher(ICMSPublisher publisher) {
        this.publisher = publisher;
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

