/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.util.reflect;

import com.trs.dev4.exception.ClassException;
import com.trs.dev4.exception.UnknownException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassUtil {
    public static Class getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new ClassException(e);
        }
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass().getName();
    }

    public static String getSimpleName(Object obj) {
        if (obj == null) {
            return null;
        }
        String fqn = obj.getClass().getName();
        return fqn.substring(fqn.lastIndexOf(46) + 1);
    }

    public static Object createInstance(Class cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
    }

    public static List listAllInterfaces(Class clazz) {
        ArrayList list = new ArrayList();
        Class<?>[] directInterfaces = clazz.getInterfaces();
        list.addAll(Arrays.asList(directInterfaces));
        int i = 0;
        while (i < directInterfaces.length) {
            list.addAll(ClassUtil.listAllInterfaces(directInterfaces[i]));
            ++i;
        }
        return list;
    }

    static List listAllImplementors(Class clsInterface) {
        ArrayList list = new ArrayList();
        return list;
    }

    public static String getSourceLocation(Object obj) {
        if (obj == null) {
            return null;
        }
        return ClassUtil.getSourceLocation(obj.getClass());
    }

    public static String getSourceLocation(Class clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            ProtectionDomain pd = clazz.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                return cs.getLocation().toString();
            }
            return null;
        }
        catch (RuntimeException e) {
            return e.toString();
        }
    }
}

