/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.dao;

import com.trs.cis4.gateway.bean.DbParams;
import com.trs.cis4.gateway.bean.FieldData2;
import com.trs.cis4.gateway.bean.FtpConfig;
import com.trs.cis4.gateway.bean.LogConfig;
import com.trs.cis4.gateway.dao.IRobotDAO;
import com.trs.cis4.socket.config.RobotConfig;
import com.trs.cis4.util.ConstUtil;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class IBaseRobotDAOTest
extends TestCase {
    private String webfolder = String.valueOf(ConstUtil.EXECUTE_PATH) + ConstUtil.DIR_SEPERATOR + "WebRoot" + ConstUtil.DIR_SEPERATOR + "WEB-INF" + ConstUtil.DIR_SEPERATOR;
    private RobotConfig robotConfig;
    private IRobotDAO robotDAO;

    private String[] getPathsp() throws Exception {
        String[] paths = new String[]{String.valueOf(this.webfolder) + "robotConfigs.xml", String.valueOf(this.webfolder) + "xml\\daoContext.xml"};
        return paths;
    }

    public void setUp() throws Exception {
        try {
            FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(this.getPathsp());
            this.robotConfig = (RobotConfig)ctx.getBean("robotConfig");
            this.robotConfig.setRobotvalue(4000);
            this.robotConfig.setRobothost("192.9.200.164");
            this.robotConfig.setRobotport(8004);
            this.robotConfig.setCharset("GBK");
            this.robotDAO = (IRobotDAO)ctx.getBean("robotDAO");
            this.robotDAO.setRobotConfig(this.robotConfig);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void tearDown() throws Exception {
        System.out.println("");
    }

    public void testDownloadConfig() {
        try {
            String bean = this.robotDAO.downloadConfig();
            System.out.println("testDownloadConfig " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetRegisteredRdb() {
        try {
            String[] bean = this.robotDAO.getRegisteredRdb();
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetRegisteredRdb " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetLoadedRdb() {
        try {
            String[] bean = this.robotDAO.getLoadedRdb();
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetLoadedRdb " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetTaskList() {
        try {
            String bean = this.robotDAO.downloadConfig();
            System.out.println("testGetTaskList " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetTaskStatus() {
        try {
            String[] bean = this.robotDAO.getTaskStatus();
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetTaskStatus " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetWorkPathr() {
        try {
            String bean = this.robotDAO.getWorkPath();
            System.out.println("testDownloadWorkDir " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetLogConfig() {
        try {
            String[] bean = this.robotDAO.getLogConfig();
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetLogConfig " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testLoginDb() {
        try {
            DbParams dbParams = new DbParams();
            String bean = this.robotDAO.loginDb(dbParams);
            System.out.println("testLoginDb " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetDatabase() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getDatabase(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetDatabase " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetView() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getView(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetView " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetTable() {
        try {
            DbParams dbtype = new DbParams();
            String[] bean = this.robotDAO.getTable(dbtype);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetTable " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetViewTable() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getViewTable(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetTable " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetTableColumn() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getTableColumn(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetTableColumn " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetViewColumn() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getViewColumn(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetViewColumn " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetTrsUser() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getTrsUser(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetTrsUser " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testCreateTrsDatabase() {
        try {
            DbParams dbParams = new DbParams();
            ArrayList<FieldData2> fieldData2 = new ArrayList<FieldData2>();
            String bean = this.robotDAO.createTrsDatabase(dbParams, fieldData2);
            System.out.println("testCreateTrsDatabase " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetVirtualView() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getVirtualView(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetTrsUser " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetVirtualViewBkserver() {
        try {
            DbParams dbParams = new DbParams();
            String[] bean = this.robotDAO.getVirtualViewBkserver(dbParams);
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetTrsUser " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testRun() {
        try {
            String taskName = "11";
            this.robotDAO.run(taskName);
            System.out.println("testStop " + taskName);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testStop() {
        try {
            String taskName = "11";
            this.robotDAO.stop(taskName);
            System.out.println("testStop " + taskName);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testAdd() {
        try {
            String config = this.robotDAO.downloadConfig();
            Integer b = this.robotDAO.add(config);
            System.out.println("testAdd " + b);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testEdit() {
        try {
            String oldTaskName = "oldTaskName";
            String config = this.robotDAO.downloadConfig();
            Integer b = this.robotDAO.edit(oldTaskName, config);
            System.out.println("testEdit " + b);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testDelete() {
        try {
            String taskName = "taskName";
            Integer b = this.robotDAO.delete(taskName);
            System.out.println("testDelete " + b);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testSetWatchConfig() {
        try {
            Integer bean = this.robotDAO.setWatchConfig("");
            System.out.println("testSetWatchConfig " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testSetLogConfig() {
        try {
            LogConfig logConfig = new LogConfig();
            Integer bean = this.robotDAO.setLogConfig(logConfig);
            System.out.println("testSetLogConfig " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetLogNow() {
        try {
            String[] bean = this.robotDAO.getLogNow();
            int i = 0;
            while (i < bean.length) {
                System.out.println("testGetLogNow " + bean[i]);
                ++i;
            }
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testCheckRegex() {
        try {
            String regex = "<a href.*?>";
            String content = "<a href=adasdsa>aaaaa</a>";
            Integer bean = this.robotDAO.checkRegex(regex, content);
            System.out.println("testCheckRegex " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testCheckBkserver() {
        try {
            DbParams dbParams = new DbParams();
            Integer bean = this.robotDAO.checkBkserver(dbParams);
            System.out.println("testCheckBkserver " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testLoginFtp() {
        try {
            FtpConfig ftpConfig = new FtpConfig();
            ftpConfig.setFtp_server("192.9.200.123");
            ftpConfig.setFtp_port(8080);
            ftpConfig.setFtp_user("trs");
            ftpConfig.setFtp_password("123456");
            Integer bean = this.robotDAO.loginFtp(ftpConfig);
            System.out.println("testLoginFtp " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testCreateFolder() {
        try {
            String folder = "c:\\sdfsdfsfsdsdf\\1288123213";
            Integer bean = this.robotDAO.createFolder(folder);
            System.out.println("testCreateFolder " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetServerTime() {
        try {
            String bean = this.robotDAO.getServerTime();
            System.out.println("testGetServerTime " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }

    public void testGetMachineCode() {
        try {
            String bean = this.robotDAO.getMachineCode();
            System.out.println("testGetServerMac " + bean);
            IBaseRobotDAOTest.assertTrue((boolean)true);
        }
        catch (Exception e) {
            System.out.println(e);
            IBaseRobotDAOTest.assertTrue((boolean)false);
        }
    }
}

