/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl;

import com.trs.infra.cluster.ACK;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.ClusterSender;
import com.trs.infra.cluster.impl.ClusterMessageQueue;
import com.trs.infra.cluster.impl.ClusterTransporterBase;
import org.apache.log4j.Logger;

public abstract class ClusterSenderBase
extends ClusterTransporterBase
implements ClusterSender {
    private static final Logger s_logger;
    private int maxRetry = 3;
    private ClusterMessageQueue messageQueue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.ClusterSenderBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public ClusterSenderBase(String name) {
        super(name);
    }

    public final ClusterMessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public final void setMessageQueue(ClusterMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void run() {
        this.getContext().addSender(this);
        while (this.isContinue()) {
            try {
                this.doSend();
            }
            catch (Throwable e) {
                s_logger.error((Object)"Unexpected Sender exception", e);
            }
        }
        this.cleanup();
        this.getContext().removeSender(this);
    }

    protected final void doSend() {
        ClusterMessage message = null;
        while ((message = this.messageQueue.get()) != null) {
            this.sendMessage(message);
            if (!message.isNeedACK()) continue;
            message.getWaitACK().state(ACK.State.WAIT);
        }
    }

    public void start() {
        this.startup();
        this.startThread();
    }

    public void close() {
        this.stopThread();
    }

    protected abstract void sendMessage(ClusterMessage var1);

    protected abstract long getSendBytes();

    public final int getMaxRetry() {
        return this.maxRetry;
    }

    public final void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }
}

