/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateTimeUtil {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK = 3;
    public static final int DATE = 5;
    public static final int HOUR = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;

    public static Date add(Date date, int field, int amount) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(field, amount);
        return calendar.getTime();
    }

    public static int getByField(Date date, int field) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static Date getDateFromYMDHMS(String dateString) {
        Date date = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = simpleDateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date getDateFromYMD(String dateString) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            date = dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static Date getDateFromFormat(String dateString, String format) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            date = dateFormat.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static String getYMDFromDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    public static String getYMDHMSFromDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public static String getFormatFromDate(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date getDateEnd(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(5, 1);
        Date nextDateBegin = DateTimeUtil.getDateBegin(calendar.getTime());
        return new Date(nextDateBegin.getTime() - 1L);
    }

    public static Date getDateBegin(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMonthEnd(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(2, 1);
        Date nextMonthBegin = DateTimeUtil.getMonthBegin(calendar.getTime());
        return new Date(nextMonthBegin.getTime() - 1L);
    }

    public static Date getMonthBegin(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getYMDHMSZFromDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        return simpleDateFormat.format(date);
    }

    public static String getYMDHMSFromLong(long lDate) {
        String second;
        String minute;
        String hour;
        String day;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(lDate);
        String year = Integer.toString(cal.get(1));
        String month = Integer.toString(cal.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = Integer.toString(cal.get(5))).length() == 1) {
            day = "0" + day;
        }
        if ((hour = Integer.toString(cal.get(11))).length() == 1) {
            hour = "0" + hour;
        }
        if ((minute = Integer.toString(cal.get(12))).length() == 1) {
            minute = "0" + minute;
        }
        if ((second = Integer.toString(cal.get(13))).length() == 1) {
            second = "0" + second;
        }
        return String.valueOf(year) + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
    }

    public static long getLongFromYMDHMS(String sYear, String sMonth, String sDay, String sHour, String sMinute, String sSecond) {
        int iYear = Integer.parseInt(sYear);
        int iMonth = Integer.parseInt(sMonth) - 1;
        int iDay = Integer.parseInt(sDay);
        int iHour = Integer.parseInt(sHour);
        int iMinute = Integer.parseInt(sMinute);
        int iSecond = Integer.parseInt(sSecond);
        Calendar cal = Calendar.getInstance();
        cal.set(iYear, iMonth, iDay, iHour, iMinute, iSecond);
        return cal.getTimeInMillis();
    }

    public static long getLongFromYMDHMS(String datestr) throws ParseException {
        Date date = DateTimeUtil.getDateFromYMDHMS(datestr);
        String y = String.valueOf(DateTimeUtil.getYearFromDate(date));
        String mo = String.valueOf(DateTimeUtil.getMonthFromDate(date));
        String d = String.valueOf(DateTimeUtil.getDayFromDate(date));
        String h = String.valueOf(DateTimeUtil.getHourFromDate(date));
        String mi = String.valueOf(DateTimeUtil.getMinuteFromDate(date));
        String s = String.valueOf(DateTimeUtil.getSecondFromDate(date));
        long datetimel = DateTimeUtil.getLongFromYMDHMS(y, mo, d, h, mi, s);
        return datetimel;
    }

    public static int getYearFromDate(Date date) {
        if (date == null) {
            return 2001;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonthFromDate(Date date) {
        if (date == null) {
            return 1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getDayFromDate(Date date) {
        if (date == null) {
            return 1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getHourFromDate(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinuteFromDate(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(12);
    }

    public static int getSecondFromDate(Date date) {
        if (date == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(13);
    }

    private DateTimeUtil() {
    }
}

