/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.impl.Container;

public class Node {
    private String m_sName;
    private String m_sPath;
    private Node m_oParent;
    private Container m_oContainer;

    public Node(String name) {
        this.m_sName = name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(":name=").append(this.m_sName);
        return sb.toString();
    }

    public void cleanup() {
        this.m_sName = null;
        this.m_sPath = null;
        this.m_oParent = null;
        this.m_oContainer = null;
    }

    protected void trimMemory() {
        this.m_sName = this.m_sName.intern();
        this.m_sPath = null;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getPath() {
        if (this.m_sPath == null) {
            Node parent = this.getParent();
            this.m_sPath = parent != null ? String.valueOf(parent.getPath()) + '/' + this.m_sName : this.m_sName;
        }
        return this.m_sPath;
    }

    public Node getParent() {
        return this.m_oParent;
    }

    protected void setParent(Node parent) {
        this.m_oParent = parent;
        this.m_oContainer = parent.m_oContainer;
    }

    public Container getContainer() {
        return this.m_oContainer;
    }

    protected void setContainer(Container container) {
        this.m_oContainer = container;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean hasChild() {
        return false;
    }
}

