/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.view.AbstractView;
import org.w3c.dom.Node;

public abstract class AbstractXsltView
extends AbstractView {
    public static final String DEFAULT_ROOT = "DocRoot";
    private Resource stylesheetLocation;
    private String root = "DocRoot";
    private URIResolver uriResolver;
    private boolean cache = true;
    private TransformerFactory transformerFactory;
    private Templates templates;

    public void setStylesheetLocation(Resource stylesheetLocation) {
        this.stylesheetLocation = stylesheetLocation;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    protected final void initApplicationContext() throws ApplicationContextException {
        this.transformerFactory = TransformerFactory.newInstance();
        if (this.uriResolver != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using custom URIResolver [" + this.uriResolver + "] in XSLT view with name '" + this.getBeanName() + "'"));
            }
            this.transformerFactory.setURIResolver(this.uriResolver);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("URL in view is " + this.stylesheetLocation));
        }
        this.cacheTemplates();
    }

    private void cacheTemplates() throws ApplicationContextException {
        if (this.stylesheetLocation != null) {
            try {
                this.templates = this.transformerFactory.newTemplates(this.getStylesheetSource(this.stylesheetLocation));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loaded templates [" + this.templates + "] in XSLT view '" + this.getBeanName() + "'"));
                }
            }
            catch (TransformerConfigurationException ex) {
                throw new ApplicationContextException("Can't load stylesheet from " + this.stylesheetLocation + " in XSLT view '" + this.getBeanName() + "'", ex);
            }
        }
    }

    protected Source getStylesheetSource(Resource stylesheetLocation) throws ApplicationContextException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading XSLT stylesheet from " + stylesheetLocation));
        }
        try {
            return new StreamSource(stylesheetLocation.getInputStream());
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Can't load XSLT stylesheet from " + stylesheetLocation, ex);
        }
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.cache) {
            this.logger.warn((Object)"DEBUG SETTING: NOT THREADSAFE AND WILL IMPAIR PERFORMANCE: template will be refreshed");
            this.cacheTemplates();
        }
        if (this.templates == null) {
            if (this.transformerFactory == null) {
                throw new ServletException("XLST view is incorrectly configured. Templates AND TransformerFactory are null");
            }
            this.logger.warn((Object)"XSLT view is not configured: will copy XML input");
            response.setContentType("text/xml; charset=ISO-8859-1");
        } else {
            response.setContentType(this.getContentType());
        }
        Node dom = null;
        String docRoot = null;
        Object singleModel = null;
        if (model.size() == 1) {
            docRoot = (String)model.keySet().iterator().next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Single model object received, key [" + docRoot + "] will be used as root tag"));
            }
            singleModel = model.get(docRoot);
        }
        if (singleModel != null && singleModel instanceof Node) {
            this.logger.debug((Object)"No need to domify: was passed an XML node");
            dom = singleModel;
        } else {
            dom = this.createDomNode(model, docRoot == null ? this.root : docRoot, request, response);
        }
        this.doTransform(model, dom, request, response);
    }

    protected abstract Node createDomNode(Map var1, String var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected void doTransform(Map model, Node dom, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map parameters = this.getParameters(request);
        this.doTransform(dom, parameters, new StreamResult(new BufferedOutputStream((OutputStream)response.getOutputStream())), response.getCharacterEncoding());
    }

    protected void doTransform(Node dom, Map parameters, Result result, String encoding) throws Exception {
        try {
            Transformer trans;
            Transformer transformer = trans = this.templates != null ? this.templates.newTransformer() : this.transformerFactory.newTransformer();
            if (parameters != null) {
                Iterator iter = parameters.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    trans.setParameter(entry.getKey().toString(), entry.getValue());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Added parameters [" + parameters + "] to transformer object"));
                }
            }
            trans.setOutputProperty("encoding", encoding);
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            trans.transform(new DOMSource(dom), result);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("XSLT transformed with stylesheet [" + this.stylesheetLocation + "]"));
            }
        }
        catch (TransformerConfigurationException ex) {
            throw new ServletException("Couldn't create XSLT transformer for stylesheet [" + this.stylesheetLocation + "] in XSLT view with name [" + this.getBeanName() + "]", (Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new ServletException("Couldn't perform transform with stylesheet [" + this.stylesheetLocation + "] in XSLT view with name [" + this.getBeanName() + "]", (Throwable)ex);
        }
    }

    protected Map getParameters(HttpServletRequest request) {
        return this.getParameters();
    }

    protected Map getParameters() {
        return null;
    }
}

