/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.MutableBoolean;
import org.apache.soap.util.StringUtils;
import org.apache.soap.util.net.SocketUtils;

public class HTTPUtils {
    private static final String HTTP_VERSION = "1.0";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    public static final int DEFAULT_OUTPUT_BUFFER_SIZE = 8192;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static String encodeAuth(String userName, String password) throws SOAPException {
        try {
            return Base64.encode((userName + ":" + password).getBytes("8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, e.getMessage(), e);
        }
    }

    private static Socket getSecureSocket(String host, int port, int timeout, String httpProxyHost, int httpProxyPort, Hashtable headers, Boolean tcpNoDelay) throws Exception {
        String proxyAuth = null;
        if (httpProxyHost == null) {
            String proxyHost = System.getProperty("https.proxyHost");
            String nonProxyHosts = System.getProperty("https.nonProxyHosts");
            boolean hostInNonProxyList = HTTPUtils.isHostInNonProxyList(host, nonProxyHosts);
            if (proxyHost != null && !hostInNonProxyList) {
                httpProxyHost = proxyHost;
                httpProxyPort = Integer.getInteger("https.proxyPort", 443);
            }
        }
        if (httpProxyHost != null) {
            proxyAuth = (String)headers.get("Proxy-Authorization");
            if (proxyAuth == null) {
                proxyAuth = System.getProperty("https.proxyAuth");
            } else {
                headers.remove("Proxy-Authorization");
            }
        }
        Class<?> SSLUtilsClass = Class.forName("org.apache.soap.util.net.SSLUtils");
        Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = HTTPUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = HTTPUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean};
        Method buildSSLSocket = SSLUtilsClass.getMethod("buildSSLSocket", paramTypes);
        Object[] params = new Object[]{host, new Integer(port), new Integer(timeout), httpProxyHost, new Integer(httpProxyPort), proxyAuth, tcpNoDelay};
        try {
            return (Socket)buildSSLSocket.invoke(null, params);
        }
        catch (Exception e) {
            Throwable t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            StringBuffer msg = new StringBuffer(512);
            msg.append("Error SSL connecting to ").append(host).append(':').append(port);
            if (httpProxyHost != null) {
                msg.append(" via ").append(httpProxyHost).append(':').append(httpProxyPort);
            }
            msg.append(": ").append(t.toString());
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, msg.toString(), t);
        }
    }

    private static Socket getSocket(String host, int port, int timeout, String httpProxyHost, int httpProxyPort, Hashtable headers, Boolean tcpNoDelay, MutableBoolean proxyUsed) throws Exception {
        int thePort;
        String theHost;
        Socket s = null;
        if (httpProxyHost != null) {
            proxyUsed.setValue(true);
        } else {
            httpProxyHost = System.getProperty("http.proxyHost");
            if (httpProxyHost != null) {
                String nonProxyHosts = System.getProperty("http.nonProxyHosts");
                if (!HTTPUtils.isHostInNonProxyList(host, nonProxyHosts)) {
                    httpProxyPort = Integer.getInteger("http.proxyPort", 80);
                    String proxyUserName = System.getProperty("http.proxyUser");
                    if (proxyUserName != null) {
                        String proxyPassword = System.getProperty("http.proxyPassword");
                        headers.put("Proxy-Authorization", "Basic " + HTTPUtils.encodeAuth(proxyUserName, proxyPassword));
                    }
                    proxyUsed.setValue(true);
                } else {
                    proxyUsed.setValue(false);
                }
            } else {
                proxyUsed.setValue(false);
            }
        }
        if (proxyUsed.getValue()) {
            theHost = httpProxyHost;
            thePort = httpProxyPort;
        } else {
            theHost = host;
            thePort = port;
        }
        try {
            s = SocketUtils.createSocket(theHost, thePort, timeout);
        }
        catch (Exception e) {
            Throwable t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            StringBuffer msg = new StringBuffer(512);
            msg.append("Error connecting to ").append(host).append(':').append(port);
            if (proxyUsed.getValue()) {
                msg.append(" via ").append(httpProxyHost).append(':').append(httpProxyPort);
            }
            msg.append(": ").append(t.toString());
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, msg.toString(), t);
        }
        if (s != null && tcpNoDelay != null) {
            s.setTcpNoDelay(tcpNoDelay);
        }
        return s;
    }

    public static String getHeaderValue(Hashtable headers, String headerName) {
        Enumeration enumeration = headers.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.equalsIgnoreCase(headerName)) continue;
            return (String)headers.get(key);
        }
        return null;
    }

    private static int getPort(URL url) throws IOException {
        int port = url.getPort();
        if (port < 0) {
            port = url.getProtocol().equalsIgnoreCase("HTTPS") ? 443 : 80;
        }
        return port;
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort) throws IOException, SOAPException {
        return HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, 8192, null);
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, int outputBufferSize) throws IOException, SOAPException {
        return HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, outputBufferSize, null);
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, int outputBufferSize, Boolean tcpNoDelay) throws IOException, SOAPException {
        return HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, outputBufferSize, tcpNoDelay, null, null, 0);
    }

    public static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, int outputBufferSize, Boolean tcpNoDelay, StringBuffer requestCopy, StringBuffer responseCopy) throws IOException, SOAPException {
        return HTTPUtils.post(url, request, timeout, httpProxyHost, httpProxyPort, outputBufferSize, tcpNoDelay, requestCopy, responseCopy, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TransportMessage post(URL url, TransportMessage request, int timeout, String httpProxyHost, int httpProxyPort, int outputBufferSize, Boolean tcpNoDelay, StringBuffer requestCopy, StringBuffer responseCopy, int numRedirects) throws IOException, SOAPException {
        TransportMessage response;
        Object value;
        String respContentType;
        int respContentLength;
        Hashtable<String, String> respHeaders;
        int b;
        int statusCode;
        int count;
        char[] cbuf;
        byte[] linebuf;
        OutputStream outStream = null;
        InputStream inStream = null;
        Object in = null;
        String host = url.getHost();
        int port = HTTPUtils.getPort(url);
        String protocol = url.getProtocol();
        Socket s = null;
        boolean proxyUsed = false;
        FilterOutputStream bOutStream = null;
        BufferedInputStream bInStream = null;
        try {
            if (protocol.equalsIgnoreCase("HTTPS")) {
                s = HTTPUtils.getSecureSocket(host, port, timeout, httpProxyHost, httpProxyPort, request.getHeaders(), tcpNoDelay);
            } else {
                MutableBoolean isProxyUsed = new MutableBoolean(proxyUsed);
                s = HTTPUtils.getSocket(host, port, timeout, httpProxyHost, httpProxyPort, request.getHeaders(), tcpNoDelay, isProxyUsed);
                proxyUsed = isProxyUsed.getValue();
            }
            if (timeout > 0) {
                s.setSoTimeout(timeout);
            }
            outStream = s.getOutputStream();
            inStream = s.getInputStream();
        }
        catch (Exception e) {
            void var21_24;
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            if (s != null) {
                s.close();
            }
            if (e instanceof SOAPException) {
                throw (SOAPException)e;
            }
            Exception exception = e;
            if (!(exception instanceof InvocationTargetException)) throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Error opening socket: " + var21_24, (Throwable)var21_24);
            Throwable throwable = ((InvocationTargetException)exception).getTargetException();
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Error opening socket: " + var21_24, (Throwable)var21_24);
        }
        try {
            String URI2;
            String string = URI2 = !proxyUsed ? url.getFile() : url.toString();
            if (URI2.length() == 0) {
                URI2 = "/";
            }
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append("POST ").append(URI2).append(" HTTP/1.0\r\nHost: ").append(host).append(':').append(port).append("\r\nContent-Type: ").append(request.getContentType()).append("\r\nContent-Length: ").append(request.getContentLength()).append("\r\n");
            Enumeration e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                stringBuffer.append(key).append(": ").append(request.getHeader((String)key)).append("\r\n");
            }
            stringBuffer.append("\r\n");
            bOutStream = new BufferedOutputStream(outStream, outputBufferSize);
            bOutStream.write(stringBuffer.toString().getBytes("iso-8859-1"));
            request.writeTo(bOutStream);
            if (requestCopy != null) {
                requestCopy.append(stringBuffer).append(new String(request.getBytes()));
            }
            ((BufferedOutputStream)bOutStream).flush();
            bInStream = new BufferedInputStream(inStream);
            linebuf = new byte[1024];
            cbuf = new char[256];
            count = 0;
            String versionString = null;
            statusCode = 0;
            String statusString = null;
            try {
                int versionEnd = -1;
                int codeStart = -1;
                int codeEnd = -1;
                int stringStart = -1;
                count = 0;
                b = bInStream.read();
                while (b != 10 && b != -1) {
                    block57: {
                        block59: {
                            block58: {
                                if (b == 13) break block57;
                                if (b != 32) break block58;
                                if (versionEnd == -1) {
                                    versionEnd = count;
                                    break block59;
                                } else if (codeStart != -1 && codeEnd == -1) {
                                    codeEnd = count;
                                }
                                break block59;
                            }
                            if (versionEnd != -1 && codeStart == -1) {
                                codeStart = count;
                            } else if (codeEnd != -1 && stringStart == -1) {
                                stringStart = count;
                            }
                        }
                        if (count >= linebuf.length) {
                            byte[] newbuf = new byte[linebuf.length * 2];
                            System.arraycopy(linebuf, 0, newbuf, 0, linebuf.length);
                            linebuf = newbuf;
                        }
                        linebuf[count++] = (byte)b;
                    }
                    b = bInStream.read();
                }
                if (b == -1) {
                    throw new Exception("Reached end of stream while reading HTTP response status");
                }
                if (codeStart == -1) {
                    throw new Exception("HTTP response status not present");
                }
                versionString = StringUtils.getStringISO8859_1(linebuf, 0, versionEnd, cbuf);
                if (codeEnd == -1) {
                    codeEnd = count + 1;
                }
                statusCode = Integer.parseInt(StringUtils.getStringISO8859_1(linebuf, codeStart, codeEnd - codeStart, cbuf));
                statusString = stringStart != -1 ? StringUtils.getStringISO8859_1(linebuf, stringStart, 1 + count - stringStart, cbuf) : "";
            }
            catch (Exception e2) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Error parsing HTTP status line \"" + StringUtils.getStringISO8859_1(linebuf, 0, count, cbuf) + "\": " + e2, e2);
            }
            respHeaders = new Hashtable<String, String>();
            respContentLength = -1;
            respContentType = null;
            try {}
            catch (Exception e3) {
                throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Error parsing HTTP header line \"" + StringUtils.getStringISO8859_1(linebuf, 0, count, cbuf) + "\": " + e3, e3);
            }
        }
        catch (Throwable throwable) {
            Object var38_51 = null;
            if (bOutStream != null) {
                bOutStream.close();
            }
            if (bInStream != null) {
                bInStream.close();
            }
            if (s == null) throw throwable;
            s.close();
            throw throwable;
        }
        while (true) {
            int nameEnd = -1;
            int valStart = -1;
            count = 0;
            b = bInStream.read();
            while (b != 10 && b != -1) {
                if (b != 13) {
                    if (nameEnd == -1 && b == 58) {
                        nameEnd = count;
                    } else if (nameEnd != -1 && valStart == -1 && b != 32 & b != 9) {
                        valStart = count;
                    }
                    if (count >= linebuf.length) {
                        byte[] newbuf = new byte[linebuf.length * 2];
                        System.arraycopy(linebuf, 0, newbuf, 0, linebuf.length);
                        linebuf = newbuf;
                    }
                    linebuf[count++] = (byte)b;
                }
                b = bInStream.read();
            }
            if (b == -1) {
                throw new Exception("Reached end of stream while reading HTTP response header");
            }
            if (count == 0) break;
            if (nameEnd == -1) {
                throw new Exception("Incorrectly formed HTTP response header");
            }
            String name = StringUtils.getStringISO8859_1(linebuf, 0, nameEnd, cbuf);
            value = null;
            if (valStart != -1) {
                if (linebuf[count - 1] == 59) {
                    --count;
                }
                value = StringUtils.getStringISO8859_1(linebuf, valStart, count - valStart, cbuf).trim();
            } else {
                value = "";
            }
            if (name.equalsIgnoreCase("Content-Length")) {
                respContentLength = Integer.parseInt((String)value);
                continue;
            }
            if (name.equalsIgnoreCase("Content-Type")) {
                respContentType = value;
                continue;
            }
            String previousValue = respHeaders.put(name, (String)value);
            if (previousValue == null || !name.equalsIgnoreCase("Set-Cookie") && !name.equalsIgnoreCase("Set-Cookie2")) continue;
            respHeaders.put(name, previousValue + "," + (String)value);
        }
        boolean isOneWay = false;
        if (statusCode >= 300 && statusCode <= 305 && statusCode != 304 && ++numRedirects < 5) {
            String newLocation = HTTPUtils.getHeaderValue(respHeaders, "Location");
            if (newLocation != null) {
                URL newURL = new URL(url, newLocation);
                bOutStream.close();
                bOutStream = null;
                bInStream.close();
                bInStream = null;
                s.close();
                s = null;
                value = HTTPUtils.post(newURL, request, timeout, httpProxyHost, httpProxyPort, outputBufferSize, tcpNoDelay, null, responseCopy, numRedirects);
                Object var38_49 = null;
                if (bOutStream != null) {
                    bOutStream.close();
                }
                if (bInStream != null) {
                    bInStream.close();
                }
                if (s == null) return value;
                s.close();
                return value;
            }
        } else if (statusCode == 202) {
            isOneWay = true;
        }
        try {
            SOAPContext ctx = new SOAPContext();
            ctx.setOneWay(isOneWay);
            response = new TransportMessage(bInStream, respContentLength, respContentType, ctx, respHeaders);
            response.read();
        }
        catch (MessagingException me) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Error parsing response: " + (Object)((Object)me), me);
        }
        if (responseCopy != null) {
            responseCopy.append(new String(response.getBytes()));
        }
        TransportMessage transportMessage = response;
        Object var38_50 = null;
        if (bOutStream != null) {
            bOutStream.close();
        }
        if (bInStream != null) {
            bInStream.close();
        }
        if (s == null) return transportMessage;
        s.close();
        return transportMessage;
    }

    private static boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (!HTTPUtils.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

