/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.MessageRouter;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.Provider;

public class StatelessEJBProvider
implements Provider {
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String methodName;
    private String targetObjectURI;
    private Context contxt = null;
    private EJBObject remoteObjRef = null;
    public static String CNTXT_PROVIDER_URL = "iiop://localhost:900";
    public static String CNTXT_FACTORY_NAME = "com.ibm.ejs.ns.jndi.CNInitialContextFactory";
    static /* synthetic */ Class class$org$apache$soap$Envelope;
    static /* synthetic */ Class class$org$apache$soap$rpc$SOAPContext;

    private void initialize() throws SOAPException {
        this.initialize(CNTXT_PROVIDER_URL, CNTXT_FACTORY_NAME);
    }

    private void initialize(String url, String factory) throws SOAPException {
        if (this.contxt == null) {
            Properties properties = new Properties();
            if (url != null && !url.trim().equals("")) {
                properties.put("java.naming.provider.url", url);
            }
            if (factory != null && !factory.trim().equals("")) {
                properties.put("java.naming.factory.initial", factory);
            }
            try {
                this.contxt = new InitialContext(properties);
            }
            catch (NamingException ne) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to initialize naming context; URL " + url + " factory " + factory + ": " + ne, ne);
            }
        }
    }

    public void invoke(SOAPContext reqContext, SOAPContext resContext) throws SOAPException {
        Parameter ret = null;
        Object[] args = null;
        Class[] argTypes = null;
        String respEncStyle = null;
        if (this.call != null) {
            Vector methodParameters = this.call.getParams();
            respEncStyle = this.call.getEncodingStyleURI();
            if (methodParameters != null) {
                int parametersCount = methodParameters.size();
                args = new Object[parametersCount];
                argTypes = new Class[parametersCount];
                for (int i = 0; i < parametersCount; ++i) {
                    Parameter param = (Parameter)methodParameters.elementAt(i);
                    args[i] = param.getValue();
                    argTypes[i] = param.getType();
                    if (respEncStyle != null) continue;
                    respEncStyle = param.getEncodingStyleURI();
                }
            }
            if (respEncStyle == null) {
                respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
            }
        } else {
            argTypes = new Class[]{class$org$apache$soap$Envelope == null ? (class$org$apache$soap$Envelope = StatelessEJBProvider.class$("org.apache.soap.Envelope")) : class$org$apache$soap$Envelope, class$org$apache$soap$rpc$SOAPContext == null ? (class$org$apache$soap$rpc$SOAPContext = StatelessEJBProvider.class$("org.apache.soap.rpc.SOAPContext")) : class$org$apache$soap$rpc$SOAPContext, class$org$apache$soap$rpc$SOAPContext == null ? (class$org$apache$soap$rpc$SOAPContext = StatelessEJBProvider.class$("org.apache.soap.rpc.SOAPContext")) : class$org$apache$soap$rpc$SOAPContext};
            args = new Object[]{this.envelope, reqContext, resContext};
        }
        try {
            Method m = MethodUtils.getMethod(this.remoteObjRef, this.methodName, argTypes);
            Bean result = new Bean(m.getReturnType(), m.invoke((Object)this.remoteObjRef, args));
            if (result.type != Void.TYPE) {
                ret = new Parameter(RPCConstants.ELEM_RETURN, result.type, result.value, null);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in invoked method " + this.methodName + ": " + t.getMessage(), t);
        }
        catch (Throwable t) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error invoking method " + this.methodName + ": " + t.getMessage(), t);
        }
        if (this.call != null) {
            try {
                Response resp = new Response(this.targetObjectURI, this.call.getMethodName(), ret, null, null, respEncStyle, resContext);
                Envelope env = resp.buildEnvelope();
                StringWriter sw = new StringWriter();
                env.marshall(sw, this.call.getSOAPMappingRegistry(), resContext);
                resContext.setRootPart(sw.toString(), "text/xml;charset=utf-8");
            }
            catch (Exception e) {
                if (e instanceof SOAPException) {
                    throw (SOAPException)e;
                }
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error creating response: " + e, e);
            }
        }
    }

    public void locate(DeploymentDescriptor dd, Envelope env, Call call, String methodName, String targetObjectURI, SOAPContext reqContext) throws SOAPException {
        this.dd = dd;
        this.envelope = env;
        this.call = call;
        this.methodName = methodName;
        this.targetObjectURI = targetObjectURI;
        if (call != null) {
            if (!RPCRouter.validCall(dd, call)) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + call.getMethodName() + "' is not supported.");
            }
        } else if (!MessageRouter.validMessage(dd, methodName)) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Method '" + methodName + "' is not supported.");
        }
        Hashtable props = dd.getProps();
        String ContxtProviderURL = (String)props.get("ContextProviderURL");
        String ContxtFactoryName = (String)props.get("FullContextFactoryName");
        if (ContxtProviderURL != null || ContxtFactoryName != null) {
            this.initialize(ContxtProviderURL, ContxtFactoryName);
        } else {
            this.initialize();
        }
        String homeInterfaceName = (String)props.get("FullHomeInterfaceName");
        if (homeInterfaceName == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "FullHomeInterfaceName must be supplied in the deployment descriptor");
        }
        String jndiName = (String)props.get("JNDIName");
        if (jndiName == null) {
            jndiName = dd.getProviderClass();
        }
        if (jndiName != null && this.contxt != null) {
            try {
                EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)this.contxt.lookup(jndiName), Class.forName(homeInterfaceName));
                Method createMethod = home.getClass().getMethod("create", new Class[0]);
                this.remoteObjRef = (EJBObject)createMethod.invoke((Object)home, new Object[0]);
            }
            catch (Exception e) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in locating or narrowing EJB; name " + jndiName + " interface " + homeInterfaceName + ": " + e, e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

