/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.timedio;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.timedio.InStreamMgr;
import com.sybase.jdbc2.timedio.StreamContext;
import com.sybase.jdbc2.utils.Queue;
import com.sybase.jdbc2.utils.SyncObj;
import com.sybase.jdbc2.utils.SyncQueue;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;

public class OutStreamMgr {
    private Queue _requestList = new Queue(6, 6);
    private SyncQueue _waitList = new SyncQueue(6, 6);
    private InStreamMgr _inMgr;
    private StreamContext _cancelCtx;
    private StreamContext _cancelledCtx;
    private boolean _serialize = false;
    public Tds _tds;
    public boolean _tracing = false;

    public OutStreamMgr(InStreamMgr inStreamMgr) {
        this._inMgr = inStreamMgr;
        this._inMgr.setOutStreamMgr(this);
        this._cancelCtx = null;
        this._cancelledCtx = null;
    }

    public void abortRequest(StreamContext streamContext) {
        streamContext._request.giveToNext();
        this._requestList.removeElement(streamContext);
    }

    public void beginRequest(StreamContext streamContext) throws SQLException {
        if (this._serialize) {
            try {
                this._inMgr.cacheResponses(streamContext);
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
        streamContext.beginRequest();
        this.queueRequest(streamContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean cancelBySpec(StreamContext streamContext, StreamContext streamContext2) throws SQLException {
        Queue queue = this._requestList;
        synchronized (queue) {
            int n = 0;
            int n2 = -1;
            this._requestList.reset();
            try {
                while (true) {
                    StreamContext streamContext3;
                    if ((streamContext3 = (StreamContext)this._requestList.next()) == streamContext2) {
                        continue;
                    }
                    if (n2 >= 0) {
                        this._requestList.removeElement(streamContext2);
                        streamContext.setState(6);
                        return false;
                    }
                    if (streamContext3 == streamContext) {
                        n2 = n;
                        streamContext.cancelled();
                        this._cancelledCtx = streamContext;
                    }
                    ++n;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (n2 == 0) {
                    this._cancelCtx = streamContext2;
                    return true;
                }
                if (n2 < 0) {
                    if (this._inMgr.currentContext() == streamContext && n == 0) {
                        this._cancelCtx = streamContext2;
                        streamContext.cancelled();
                        this._cancelledCtx = null;
                        return true;
                    }
                    this._requestList.removeElement(streamContext2);
                    this._cancelledCtx = null;
                    return false;
                }
            }
        }
        this._cancelCtx = streamContext2;
        this._cancelledCtx = streamContext;
        OutStreamMgr outStreamMgr = this;
        synchronized (outStreamMgr) {
            try {
                this.wait(this._cancelCtx._timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._cancelledCtx = null;
        return true;
    }

    public boolean doCancelRequest(StreamContext streamContext, StreamContext streamContext2, boolean bl) throws SQLException {
        streamContext2.setState(4);
        Object object = this;
        synchronized (object) {
            boolean bl2 = this._serialize;
            try {
                this._serialize = false;
                this.getSendLock(streamContext2);
                this.beginRequest(streamContext2);
                Object var8_9 = null;
                this._serialize = bl2;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this._serialize = bl2;
                throw throwable;
            }
        }
        if (bl) {
            object = this._requestList;
            synchronized (object) {
                StreamContext streamContext3 = this._inMgr.currentContext();
                if (streamContext3 != null) {
                    streamContext3.cancelled();
                }
                this._cancelCtx = streamContext2;
                this._cancelledCtx = null;
                this._requestList.reset();
                try {
                    while (true) {
                        if ((streamContext3 = (StreamContext)this._requestList.next()) == streamContext2) {
                            continue;
                        }
                        streamContext3.cancelled();
                        this._requestList.removeElement(streamContext3);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                }
            }
        }
        if (!this.cancelBySpec(streamContext, streamContext2)) {
            if (streamContext._state == 6) {
                object = this;
                synchronized (object) {
                    if (this._cancelledCtx != null) {
                        try {
                            this.wait(streamContext2._timeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this._cancelledCtx = null;
            }
            return false;
        }
        return true;
    }

    protected SyncObj dump() {
        SyncObj syncObj = null;
        return syncObj;
    }

    public void endRequest(StreamContext streamContext) {
        if (this._cancelCtx != null) {
            this._cancelCtx = null;
            this._cancelledCtx = null;
        }
        streamContext._request.giveToNext();
    }

    protected StreamContext getNextContext() {
        StreamContext streamContext = (StreamContext)this._requestList.popNoEx();
        if (this._cancelledCtx == streamContext) {
            OutStreamMgr outStreamMgr = this;
            synchronized (outStreamMgr) {
                this.notify();
                this._cancelledCtx = null;
            }
        }
        return streamContext;
    }

    public boolean getSendLock(StreamContext streamContext) throws SQLException {
        boolean bl = false;
        switch (streamContext._request.giveToMe(streamContext._timeout)) {
            case 13: {
                bl = true;
                break;
            }
            case 14: {
                ErrorMessage.raiseError("JZ0T4", Integer.toString(streamContext._timeout));
            }
            default: {
                ErrorMessage.raiseError("JZ0T4", Integer.toString(streamContext._timeout));
            }
            case 12: 
        }
        return bl;
    }

    protected SyncQueue getWaitQueue() {
        return this._waitList;
    }

    protected StreamContext peekNextContext() throws EmptyStackException {
        return (StreamContext)this._requestList.peek();
    }

    public void queueRequest(StreamContext streamContext) {
        this._requestList.push(streamContext);
    }

    protected void setSerialize(boolean bl) {
        this._serialize = bl;
    }
}

