/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.utils.Debug;
import java.io.CharConversionException;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class TdsOutputStream
extends FilterOutputStream
implements DataOutput {
    protected byte[] _numbuf = new byte[8];
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    private boolean _byteswap = false;

    public TdsOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public boolean getBigEndian() {
        return this._byteswap ^ true;
    }

    public abstract String getCharset();

    protected int getStringByteLen(String string) throws IOException {
        return string == null ? 0 : this.toBytes(string).length;
    }

    public void setBigEndian(boolean bl) {
        this._byteswap = bl ^ true;
    }

    public final int size() {
        return -1;
    }

    public byte[] stringToByte(String string) throws IOException {
        try {
            return this.toBytes(string);
        }
        catch (CharConversionException charConversionException) {
            ErrorMessage.raiseIOException("JZ0I6", charConversionException.toString());
            Debug.assert(null, false);
            return null;
        }
    }

    protected abstract byte[] toBytes(String var1) throws CharConversionException;

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeBytes(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeChar(int n) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeChars(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        if (this._byteswap) {
            this._numbuf[3] = (byte)(n >>> 24 & 0xFF);
            this._numbuf[2] = (byte)(n >>> 16 & 0xFF);
            this._numbuf[1] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n >>> 24 & 0xFF);
            this._numbuf[1] = (byte)(n >>> 16 & 0xFF);
            this._numbuf[2] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[3] = (byte)(n & 0xFF);
        }
        this.write(this._numbuf, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        if (this._byteswap) {
            this._numbuf[7] = (byte)((int)(l >>> 56) & 0xFF);
            this._numbuf[6] = (byte)((int)(l >>> 48) & 0xFF);
            this._numbuf[5] = (byte)((int)(l >>> 40) & 0xFF);
            this._numbuf[4] = (byte)((int)(l >>> 32) & 0xFF);
            this._numbuf[3] = (byte)((int)(l >>> 24) & 0xFF);
            this._numbuf[2] = (byte)((int)(l >>> 16) & 0xFF);
            this._numbuf[1] = (byte)((int)(l >>> 8) & 0xFF);
            this._numbuf[0] = (byte)((int)l & 0xFF);
        } else {
            this._numbuf[0] = (byte)((int)(l >>> 56) & 0xFF);
            this._numbuf[1] = (byte)((int)(l >>> 48) & 0xFF);
            this._numbuf[2] = (byte)((int)(l >>> 40) & 0xFF);
            this._numbuf[3] = (byte)((int)(l >>> 32) & 0xFF);
            this._numbuf[4] = (byte)((int)(l >>> 24) & 0xFF);
            this._numbuf[5] = (byte)((int)(l >>> 16) & 0xFF);
            this._numbuf[6] = (byte)((int)(l >>> 8) & 0xFF);
            this._numbuf[7] = (byte)((int)l & 0xFF);
        }
        this.write(this._numbuf, 0, 8);
    }

    public final void writeLongAsUnsignedInt(long l) throws IOException {
        if (this._byteswap) {
            this._numbuf[3] = (byte)(l >>> 24 & 0xFFL);
            this._numbuf[2] = (byte)(l >>> 16 & 0xFFL);
            this._numbuf[1] = (byte)(l >>> 8 & 0xFFL);
            this._numbuf[0] = (byte)(l & 0xFFL);
        } else {
            this._numbuf[0] = (byte)(l >>> 24 & 0xFFL);
            this._numbuf[1] = (byte)(l >>> 16 & 0xFFL);
            this._numbuf[2] = (byte)(l >>> 8 & 0xFFL);
            this._numbuf[3] = (byte)(l & 0xFFL);
        }
        this.write(this._numbuf, 0, 4);
    }

    public final void writeShort(int n) throws IOException {
        if (this._byteswap) {
            this._numbuf[1] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[1] = (byte)(n & 0xFF);
        }
        this.write(this._numbuf, 0, 2);
    }

    public void writeString(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public void writeStringLen(String string, int n) throws IOException {
        int n2 = 0;
        if (string != null) {
            byte[] byArray = this.toBytes(string);
            n2 = byArray.length;
            if (n2 > n) {
                ErrorMessage.raiseIOException("JZ0TS", string);
            }
            this.write(byArray);
        }
        int n3 = n2;
        while (n3 < n) {
            this.write(0);
            ++n3;
        }
        this.write(n2);
    }

    public final void writeUTF(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }
}

