/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class IOUtils {
    private static IOUtils instance;

    protected IOUtils() {
    }

    public static IOUtils getInstance() {
        if (instance == null) {
            instance = new IOUtils();
        }
        return instance;
    }

    private boolean isFileStyleProtocol(URL uRL) {
        if (uRL.getProtocol().equals("http")) {
            return true;
        }
        if (uRL.getProtocol().equals("https")) {
            return true;
        }
        if (uRL.getProtocol().equals("ftp")) {
            return true;
        }
        if (uRL.getProtocol().equals("file")) {
            return true;
        }
        return uRL.getProtocol().equals("jar");
    }

    private List parseName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String formatName(List list, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("/");
        }
        if (string != null) {
            stringBuffer.append('?');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private int startsWithUntil(List list, List list2) {
        int n = Math.min(list2.size(), list.size());
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = (String)list.get(i);
            if (string2.equals(string = (String)list2.get(i))) continue;
            return i;
        }
        return n;
    }

    private boolean isSameService(URL uRL, URL uRL2) {
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getHost().equals(uRL2.getHost())) {
            return false;
        }
        return uRL.getPort() == uRL2.getPort();
    }

    public String createRelativeURL(URL uRL, URL uRL2) {
        if (uRL == null) {
            throw new NullPointerException("content url must not be null.");
        }
        if (uRL2 == null) {
            throw new NullPointerException("baseURL must not be null.");
        }
        if (this.isFileStyleProtocol(uRL) && this.isSameService(uRL, uRL2)) {
            List list = this.parseName(this.getPath(uRL));
            List list2 = this.parseName(this.getPath(uRL2));
            String string = this.getQuery(uRL);
            if (!this.isPath(uRL2)) {
                list2.remove(list2.size() - 1);
            }
            if (uRL.equals(uRL2)) {
                return (String)list.get(list.size() - 1);
            }
            int n = this.startsWithUntil(list, list2);
            if (n == 0) {
                return uRL.toExternalForm();
            }
            if (n == list.size()) {
                --n;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list2.size() >= list.size()) {
                int n2 = list2.size() - n;
                for (int i = 0; i < n2; ++i) {
                    arrayList.add("..");
                }
            }
            arrayList.addAll(list.subList(n, list.size()));
            return this.formatName(arrayList, string);
        }
        return uRL.toExternalForm();
    }

    private boolean isPath(URL uRL) {
        if (this.getPath(uRL).endsWith("/")) {
            return true;
        }
        if (uRL.getProtocol().equals("file")) {
            File file = new File(this.getPath(uRL));
            try {
                if (file.isDirectory()) {
                    return true;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    private String getQuery(URL uRL) {
        String string = uRL.getFile();
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private String getPath(URL uRL) {
        String string = uRL.getFile();
        int n = string.indexOf(63);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.copyStreams(inputStream, outputStream, 4096);
    }

    public void copyStreams(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        while (inputStream.available() != 0 && (n2 = inputStream.read(byArray)) > -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public void copyWriter(Reader reader, Writer writer) throws IOException {
        this.copyWriter(reader, writer, 4096);
    }

    public void copyWriter(Reader reader, Writer writer, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = reader.read(cArray);
        while (n2 > -1) {
            writer.write(cArray, 0, n2);
            n2 = reader.read(cArray);
        }
    }

    public String getFileName(URL uRL) {
        String string = uRL.getFile();
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return string;
        }
        return string.substring(n);
    }

    public String stripFileExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 1) {
            return string;
        }
        return string.substring(0, n);
    }

    public String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 1) {
            return "";
        }
        return string.substring(n);
    }

    public boolean isSubDirectory(File file, File file2) throws IOException {
        file = file.getCanonicalFile();
        for (File file3 = file2 = file2.getCanonicalFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!file.equals(file3)) continue;
            return true;
        }
        return false;
    }
}

