/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.nonAxisChart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import org.jCharts.Chart;
import org.jCharts.chartData.interfaces.IPieChartDataSet;
import org.jCharts.chartData.processors.PieChartDataProcessor;
import org.jCharts.imageMap.CircleMapArea;
import org.jCharts.imageMap.ImageMap;
import org.jCharts.imageMap.PolyMapArea;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PieChart2DProperties;
import org.jCharts.test.HTMLChartTestable;
import org.jCharts.test.HTMLGenerator;

public final class PieChart2D
extends Chart
implements HTMLChartTestable {
    private float pieX;
    private float pieY;
    private float diameter;
    private IPieChartDataSet iPieChartDataSet;
    private PieChartDataProcessor pieChartDataProcessor;

    public PieChart2D(IPieChartDataSet iPieChartDataSet, LegendProperties legendProperties, ChartProperties chartProperties, int n, int n2) {
        super(legendProperties, chartProperties, n, n2);
        this.iPieChartDataSet = iPieChartDataSet;
    }

    protected void renderChart() {
        float f;
        PieChart2DProperties pieChart2DProperties = (PieChart2DProperties)this.iPieChartDataSet.getChartTypeProperties();
        this.pieChartDataProcessor = new PieChartDataProcessor(this.iPieChartDataSet);
        this.pieChartDataProcessor.processData();
        float f2 = super.getChartProperties().getEdgePadding() * 2.0f;
        float f3 = super.getImageWidth() / 2;
        float f4 = super.getImageHeight() / 2;
        float f5 = super.renderChartTitle(this.iPieChartDataSet.getChartTitle(), super.getGraphics2D().getFontRenderContext());
        if (this.getLegend() != null) {
            f = 0.0f;
            float f6 = 0.0f;
            this.getLegend().calculateDrawingValues(this.iPieChartDataSet);
            if (this.getLegend().getLegendProperties().getPlacement() == 1) {
                float f7 = this.getLegend().getWidthNeeded() + (float)this.getLegend().getLegendProperties().getChartPadding();
                this.diameter = Math.max((float)super.getImageWidth() - (f7 += f2), 1.0f);
                this.diameter = Math.min(this.diameter, (float)super.getImageHeight() - f2 - f5);
                this.pieX = f3 - (this.getLegend().getWidthNeeded() + (float)this.getLegend().getLegendProperties().getChartPadding() + this.diameter) / 2.0f;
                f = this.pieX + this.diameter + (float)this.getLegend().getLegendProperties().getChartPadding();
                f6 = f4 - (float)(this.getLegend().getHeightNeeded() / 2);
                f6 += f5 / 2.0f;
                this.pieY = f4 - this.diameter / 2.0f;
                this.pieY += f5 / 2.0f;
            } else {
                float f8 = this.getLegend().getHeightNeeded() + this.getLegend().getLegendProperties().getChartPadding();
                f8 += f2;
                this.diameter = Math.max((float)super.getImageHeight() - (f8 += f5), 1.0f);
                this.diameter = Math.min(this.diameter, (float)super.getImageWidth() - f2);
                this.pieY = f4 - ((float)(this.getLegend().getHeightNeeded() + this.getLegend().getLegendProperties().getChartPadding()) + this.diameter) / 2.0f;
                this.pieY += f5 / 2.0f;
                f6 = this.pieY + this.diameter + (float)this.getLegend().getLegendProperties().getChartPadding();
                f = f3 - this.getLegend().getWidthNeeded() / 2.0f;
                this.pieX = f3 - this.diameter / 2.0f;
            }
            super.getLegend().render(f, f6);
        } else {
            this.diameter = Math.min((float)super.getImageHeight() - f2 - f5, (float)super.getImageWidth() - f2);
            f = this.diameter / 2.0f;
            this.pieX = f3 - f;
            this.pieY = f4 - f;
            this.pieY += f5 / 2.0f;
        }
        if (super.getGenerateImageMapFlag()) {
            ImageMap imageMap = new ImageMap(this.iPieChartDataSet.getNumberOfDataItems());
            super.setImageMap(imageMap);
        }
        PieChart2D.render(this);
    }

    static void render(PieChart2D pieChart2D) {
        Graphics2D graphics2D = pieChart2D.getGraphics2D();
        PieChart2DProperties pieChart2DProperties = (PieChart2DProperties)pieChart2D.iPieChartDataSet.getChartTypeProperties();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(pieChart2DProperties.getBorderStroke());
        int n = 3;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[][] fArray = null;
        if (pieChart2D.getImageMap() != null) {
            f = (float)((double)pieChart2D.diameter / 2.0);
            f2 = f + pieChart2D.pieX;
            f3 = f + pieChart2D.pieY;
            fArray = new float[pieChart2D.iPieChartDataSet.getNumberOfDataItems() * (n + 1)][2];
        }
        float f4 = pieChart2DProperties.getZeroDegreeOffset();
        double d = 0.0;
        Arc2D.Double double_ = new Arc2D.Double(pieChart2D.pieX, pieChart2D.pieY, pieChart2D.diameter, pieChart2D.diameter, f4, 360.0, 2);
        if (pieChart2D.iPieChartDataSet.getNumberOfDataItems() == 1) {
            graphics2D.setPaint(pieChart2D.iPieChartDataSet.getPaint(0));
            graphics2D.fill(double_);
            graphics2D.setPaint(pieChart2DProperties.getBorderPaint());
            graphics2D.draw(double_);
            if (pieChart2D.getImageMap() != null) {
                CircleMapArea circleMapArea = new CircleMapArea(f2, f3, pieChart2D.iPieChartDataSet.getValue(0), null, pieChart2D.iPieChartDataSet.getLegendLabel(0));
                circleMapArea.setRadius((int)pieChart2D.diameter);
                pieChart2D.getImageMap().addImageMapArea(circleMapArea);
            }
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < pieChart2D.iPieChartDataSet.getNumberOfDataItems()) {
            d = pieChart2D.pieChartDataProcessor.getPercentageOfPie(n3);
            double_.setAngleStart(f4);
            double_.setAngleExtent(d);
            graphics2D.setPaint(pieChart2D.iPieChartDataSet.getPaint(n3));
            graphics2D.fill(double_);
            graphics2D.setPaint(pieChart2DProperties.getBorderPaint());
            graphics2D.draw(double_);
            if (pieChart2D.getImageMap() != null) {
                double d2 = f4;
                double d3 = f4;
                double d4 = d / (double)n;
                int n4 = 0;
                while (n4 <= n) {
                    double d5 = Math.cos(Math.toRadians(d2));
                    double d6 = Math.sin(Math.toRadians(d2));
                    fArray[n2][0] = f2 + (float)(d5 * (double)f);
                    fArray[n2][1] = f3 + (float)(-(d6 * (double)f));
                    ++n2;
                    d2 += d4;
                    ++n4;
                }
            }
            f4 = (float)((double)f4 + d);
            ++n3;
        }
        if (pieChart2D.getImageMap() != null) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < pieChart2D.iPieChartDataSet.getNumberOfDataItems()) {
                int n7 = 0;
                PolyMapArea polyMapArea = new PolyMapArea(3 + n, pieChart2D.iPieChartDataSet.getValue(n6), null, pieChart2D.iPieChartDataSet.getLegendLabel(n6));
                polyMapArea.addCoordinate(n7++, f2, f3);
                int n8 = 0;
                while (n8 <= n) {
                    polyMapArea.addCoordinate(n7++, fArray[n5][0], fArray[n5][1]);
                    ++n5;
                    ++n8;
                }
                if (n6 + 1 == pieChart2D.iPieChartDataSet.getNumberOfDataItems()) {
                    polyMapArea.addCoordinate(n7, fArray[0][0], fArray[0][1]);
                } else {
                    polyMapArea.addCoordinate(n7, fArray[n5][0], fArray[n5][1]);
                }
                pieChart2D.getImageMap().addImageMapArea(polyMapArea);
                ++n6;
            }
        }
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string) {
        if (this.getLegend() != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

