/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv.handlers;

import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.AbstractPipelineComponent;
import org.dbunit.dataset.csv.handlers.EscapeHandler;
import org.dbunit.dataset.csv.handlers.Helper;
import org.dbunit.dataset.csv.handlers.IsAlnumHandler;
import org.dbunit.dataset.csv.handlers.PipelineComponent;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.csv.handlers.SeparatorHandler;
import org.dbunit.dataset.csv.handlers.WhitespacesHandler;

public class QuoteHandler
extends AbstractPipelineComponent {
    public static final char QUOTE_CHAR = '\"';

    private QuoteHandler() {
    }

    public static final PipelineComponent ACCEPT() {
        return AbstractPipelineComponent.createPipelineComponent(new QuoteHandler(), new AbstractPipelineComponent.ACCEPT());
    }

    public static final PipelineComponent IGNORE() {
        return AbstractPipelineComponent.createPipelineComponent(new QuoteHandler(), new AbstractPipelineComponent.IGNORE());
    }

    public static final PipelineComponent QUOTE() {
        return AbstractPipelineComponent.createPipelineComponent(new QuoteHandler(), new QUOTE());
    }

    public static final PipelineComponent UNQUOTE() {
        return AbstractPipelineComponent.createPipelineComponent(new QuoteHandler(), new UNQUOTE());
    }

    public boolean canHandle(char c) throws IllegalInputCharacterException {
        return c == '\"';
    }

    protected static class UNQUOTE
    extends Helper {
        protected UNQUOTE() {
        }

        public void helpWith(char c) {
            try {
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
            }
            catch (PipelineException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        public boolean allowForNoMoreInput() {
            throw new IllegalStateException("end of input while waiting for a closing quote");
        }
    }

    protected static class QUOTE
    extends Helper {
        protected QUOTE() {
        }

        public void helpWith(char c) {
            this.getHandler().getPipeline().putFront(SeparatorHandler.ACCEPT());
            this.getHandler().getPipeline().putFront(WhitespacesHandler.ACCEPT());
            this.getHandler().getPipeline().putFront(IsAlnumHandler.ACCEPT());
            this.getHandler().getPipeline().putFront(QuoteHandler.UNQUOTE());
            this.getHandler().getPipeline().putFront(EscapeHandler.ESCAPE());
        }
    }
}

