/*
 * Decompiled with CFR 0.152.
 */
package org.aton.cache;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.aton.cache.ICachedObj;
import org.aton.cache.IKeyGenerator;
import org.aton.object.IFilter;
import org.aton.sort.Sorter;

public class CacheContainer
implements ICachedObj {
    private Hashtable m_hCachedObjs = null;
    private int m_nMaxSize = 0;
    private Object m_key = null;
    private IKeyGenerator m_keyGenerator = null;

    public CacheContainer() {
        this.m_hCachedObjs = new Hashtable();
    }

    public CacheContainer(Object p_key, int p_nInitCapacity, int p_nMaxSize) {
        this.m_key = p_key;
        this.m_hCachedObjs = new Hashtable(p_nInitCapacity);
        this.setMaxSize(p_nMaxSize);
    }

    public CacheContainer(Object p_key, int p_nInitCapacity) {
        this.m_key = p_key;
        this.m_hCachedObjs = new Hashtable(p_nInitCapacity);
    }

    public CacheContainer(Object p_key) {
        this.m_key = p_key;
        this.m_hCachedObjs = new Hashtable();
    }

    public Object getCachedKey() {
        return this.m_key;
    }

    public void setCachedKey(Object p_key) {
        this.m_key = p_key;
    }

    public int getMaxSize() {
        return this.m_nMaxSize;
    }

    public void setMaxSize(int p_nMaxSize) {
        this.m_nMaxSize = p_nMaxSize <= 0 ? 0 : p_nMaxSize;
    }

    public IKeyGenerator getKeyGenerator() {
        return this.m_keyGenerator;
    }

    public void setKeyGenerator(IKeyGenerator p_keyGenerator) {
        this.m_keyGenerator = p_keyGenerator;
    }

    public int size() {
        return this.m_hCachedObjs.size();
    }

    public boolean isEmpty() {
        return this.m_hCachedObjs.isEmpty();
    }

    public void clear() {
        this.m_hCachedObjs.clear();
    }

    public Enumeration keys() {
        return this.m_hCachedObjs.keys();
    }

    public Enumeration elements() {
        return this.m_hCachedObjs.elements();
    }

    public Object[] list(IFilter p_filter, Comparator p_comparator) {
        Object[] arrObjs = new Object[this.size()];
        Enumeration elements = this.elements();
        Object aObj = null;
        int i = 0;
        while (elements.hasMoreElements()) {
            aObj = elements.nextElement();
            if (aObj == null || p_filter != null && !p_filter.accept(aObj)) continue;
            arrObjs[i++] = aObj;
        }
        if (i > 1 && p_comparator != null) {
            Sorter.quickSort((Object)arrObjs, (Comparator)p_comparator);
        }
        return arrObjs;
    }

    public Object[] list(IFilter p_filter) {
        return this.list(p_filter, null);
    }

    public Object[] list(Comparator p_comparator) {
        return this.list(null, p_comparator);
    }

    public Object[] list() {
        return this.list(null, null);
    }

    private Object getCachedObjKey(ICachedObj p_obj) {
        if (this.m_keyGenerator == null) {
            return p_obj.getCachedKey();
        }
        return this.m_keyGenerator.getKey(p_obj);
    }

    public ICachedObj getByKey(Object p_key) {
        if (p_key == null) {
            return null;
        }
        return (ICachedObj)this.m_hCachedObjs.get(p_key);
    }

    public void put(ICachedObj p_obj) throws Exception {
        if (p_obj == null) {
            return;
        }
        this.m_hCachedObjs.put(this.getCachedObjKey(p_obj), p_obj);
    }

    public ICachedObj remove(ICachedObj p_obj) throws Exception {
        if (p_obj == null) {
            return null;
        }
        return (ICachedObj)this.m_hCachedObjs.remove(this.getCachedObjKey(p_obj));
    }

    public ICachedObj removeByKey(Object p_key) throws Exception {
        if (p_key == null) {
            return null;
        }
        return (ICachedObj)this.m_hCachedObjs.remove(p_key);
    }

    public void changeKey(ICachedObj p_obj, Object p_oldKey) throws Exception {
        if (p_oldKey != null) {
            this.m_hCachedObjs.remove(p_oldKey);
        }
        this.put(p_obj);
    }
}

