/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Hashtable;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLFrameTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLLinkProcessor;
import org.htmlparser.util.HTMLParserException;

public class HTMLFrameScanner
extends HTMLTagScanner {
    public HTMLFrameScanner() {
    }

    public HTMLFrameScanner(String filter) {
        super(filter);
    }

    public String extractFrameLocn(HTMLTag tag, String url) throws HTMLParserException {
        try {
            Hashtable table = tag.parseParameters();
            String relativeFrame = (String)table.get("SRC");
            if (relativeFrame == null) {
                String string = "";
                return string;
            }
            String string = new HTMLLinkProcessor().extract(relativeFrame, url);
            return string;
        }
        catch (Exception e) {
            String msg = tag != null ? tag.getText() : "null";
            throw new HTMLParserException("HTMLFrameScanner.extractFrameLocn() : Error in extracting frame location from tag ".concat(String.valueOf(String.valueOf(msg))), e);
        }
    }

    public String extractFrameName(HTMLTag tag, String url) {
        return tag.getParameter("NAME");
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        try {
            HTMLFrameTag frameTag;
            String linkText = "";
            String frame = this.extractFrameLocn(tag, url);
            String frameName = this.extractFrameName(tag, url);
            int frameBegin = tag.elementBegin();
            int frameEnd = tag.elementEnd();
            HTMLFrameTag hTMLFrameTag = frameTag = new HTMLFrameTag(frame, frameName, tag.getText(), frameBegin, frameEnd, currentLine, tag.getLine());
            return hTMLFrameTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLFrameScanner.scan() : Error while scanning frame tag, current line = ".concat(String.valueOf(String.valueOf(currentLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{"FRAME"};
        return ids;
    }
}

