/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.scanners.HTMLOptionTagScanner;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLOptionTag;
import org.htmlparser.tags.HTMLSelectTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.HTMLParserUtils;

public class HTMLSelectTagScanner
extends HTMLTagScanner {
    public HTMLSelectTagScanner() {
    }

    public HTMLSelectTagScanner(String pFilter) {
        super(pFilter);
    }

    public HTMLTag scan(HTMLTag pTag, String pUrl, HTMLReader pReader, String pCurrLine) throws HTMLParserException {
        try {
            HTMLEndTag lEndTag = null;
            HTMLNode lNode = null;
            boolean endTagFound = false;
            Vector<HTMLOptionTag> lOptionTags = new Vector<HTMLOptionTag>();
            Hashtable tempScanners = HTMLParserUtils.adjustScanners(pReader);
            pReader.getParser().addScanner(new HTMLOptionTagScanner());
            do {
                if ((lNode = pReader.readElement()) instanceof HTMLEndTag) {
                    lEndTag = (HTMLEndTag)lNode;
                    if (!lEndTag.getText().toUpperCase().equals("SELECT")) continue;
                    endTagFound = true;
                    continue;
                }
                if (lNode instanceof HTMLOptionTag) {
                    lOptionTags.add((HTMLOptionTag)lNode);
                    continue;
                }
                if (lNode instanceof HTMLStringNode) continue;
                throw new HTMLParserException("Error occurred scanning select tag. Undefined tag : ".concat(String.valueOf(String.valueOf(lNode.toHTML()))));
            } while (!endTagFound);
            HTMLSelectTag lSelectTag = new HTMLSelectTag(0, lNode.elementEnd(), pTag.getText(), lOptionTags, pCurrLine, pTag.getLine());
            HTMLParserUtils.restoreScanners(pReader, tempScanners);
            HTMLSelectTag hTMLSelectTag = lSelectTag;
            return hTMLSelectTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLSelectTagScanner.scan() : Error while scanning select tags, current line = ".concat(String.valueOf(String.valueOf(pCurrLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{"SELECT"};
        return ids;
    }
}

