/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.filters;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmlmiddleware.utils.TokenList;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.filters.FilterBase;
import org.xmlmiddleware.xmldbms.filters.FilterConditions;
import org.xmlmiddleware.xmldbms.filters.FilterConst;
import org.xmlmiddleware.xmldbms.filters.FilterSet;
import org.xmlmiddleware.xmldbms.filters.ResultSetFilter;
import org.xmlmiddleware.xmldbms.filters.RootFilter;
import org.xmlmiddleware.xmldbms.filters.TableFilter;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;
import org.xmlmiddleware.xmlutils.XMLName;

public class FilterCompiler
implements ContentHandler {
    private XMLReader xmlReader;
    private TokenList elementTokens;
    private FilterSet filterSet;
    private RootFilter rootFilter;
    private FilterBase filterBase;
    private TableFilter tableFilter;
    private FilterConditions relatedTableFilter;
    private FilterConditions rootFilterConditions;
    private String parentKeyName;
    private String childKeyName;
    private int state;
    private int indent;
    private boolean debug = false;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_ROOTFILTER = 1;
    private static final int STATE_TABLEFILTER = 2;
    private static final int STATE_RELATEDTABLEFILTER = 3;
    private static String NAMESPACES = "http://xml.org/sax/features/namespaces";

    public FilterCompiler(XMLReader xMLReader) throws SAXException {
        if (xMLReader == null) {
            throw new IllegalArgumentException("xmlReader argument must not be null.");
        }
        this.xmlReader = xMLReader;
        this.xmlReader.setContentHandler(this);
        this.xmlReader.setFeature(NAMESPACES, true);
        this.initTokens();
    }

    public FilterSet compile(XMLDBMSMap xMLDBMSMap, InputSource inputSource) throws XMLMiddlewareException {
        if (inputSource == null || xMLDBMSMap == null) {
            throw new IllegalArgumentException("map and src arguments must not be null.");
        }
        this.state = 0;
        this.filterSet = new FilterSet(xMLDBMSMap);
        try {
            this.xmlReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                if (exception instanceof XMLMiddlewareException) {
                    throw (XMLMiddlewareException)exception;
                }
                throw new XMLMiddlewareException(exception);
            }
            throw new XMLMiddlewareException(sAXException);
        }
        catch (IOException iOException) {
            throw new XMLMiddlewareException(iOException);
        }
        return this.filterSet;
    }

    public void startDocument() throws SAXException {
        if (this.debug) {
            System.out.println("Document started.");
        }
    }

    public void endDocument() throws SAXException {
        if (this.debug) {
            System.out.println("Document ended.");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.debug) {
            this.indent();
            System.out.println(String.valueOf(string2) + " (start)");
            this.indent += 3;
        }
        if (!string.equals(FilterConst.URI_FILTERSV2)) {
            throw new SAXException("Unrecognized namespace URI for filter language: " + string);
        }
        try {
            switch (this.elementTokens.getToken(string2)) {
                case 3: {
                    this.processFilterSet(attributes);
                    return;
                }
                case 4: {
                    this.processNamespace(attributes);
                    return;
                }
                case 10: {
                    this.state = 3;
                    this.processRelatedTableFilter(attributes);
                    return;
                }
                case 6: {
                    this.processResultSetInfo(attributes);
                    return;
                }
                case 7: {
                    this.state = 1;
                    this.processRootFilter();
                    return;
                }
                case 8: {
                    this.processTable(attributes);
                    return;
                }
                case 9: {
                    this.state = 2;
                    return;
                }
                case 11: {
                    this.processWhere(attributes);
                    return;
                }
                case 12: {
                    this.processWrapper(attributes);
                    return;
                }
                case -999: {
                    throw new XMLMiddlewareException("Unrecognized filter language element type: " + string2);
                }
                default: {
                    return;
                }
            }
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SAXException(xMLMiddlewareException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.debug) {
            this.indent -= 3;
            this.indent();
            System.out.println(String.valueOf(string2) + " (end)");
        }
        if (!string.equals(FilterConst.URI_FILTERSV2)) {
            throw new SAXException("Unrecognized namespace URI for filter language: " + string);
        }
        try {
            switch (this.elementTokens.getToken(string2)) {
                case 10: {
                    this.state = 2;
                    return;
                }
                case 7: {
                    this.state = 0;
                    return;
                }
                case 9: {
                    this.state = 0;
                    return;
                }
                case -999: {
                    throw new XMLMiddlewareException("Unrecognized filter language element type: " + string2);
                }
                default: {
                    return;
                }
            }
        }
        catch (XMLMiddlewareException xMLMiddlewareException) {
            throw new SAXException(xMLMiddlewareException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    private void processFilterSet(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, FilterConst.ATTR_VERSION, FilterConst.DEF_VERSION);
        if (!string.equals(FilterConst.DEF_VERSION)) {
            throw new XMLMiddlewareException("Unsupported filter language version: " + string);
        }
    }

    private void processNamespace(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, FilterConst.ATTR_PREFIX);
        if (string == null) {
            string = "";
        }
        String string2 = this.getAttrValue(attributes, FilterConst.ATTR_URI);
        this.filterSet.addNamespace(string, string2);
    }

    private void processRelatedTableFilter(Attributes attributes) {
        this.parentKeyName = this.getAttrValue(attributes, FilterConst.ATTR_PARENTKEY);
        this.childKeyName = this.getAttrValue(attributes, FilterConst.ATTR_CHILDKEY);
    }

    private void processResultSetInfo(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, FilterConst.ATTR_NAME, FilterConst.DEF_NAME);
        String string2 = this.getAttrValue(attributes, FilterConst.ATTR_DATABASE, FilterConst.DEF_DATABASE);
        String string3 = this.getAttrValue(attributes, FilterConst.ATTR_CATALOG);
        String string4 = this.getAttrValue(attributes, FilterConst.ATTR_SCHEMA);
        String string5 = this.getAttrValue(attributes, FilterConst.ATTR_TABLE);
        ResultSetFilter resultSetFilter = this.filterSet.createResultSetFilter(string);
        this.filterBase = resultSetFilter;
        resultSetFilter.setTable(string2, string3, string4, string5);
    }

    private void processRootFilter() {
        this.rootFilter = this.filterSet.createRootFilter();
        this.filterBase = this.rootFilter;
    }

    private void processTable(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, FilterConst.ATTR_DATABASE, FilterConst.DEF_DATABASE);
        String string2 = this.getAttrValue(attributes, FilterConst.ATTR_CATALOG);
        String string3 = this.getAttrValue(attributes, FilterConst.ATTR_SCHEMA);
        String string4 = this.getAttrValue(attributes, FilterConst.ATTR_NAME);
        switch (this.state) {
            case 3: {
                this.relatedTableFilter = this.tableFilter.createRelatedTableFilter(string, string2, string3, string4, this.parentKeyName, this.childKeyName);
                return;
            }
            case 1: {
                this.rootFilterConditions = this.rootFilter.createRootFilterConditions(string, string2, string3, string4);
                return;
            }
            case 2: {
                this.tableFilter = this.filterBase.createTableFilter(string, string2, string3, string4);
                return;
            }
        }
        throw new XMLMiddlewareException("Programming error. Invalid state.");
    }

    private void processWhere(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, FilterConst.ATTR_CONDITION);
        switch (this.state) {
            case 3: {
                this.relatedTableFilter.addCondition(string);
                return;
            }
            case 1: {
                this.rootFilterConditions.addCondition(string);
                return;
            }
        }
        throw new XMLMiddlewareException("Programming error. Invalid state.");
    }

    private void processWrapper(Attributes attributes) throws XMLMiddlewareException {
        String string = this.getAttrValue(attributes, FilterConst.ATTR_NAME);
        XMLName xMLName = XMLName.create(string, this.filterSet.getNamespaceURIs());
        this.filterSet.addWrapperName(xMLName, 0);
    }

    private void initTokens() {
        this.elementTokens = new TokenList(FilterConst.ELEMS, FilterConst.ELEM_TOKENS, -999);
    }

    private String getAttrValue(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private String getAttrValue(Attributes attributes, String string, String string2) {
        String string3 = this.getAttrValue(attributes, string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private void indent() {
        int n = 0;
        while (n < this.indent) {
            System.out.print(" ");
            ++n;
        }
    }
}

