/*
 * Decompiled with CFR 0.152.
 */
package com.trs.servlet.xml;

import com.trs.servlet.xml.CMyXXEHelper;
import com.trs.servlet.xml.ServletInputStreamWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;

public class CMyXXEHttpServletRequest
extends HttpServletRequestWrapper {
    private static Logger logger = Logger.getLogger(CMyXXEHttpServletRequest.class);
    private ServletInputStream sis;
    private static final String DOCTYPE = "Doctype";
    private static final int DOCTYPE_LENGTH = "Doctype".length();
    private static final String ENTITY = "entity";
    private static final int ENTITY_LENGTH = "entity".length();

    public CMyXXEHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public String getContentType() {
        return super.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.sis == null) {
            ServletInputStream is = super.getInputStream();
            byte[] data = CMyXXEHttpServletRequest.readFromInputStream((InputStream)is);
            this.assertNoXXE(new String(data));
            this.sis = new ServletInputStreamWrapper(new ByteArrayInputStream(data));
        }
        return this.sis;
    }

    public String getParameter(String name) {
        String sValue = super.getParameter(name);
        this.assertNoXXE(sValue);
        return sValue;
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            this.assertNoXXE(values[i]);
        }
        return values;
    }

    private void assertNoXXE(String sContent) {
        CMyXXEHelper.assertNoXXE(sContent);
    }

    private static byte[] readFromInputStream(InputStream _is) throws IOException {
        logger.debug((Object)"readFromInputStream.........");
        byte[] buffer = new byte[1024];
        int nLen = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        while ((nLen = _is.read(buffer)) > 0) {
            logger.debug((Object)("readFromInputStream[" + nLen + "]........."));
            bos.write(buffer, 0, nLen);
        }
        logger.debug((Object)"readFromInputStream end!");
        return bos.toByteArray();
    }
}

