/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.factory;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileStore;
import com.trs.scm.sdk.ICommentMgr;
import com.trs.scm.sdk.IFavoriteMgr;
import com.trs.scm.sdk.IMicroContentMgr;
import com.trs.scm.sdk.IMicroMessageMgr;
import com.trs.scm.sdk.IMicroUserMgr;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.Platform;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PlatformFactory {
    private static List<Platform> m_oPlatforms = null;
    private static Map<String, Platform> m_oPlatformMap = null;
    private static final String COMMENTMGR_KEY = "CommentMgr";
    private static final String FAVORITEMGR_KEY = "FavoriteMgr";
    private static final String MICROCONTENTMGR_KEY = "MicroContentMgr";
    private static final String MICROMESSAGEMGR_KEY = "MicroMessageMgr";
    private static final String MICROUSERMGR_KEY = "MicroUserMgr";

    public static List<Platform> getPlatforms() throws Exception {
        if (m_oPlatforms == null) {
            PlatformFactory.loadPlatforms();
        }
        return m_oPlatforms;
    }

    public static Platform getPlatform(String _sName) throws Exception {
        if (CMyString.isEmpty(_sName)) {
            throw new Exception("\u6307\u5b9a\u7684\u5e73\u53f0\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (m_oPlatformMap == null) {
            PlatformFactory.loadPlatforms();
        }
        return m_oPlatformMap.get(_sName);
    }

    public static IMicroContentMgr createMicroContentMgr(String _sName, OAuth _oAuth) throws Exception {
        Platform oPlatform = PlatformFactory.getPlatform(_sName);
        if (oPlatform == null) {
            throw new Exception("\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e73\u53f0\u540d\u79f0\u4e3a\u3010" + _sName + "\u3011\u7684\u5e73\u53f0\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String sMgrName = oPlatform.getMicroContentMgrName();
        Class<?> oMgrClass = Class.forName(sMgrName);
        Constructor<?> construtor = oMgrClass.getConstructor(OAuth.class);
        IMicroContentMgr oMicroContentMgr = (IMicroContentMgr)construtor.newInstance(_oAuth);
        return oMicroContentMgr;
    }

    public static ICommentMgr createCommentMgr(String _sName, OAuth _oAuth) throws Exception {
        Platform oPlatform = PlatformFactory.getPlatform(_sName);
        if (oPlatform == null) {
            throw new Exception("\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e73\u53f0\u540d\u79f0\u4e3a\u3010" + _sName + "\u3011\u7684\u5e73\u53f0\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String sMgrName = oPlatform.getCommentMgrName();
        Class<?> oMgrClass = Class.forName(sMgrName);
        Constructor<?> construtor = oMgrClass.getConstructor(OAuth.class);
        ICommentMgr oCommentMgr = (ICommentMgr)construtor.newInstance(_oAuth);
        return oCommentMgr;
    }

    public static IFavoriteMgr createFavoriteMgr(String _sName, OAuth _oAuth) throws Exception {
        Platform oPlatform = PlatformFactory.getPlatform(_sName);
        if (oPlatform == null) {
            throw new Exception("\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e73\u53f0\u540d\u79f0\u4e3a\u3010" + _sName + "\u3011\u7684\u5e73\u53f0\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String sMgrName = oPlatform.getFavoriteMgrName();
        Class<?> oMgrClass = Class.forName(sMgrName);
        Constructor<?> construtor = oMgrClass.getConstructor(OAuth.class);
        IFavoriteMgr oFavoriteMgr = (IFavoriteMgr)construtor.newInstance(_oAuth);
        return oFavoriteMgr;
    }

    public static IMicroMessageMgr createMicroMessageMgr(String _sName, OAuth _oAuth) throws Exception {
        Platform oPlatform = PlatformFactory.getPlatform(_sName);
        if (oPlatform == null) {
            throw new Exception("\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e73\u53f0\u540d\u79f0\u4e3a\u3010" + _sName + "\u3011\u7684\u5e73\u53f0\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String sMgrName = oPlatform.getMessageMgrName();
        Class<?> oMgrClass = Class.forName(sMgrName);
        Constructor<?> construtor = oMgrClass.getConstructor(OAuth.class);
        IMicroMessageMgr oMessageMgr = (IMicroMessageMgr)construtor.newInstance(_oAuth);
        return oMessageMgr;
    }

    public static IMicroUserMgr createMicroUserMgr(String _sName, OAuth _oAuth) throws Exception {
        Platform oPlatform = PlatformFactory.getPlatform(_sName);
        if (oPlatform == null) {
            throw new Exception("\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5e73\u53f0\u540d\u79f0\u4e3a\u3010" + _sName + "\u3011\u7684\u5e73\u53f0\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        String sMgrName = oPlatform.getMicroUserMgrName();
        Class<?> oMgrClass = Class.forName(sMgrName);
        Constructor<?> construtor = oMgrClass.getConstructor(OAuth.class);
        IMicroUserMgr oMicroUserMgr = (IMicroUserMgr)construtor.newInstance(_oAuth);
        return oMicroUserMgr;
    }

    private static void loadPlatforms() throws Exception {
        String sSinaConfigFile = "SinaConfig.properties";
        String sPath = CMyFile.mapResouceFullPath(sSinaConfigFile);
        if (!CMyString.isEmpty(sPath)) {
            sPath = sPath.substring(0, sPath.indexOf(sSinaConfigFile));
        }
        String sSCMConfigPath = sPath + "scm";
        if (!CMyFile.fileExists(sPath)) {
            throw new Exception("scm\u914d\u7f6e\u6587\u4ef6\u7684\u8def\u5f84\u4e0d\u5b58\u5728\u3002\u8def\u5f84\u4e3a\uff1a" + sSCMConfigPath);
        }
        FileStore[] subDirectories = CMyFile.listSubDirectories(sSCMConfigPath);
        FileStore[] platformPropFiles = new FileStore[subDirectories.length];
        for (int i = 0; i < subDirectories.length; ++i) {
            FileStore[] propertyFiles = CMyFile.listFiles(subDirectories[i].getAbsolutePath(), "properties");
            for (int j = 0; j < propertyFiles.length; ++j) {
                FileStore propFile = propertyFiles[j];
                if (!"platform.properties".equalsIgnoreCase(propFile.getName())) continue;
                platformPropFiles[i] = propFile;
            }
        }
        ArrayList<Platform> oPlatforms = new ArrayList<Platform>();
        HashMap<String, Platform> oPlatformMap = new HashMap<String, Platform>();
        for (int i = 0; i < platformPropFiles.length; ++i) {
            FileStore platformPropFile = platformPropFiles[i];
            if (platformPropFile == null) continue;
            Platform oPlatform = PlatformFactory.constructPlatforms(platformPropFile);
            oPlatforms.add(oPlatform);
            oPlatformMap.put(oPlatform.getName(), oPlatform);
        }
        Collections.sort(oPlatforms, new Comparator(){

            public int compare(Object o1, Object o2) {
                Platform platform1 = (Platform)o1;
                Platform platform2 = (Platform)o2;
                int nOrder1 = platform1.getOrder();
                int nOrder2 = platform2.getOrder();
                return nOrder1 - nOrder2;
            }
        });
        m_oPlatforms = oPlatforms;
        m_oPlatformMap = oPlatformMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Platform constructPlatforms(FileStore _oPlatformPropFile) throws Exception {
        InputStream oInputStream = null;
        Platform oPlatform = new Platform();
        try {
            oInputStream = _oPlatformPropFile.getInputStream();
            Properties props = new Properties();
            props.load(oInputStream);
            String sPlatformName = CMyFile.extractFileName(_oPlatformPropFile.getParent());
            oPlatform.setName(sPlatformName);
            oPlatform.setChineseName(props.getProperty("ChineseName"));
            oPlatform.setCommentMgrName(props.getProperty(COMMENTMGR_KEY));
            oPlatform.setFavoriteMgrName(props.getProperty(FAVORITEMGR_KEY));
            oPlatform.setMicroContentMgrName(props.getProperty(MICROCONTENTMGR_KEY));
            oPlatform.setMessageMgrName(props.getProperty(MICROMESSAGEMGR_KEY));
            oPlatform.setMicroUserMgrName(props.getProperty(MICROUSERMGR_KEY));
            oPlatform.setAuthorizedPic(props.getProperty("AuthorizedPic"));
            oPlatform.setAuthorizedUrl(props.getProperty("AuthorizedUrl"));
            oPlatform.setLogo16(props.getProperty("Logo16"));
            String sOrder = props.getProperty("order");
            int nOrder = 100000;
            if (!CMyString.isEmpty(sOrder)) {
                nOrder = Integer.parseInt(sOrder);
            }
            oPlatform.setOrder(nOrder);
        }
        finally {
            if (oInputStream != null) {
                try {
                    oInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return oPlatform;
    }
}

