/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store.impl;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreException;
import com.trs.infra.util.store.FileStoreFactory;
import com.trs.infra.util.store.FileStoreFilter;
import com.trs.infra.util.store.FileStoreNameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileFilter;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbFilenameFilter;

public class SmbFileStore
implements FileStore {
    public static final String PROTOCOL = "smb:";
    private SmbFile file;

    public SmbFileStore(String url) {
        try {
            this.file = new SmbFile(url);
            if (this.isDirectory() && !url.endsWith("/")) {
                this.file = new SmbFile(url + "/");
            }
        }
        catch (MalformedURLException e) {
            throw new FileStoreException(e);
        }
    }

    public SmbFileStore(SmbFile file) {
        this.file = file;
    }

    public SmbFileStore(SmbFileStore context, String name) {
        try {
            this.file = new SmbFile(context.file, name);
            if (this.file.isDirectory() && !name.endsWith("/")) {
                this.file = new SmbFile(context.file, name + "/");
            }
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    public SmbFileStore(SmbFile context, String name) {
        try {
            this.file = new SmbFile(context, name);
            if (this.file.isDirectory() && !name.endsWith("/")) {
                this.file = new SmbFile(context, name + "/");
            }
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    public SmbFileStore(String context, String name) {
        try {
            context = CMyString.setStrEndWith(context, '/');
            this.file = new SmbFile(context, name);
            if (this.file.isDirectory() && !name.endsWith("/")) {
                this.file = new SmbFile(context, name + "/");
            }
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean exists() {
        try {
            return this.file.exists();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.file.isDirectory();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.file.isFile();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean delete() {
        try {
            this.file.delete();
            return true;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public String[] list() {
        try {
            return this.file.list();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public String[] list(FileStoreNameFilter filter) {
        final FileStoreNameFilter finalFilter = filter;
        try {
            return this.file.list(new SmbFilenameFilter(){

                public boolean accept(SmbFile dir, String name) {
                    return finalFilter.accept(new SmbFileStore(dir), name);
                }
            });
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public FileStore[] listFiles() {
        try {
            SmbFile[] files = this.file.listFiles();
            FileStore[] fileStores = new FileStore[files.length];
            for (int i = 0; i < fileStores.length; ++i) {
                fileStores[i] = new SmbFileStore(files[i]);
            }
            return fileStores;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public FileStore[] listFiles(FileStoreNameFilter filter) {
        final FileStoreNameFilter finalFilter = filter;
        try {
            SmbFile[] files = this.file.listFiles(new SmbFilenameFilter(){

                public boolean accept(SmbFile dir, String name) {
                    return finalFilter.accept(new SmbFileStore(dir), name);
                }
            });
            FileStore[] fileStores = new FileStore[files.length];
            for (int i = 0; i < fileStores.length; ++i) {
                fileStores[i] = new SmbFileStore(files[i]);
            }
            return fileStores;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public FileStore[] listFiles(FileStoreFilter filter) {
        final FileStoreFilter finalFilter = filter;
        try {
            SmbFile[] files = this.file.listFiles(new SmbFileFilter(){

                public boolean accept(SmbFile pathname) {
                    return finalFilter.accept(new SmbFileStore(pathname));
                }
            });
            FileStore[] fileStores = new FileStore[files.length];
            for (int i = 0; i < fileStores.length; ++i) {
                fileStores[i] = new SmbFileStore(files[i]);
            }
            return fileStores;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean mkdir() {
        try {
            this.file.mkdir();
            return true;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new SmbFileInputStream(this.file);
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            FileStore parent = this.getParentFileStore();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            return new SmbFileOutputStream(this.file);
        }
        catch (Exception e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getPath();
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getParent() {
        return this.file.getParent();
    }

    @Override
    public FileStore getParentFileStore() {
        return new SmbFileStore(this.file.getParent());
    }

    @Override
    public long lastModified() {
        try {
            return this.file.lastModified();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean setLastModified(long time) {
        try {
            this.file.setLastModified(time);
            return true;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean renameTo(FileStore dest) {
        FileStore dest2 = FileStoreFactory.getInstance().buildFileStore(dest.getPath());
        SmbFileStore smbDest = (SmbFileStore)dest2;
        System.out.println(this.file.getPath() + "&&&&&" + smbDest.file.getPath());
        try {
            this.file.renameTo(smbDest.file);
            return true;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean mkdirs() {
        try {
            if (!this.file.exists()) {
                this.file.mkdirs();
            }
            return true;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean canRead() {
        try {
            return this.file.canRead();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean createNewFile() {
        try {
            this.file.createNewFile();
            return true;
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public boolean isHidden() {
        try {
            return this.file.isHidden();
        }
        catch (SmbException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public URL toURL() {
        try {
            return this.file.toURL();
        }
        catch (MalformedURLException e) {
            throw new FileStoreException(e);
        }
    }

    @Override
    public URI toURI() {
        try {
            return this.toURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new FileStoreException(e);
        }
    }
}

