/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.store;

import com.trs.infra.util.CMyString;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.infra.util.store.FileStore;
import com.trs.infra.util.store.FileStoreParser;
import com.trs.infra.util.store.impl.LocalFileStore;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileStoreFactory {
    private static final Logger logger = Logger.getLogger(FileStoreFactory.class);
    private static final String fileStoreParserLocation = "FileStoreParser.properties";
    private Map<String, FileStoreParser> fileStoreParsers;
    private static FileStoreFactory instance;

    private FileStoreFactory() {
    }

    public static synchronized FileStoreFactory getInstance() {
        if (instance == null) {
            instance = new FileStoreFactory();
        }
        return instance;
    }

    public FileStore buildFileStore(String pathname) {
        int nIndex;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("pathname:" + pathname));
        }
        if ((nIndex = pathname.indexOf(":")) < 0) {
            return new LocalFileStore(pathname);
        }
        String sProtocol = pathname.substring(0, nIndex + 1).toLowerCase();
        Map<String, FileStoreParser> fileStoreParsers = this.getFileStoreParsers();
        FileStoreParser fileStoreParser = fileStoreParsers.get(sProtocol);
        if (fileStoreParser == null) {
            return new LocalFileStore(pathname);
        }
        return fileStoreParser.getFileStore(pathname);
    }

    public FileStore buildFileStore(String parent, String child) {
        int nIndex;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parent:" + parent + "|" + child));
        }
        if ((nIndex = parent.indexOf(":")) < 0) {
            return new LocalFileStore(parent, child);
        }
        String sProtocol = parent.substring(0, nIndex + 1).toLowerCase();
        Map<String, FileStoreParser> fileStoreParsers = this.getFileStoreParsers();
        FileStoreParser fileStoreParser = fileStoreParsers.get(sProtocol);
        if (fileStoreParser == null) {
            return new LocalFileStore(parent, child);
        }
        return fileStoreParser.getFileStore(parent, child);
    }

    public FileStore buildFileStore(FileStore parent, String child) {
        return this.buildFileStore(parent.getAbsolutePath(), child);
    }

    private Map<String, FileStoreParser> getFileStoreParsers() {
        if (this.fileStoreParsers != null) {
            return this.fileStoreParsers;
        }
        this.fileStoreParsers = new HashMap<String, FileStoreParser>();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileStoreParserLocation);
        if (is != null) {
            Properties properties = new Properties();
            try {
                properties.load(is);
                String parsers = properties.getProperty("FileStoreParser");
                String[] parserArray = CMyString.split(parsers, ",");
                for (int i = 0; i < parserArray.length; ++i) {
                    String clazz = parserArray[i];
                    try {
                        FileStoreParser fileStoreParser = (FileStoreParser)Class.forName(clazz).newInstance();
                        this.fileStoreParsers.put(fileStoreParser.getProtocol(), fileStoreParser);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u52a0\u8f7d\u7c7b\u51fa\u73b0\u5f02\u5e38\uff3b" + clazz + "]"), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                logger.error((Object)"\u52a0\u8f7d\uff3bFileStoreParser.properties]\u65f6\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        } else {
            Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors(FileStoreParser.class.getName());
            while (iterator != null && iterator.hasNext()) {
                String clazz = (String)iterator.next();
                try {
                    FileStoreParser fileStoreParser = (FileStoreParser)Class.forName(clazz).newInstance();
                    this.fileStoreParsers.put(fileStoreParser.getProtocol(), fileStoreParser);
                }
                catch (Exception e) {
                    logger.error((Object)("\u52a0\u8f7d\u7c7b\u51fa\u73b0\u5f02\u5e38\uff3b" + clazz + "]"), (Throwable)e);
                }
            }
        }
        return this.fileStoreParsers;
    }
}

