/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class CopyOfTRSImportsOrgnize {
    public static final String CLASSES_PATH_FLAG = File.separatorChar + "classes" + File.separatorChar;
    public static final String FLAG_PAGE_START = "include file=\"";
    public static final int TYPE_NOFLAG = -1;
    public static final int TYPE_PAGE_START = 0;
    public static final int TYPE_INCLUDE = 1;
    public static final int TYPE_HTML_VALUE = 2;
    public static final int TYPE_CODE_START = 3;
    public static final int TYPE_CODE_END = 4;
    public static final int TYPE_COMMENT = 5;
    public static final String[] OPERATION_STR = new String[]{"<%!", "<%=", "<%", "%>", "-", "=", "(", ")", ".", "!"};
    public static final String[] EXCLUDE_PATH = new String[]{"images", "include", "cvs"};
    public static ArrayList arExcludeClass = new ArrayList();
    public static Hashtable hTRSClasses;
    private static final String FLAG_WCM_IMPORTS_BEGIN = "<!------- WCM IMPORTS BEGIN ------------>";
    private static final String FLAG_WCM_IMPORTS_END = "<!------- WCM IMPORTS END ------------>";

    public static void initExcludeClass() {
        arExcludeClass.add("ExceptionNumber.class");
        arExcludeClass.add("User.class");
        arExcludeClass.add("ContextHelper.class");
        arExcludeClass.add("WCMException.class");
        arExcludeClass.add("LoginHelper.class");
        arExcludeClass.add("RequestParser.class");
        arExcludeClass.add("ResponseHelper.class");
        arExcludeClass.add("DreamFactory.class");
    }

    public static boolean isExcludeClass(String _sClassName) {
        return arExcludeClass.indexOf(_sClassName) >= 0;
    }

    public static String transformPathToClassPath(String _sAbsoluteFile) {
        int nPose = _sAbsoluteFile.lastIndexOf(".");
        if (nPose < 0) {
            return _sAbsoluteFile;
        }
        String sClassPath = _sAbsoluteFile.substring(0, nPose);
        nPose = _sAbsoluteFile.indexOf(CLASSES_PATH_FLAG);
        if (nPose < 0) {
            return _sAbsoluteFile;
        }
        sClassPath = sClassPath.substring(nPose + CLASSES_PATH_FLAG.length());
        return sClassPath.replace(File.separatorChar, '.');
    }

    public static Hashtable getFileHashtable(String _sPath) {
        Hashtable<String, String> hClassesMap = new Hashtable<String, String>();
        FileService newFile = new FileService(_sPath);
        FileStore[] arFile = newFile.listFiles();
        for (int i = 0; i < arFile.length; ++i) {
            if (arFile[i].isFile()) {
                if (CopyOfTRSImportsOrgnize.isExcludeClass(arFile[i].getName())) continue;
                String sClassPath = CopyOfTRSImportsOrgnize.transformPathToClassPath(arFile[i].getAbsolutePath());
                hClassesMap.put(arFile[i].getName(), sClassPath);
            }
            if (!arFile[i].isDirectory()) continue;
            hClassesMap.putAll(CopyOfTRSImportsOrgnize.getFileHashtable(arFile[i].getPath()));
        }
        return hClassesMap;
    }

    public static String mapClassFullPath(String _sClassName) {
        if (_sClassName.indexOf(".") < 0) {
            _sClassName = _sClassName + ".class";
        }
        return (String)hTRSClasses.get(_sClassName);
    }

    private static boolean isExcludePath(String _sPath) {
        String sPathName = CMyFile.extractFileName(_sPath);
        for (int i = 0; i < EXCLUDE_PATH.length; ++i) {
            if (!EXCLUDE_PATH[i].equalsIgnoreCase(sPathName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludeFile(String _sFileName) {
        String sFileExt = CMyFile.extractFileExt(_sFileName);
        return !sFileExt.equalsIgnoreCase("jsp");
    }

    public static void dowithPath(String _sPath) throws Exception {
        FileService newFile = new FileService(_sPath);
        if (newFile.isFile()) {
            CopyOfTRSImportsOrgnize.dowithFile(newFile.getAbsolutePath());
            return;
        }
        if (CopyOfTRSImportsOrgnize.isExcludePath(newFile.getName())) {
            return;
        }
        FileStore[] arFile = newFile.listFiles();
        for (int i = 0; i < arFile.length; ++i) {
            if (arFile[i].isFile()) {
                CopyOfTRSImportsOrgnize.dowithFile(arFile[i].getAbsolutePath());
                continue;
            }
            if (!arFile[i].isDirectory()) continue;
            CopyOfTRSImportsOrgnize.dowithPath(arFile[i].getPath());
        }
    }

    public static String dowithFile(String _sFileName) throws CMyException {
        if (CopyOfTRSImportsOrgnize.isExcludeFile(_sFileName)) {
            return null;
        }
        InputStreamReader fileReader = null;
        StringBuffer buffContent = null;
        InputStream fis = null;
        BufferedReader buffReader = null;
        ArrayList arClassPath = new ArrayList();
        try {
            String sLine;
            fis = new FileService(_sFileName).getInputStream();
            buffReader = new BufferedReader(new InputStreamReader(fis, CMyString.FILE_WRITING_ENCODING));
            boolean bCodeStart = false;
            boolean bDowithLine = false;
            int nLineCount = 0;
            while ((sLine = buffReader.readLine()) != null) {
                if (sLine.indexOf("page import=") >= 0) continue;
                if (buffContent == null) {
                    buffContent = new StringBuffer();
                } else {
                    buffContent.append("\n");
                }
                buffContent.append(sLine);
                ++nLineCount;
                int nLineType = CopyOfTRSImportsOrgnize.getLineType(sLine);
                switch (nLineType) {
                    case 5: {
                        bDowithLine = false;
                        break;
                    }
                    case 3: {
                        if (!bCodeStart) {
                            bCodeStart = sLine.indexOf("%>") <= 0;
                        } else {
                            System.out.println(I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label1", "\u5206\u6790\u7b2c[") + nLineCount + I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label2", "]\u884c[") + sLine + I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label3", "]\u53d1\u73b0\u5f02\u5e38:\u4ee5\u524d\u7684\u4ee3\u7801\u6ca1\u6709\u7ed3\u675f!"));
                        }
                        bDowithLine = true;
                        break;
                    }
                    case 4: {
                        if (bCodeStart) {
                            bCodeStart = false;
                        } else {
                            System.out.println(I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label1", "\u5206\u6790\u7b2c[") + nLineCount + I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label2", "]\u884c[") + sLine + I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label4", "]\u53d1\u73b0\u5f02\u5e38:\u6ca1\u6709\u5f00\u59cb!"));
                        }
                        bDowithLine = true;
                        break;
                    }
                    case 2: {
                        sLine = CopyOfTRSImportsOrgnize.subHTMLValue(sLine);
                        bDowithLine = sLine != null;
                        break;
                    }
                    case -1: {
                        bDowithLine = bCodeStart;
                        break;
                    }
                }
                if (!bDowithLine) continue;
                arClassPath = CopyOfTRSImportsOrgnize.mergeArrayList(arClassPath, CopyOfTRSImportsOrgnize.dowithLine(sLine));
                bDowithLine = false;
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMyException(55, I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label6", "\u8981\u8bfb\u53d6\u5f97\u6587\u4ef6\u6ca1\u6709\u627e\u5230(CMyFile.readFile)"), ex);
        }
        catch (IOException ex) {
            throw new CMyException(53, I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label7", "\u8bfb\u6587\u4ef6\u65f6\u9519\u8bef(CMyFile.readFile)"), ex);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (buffReader != null) {
                    buffReader.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        String sImports = CopyOfTRSImportsOrgnize.createImportContent(arClassPath);
        if (arClassPath.isEmpty()) {
            CMyFile.writeFile(_sFileName, buffContent.toString());
        } else {
            int nImportStartPose = buffContent.indexOf("contentType=\"text/html;charset=utf-8\" ");
            int nImportEndPose = buffContent.indexOf("\n", nImportStartPose + 1);
            if (nImportEndPose < 0) {
                System.out.println(I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label8", "\u6587\u4ef6[") + _sFileName + I18NMessage.get(CopyOfTRSImportsOrgnize.class, "CopyOfTRSImportsOrgnize.label9", "]\u4e0d\u7b26\u5408\u6807\u51c6\uff01\u6ca1\u6709\u7ed3\u675f"));
                System.out.println(sImports);
                return sImports;
            }
            String sFileContent = buffContent.substring(0, nImportEndPose) + "\n" + sImports + buffContent.substring(nImportEndPose);
            CMyFile.writeFile(_sFileName, sFileContent);
        }
        return "";
    }

    private static int getLineType(String _sLine) {
        if ((_sLine = _sLine.trim()).indexOf(FLAG_PAGE_START) >= 0) {
            return 0;
        }
        if (_sLine.indexOf("<%@include ") >= 0) {
            return 1;
        }
        if (_sLine.indexOf("<%=") >= 0) {
            return 2;
        }
        if (_sLine.indexOf("<%") >= 0) {
            return 3;
        }
        if (_sLine.indexOf("%>") >= 0) {
            return 4;
        }
        if (_sLine.indexOf("//") == 0 || _sLine.indexOf("*") == 0 || _sLine.indexOf("/*") == 0 || _sLine.indexOf("page import=") > 0) {
            return 5;
        }
        return -1;
    }

    private static String subHTMLValue(String _sLine) {
        int nStart = 0;
        int nEnd = 0;
        String sCode = null;
        while (nEnd >= 0) {
            nStart = _sLine.indexOf("<%=", nEnd);
            if (nStart < 0) {
                return sCode;
            }
            nEnd = _sLine.indexOf("%>", nStart);
            if (nEnd < 0) {
                return sCode;
            }
            sCode = sCode + " " + _sLine.substring(nStart + 3, nEnd);
        }
        return sCode;
    }

    private static ArrayList mergeArrayList(ArrayList _oldList, ArrayList _newList) {
        if (_newList == null || _newList.isEmpty()) {
            return _oldList;
        }
        Object oValue = null;
        for (int i = 0; i < _newList.size(); ++i) {
            oValue = _newList.get(i);
            if (_oldList.indexOf(oValue) >= 0) continue;
            _oldList.add(oValue);
        }
        return _oldList;
    }

    private static String createImportContent(ArrayList _classesList) {
        Collections.sort(_classesList);
        String sClassPath = null;
        String sImportContent = "";
        for (int i = 0; i < _classesList.size(); ++i) {
            sClassPath = (String)_classesList.get(i);
            sImportContent = sImportContent + "<%@ page import=\"" + sClassPath + "\" %>";
            if (i + 1 >= _classesList.size()) continue;
            sImportContent = sImportContent + "\n";
        }
        return "<!------- WCM IMPORTS BEGIN ------------>\n" + sImportContent + "\n" + FLAG_WCM_IMPORTS_END;
    }

    public static ArrayList dowithLine(String _sLine) {
        String sLine = _sLine;
        if ((sLine = sLine.trim()).length() <= 0) {
            return null;
        }
        for (int i = 0; i < OPERATION_STR.length; ++i) {
            sLine = CMyString.replaceStr(sLine, OPERATION_STR[i], " ");
        }
        if ((sLine = sLine.trim()).length() <= 0) {
            return null;
        }
        ArrayList<String> arImportClasses = new ArrayList<String>();
        String sClassPath = null;
        String[] arObject = sLine.split(" ");
        for (int i = 0; i < arObject.length; ++i) {
            if (arObject[i].trim().length() == 0 || (sClassPath = CopyOfTRSImportsOrgnize.mapClassFullPath(arObject[i])) == null || arImportClasses.indexOf(sClassPath) >= 0) continue;
            arImportClasses.add(sClassPath);
        }
        return arImportClasses;
    }

    public static void main(String[] args) {
        try {
            CopyOfTRSImportsOrgnize.dowithPath("D:/MyWorkspace/TRSWCM52SRC/context/");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            CopyOfTRSImportsOrgnize.initExcludeClass();
            hTRSClasses = CopyOfTRSImportsOrgnize.getFileHashtable("D:/MyWorkspace/TRSWCM52SRC/context/WEB-INF/classes/");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

