/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.util.CMyDOM4jHelper;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XmlToObjConverterByDOM4j {
    private static Logger logger = Logger.getLogger(XmlToObjConverterByDOM4j.class);
    private Map m_mTagClassMap = null;
    private static final String PROPERTIES_ELEMENT = "PROPERTIES";
    private int m_nImportType = 1;
    private String m_sXmlEncoding = "utf-8";

    public XmlToObjConverterByDOM4j(int _nImportType) {
        this.m_nImportType = _nImportType;
    }

    public void registPersistentObj(String _sTagName, Class _releatClazz) {
        if (this.m_mTagClassMap == null) {
            this.m_mTagClassMap = new HashMap();
        }
        this.m_mTagClassMap.put(_sTagName, _releatClazz);
    }

    public XmlObject[] convertXml(String _sXmlFile, String _sXslFile, String _sFieldsList) throws WCMException {
        Element rootElement = CMyDOM4jHelper.buildXmlFile(_sXmlFile, _sXslFile);
        if (rootElement.element(PROPERTIES_ELEMENT) == null) {
            return this.convertToObjs(rootElement, _sFieldsList);
        }
        return new XmlObject[]{this.convertToObj(rootElement, _sFieldsList)};
    }

    public XmlObject[] convertXml(String _sXMLContent, String _sFieldsList) throws WCMException {
        Element rootElement = null;
        try {
            rootElement = DocumentHelper.parseText((String)_sXMLContent).getRootElement();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(XmlToObjConverterByDOM4j.class, "XmlToObjConverterByDOM4j.label1", "\u89e3\u6790XML\u51fa\u73b0\u5f02\u5e38\uff01\n") + _sXMLContent, e);
        }
        if (rootElement.element(PROPERTIES_ELEMENT) == null) {
            return this.convertToObjs(rootElement, _sFieldsList);
        }
        return new XmlObject[]{this.convertToObj(rootElement, _sFieldsList)};
    }

    private XmlObject[] convertToObjs(Element _rootElement, String _sFieldsList) throws WCMException {
        int nSize = _rootElement.nodeCount();
        XmlObject[] pXMLObjects = new XmlObject[]{};
        Element eleChild = null;
        for (int i = 0; i < nSize; ++i) {
            eleChild = this.findChildElement(_rootElement, i);
            if (eleChild == null) continue;
            pXMLObjects = this.addNewXMLObject(pXMLObjects, this.fromXmlElement(eleChild, _sFieldsList));
        }
        return pXMLObjects;
    }

    private Element findChildElement(Element _parentElement, int _nChildIndex) {
        return this.findChildElement(_parentElement, _nChildIndex, true);
    }

    private Element findChildElement(Element _parentElement, int _nChildIndex, boolean _bExcludePropertiesNode) {
        Node node = _parentElement.node(_nChildIndex);
        if (!(node instanceof Element)) {
            return null;
        }
        if (_bExcludePropertiesNode && node.getName().toUpperCase().equals(PROPERTIES_ELEMENT)) {
            return null;
        }
        Element eleChild = (Element)node;
        return eleChild;
    }

    private XmlObject convertToObj(Element _rootElement, String _sFieldsList) throws WCMException {
        return this.fromXmlElement(_rootElement, _sFieldsList);
    }

    private XmlObject fromXmlElement(Element _element, String _sFieldsList) throws WCMException {
        String sTagName = _element.getName();
        Element eleProperties = _element.element(PROPERTIES_ELEMENT);
        if (eleProperties == null) {
            logger.error((Object)("The XML of element:\n" + _element.asXML()));
            throw new WCMException(150, I18NMessage.get(XmlToObjConverterByDOM4j.class, "XmlToObjConverterByDOM4j.label2", "XML\u6587\u4ef6\u4e2d\u6ca1\u6709") + PROPERTIES_ELEMENT + I18NMessage.get(XmlToObjConverterByDOM4j.class, "XmlToObjConverterByDOM4j.label3", "\u8282\u70b9!"));
        }
        XmlObject currXmlObj = new XmlObject();
        Class clazz = this.getBaseObjClass(sTagName);
        if (clazz != null) {
            currXmlObj.setCurrentObj(this.convert(_element.element(PROPERTIES_ELEMENT), _sFieldsList, clazz));
        }
        Element eleChild = null;
        int nNodeCount = _element.nodeCount();
        for (int i = 0; i < nNodeCount; ++i) {
            eleChild = this.findChildElement(_element, i);
            if (eleChild == null) continue;
            currXmlObj.addChild(eleChild.getName(), this.fromChildren(eleChild));
        }
        return currXmlObj;
    }

    private XmlObject[] fromChildren(Element _eleChild) throws WCMException {
        XmlObject[] arXmlObjs = new XmlObject[]{};
        Element eleChild = null;
        int nNodeCount = _eleChild.nodeCount();
        for (int i = 0; i < nNodeCount; ++i) {
            eleChild = this.findChildElement(_eleChild, i);
            if (eleChild == null) continue;
            arXmlObjs = this.addNewXMLObject(arXmlObjs, this.fromXmlElement(eleChild, null));
        }
        return arXmlObjs;
    }

    private Class getBaseObjClass(String _sTagName) throws WCMException {
        if (this.m_mTagClassMap == null) {
            throw new WCMException(150, "finish register first!");
        }
        return (Class)this.m_mTagClassMap.get(_sTagName);
    }

    private BaseObj convert(Element _eleProperties, String _sFieldsList, Class _clazz) throws WCMException {
        String sValue;
        BaseObj currObj = BaseObj.createNewInstance(_clazz);
        int nId = 0;
        Element eleChild = _eleProperties.element(currObj.getIdFieldName());
        if (eleChild != null && (sValue = eleChild.getText()) != null) {
            nId = Integer.parseInt(sValue);
        }
        if (nId > 0) {
            switch (this.m_nImportType) {
                case 2: 
                case 3: {
                    currObj = BaseObj.findById(_clazz, nId);
                    if (currObj != null) break;
                    throw new WCMException(I18NMessage.get(XmlToObjConverterByDOM4j.class, "XmlToObjConverterByDOM4j.label4", "\u6307\u5b9a\u7684\u5bf9\u8c61[") + nId + I18NMessage.get(XmlToObjConverterByDOM4j.class, "XmlToObjConverterByDOM4j.label5", "]\u6ca1\u6709\u627e\u5230\uff01"));
                }
            }
        }
        String sName = null;
        if (_sFieldsList != null && _sFieldsList.length() > 0) {
            StringTokenizer enumKeys = new StringTokenizer(_sFieldsList, ",");
            while (enumKeys.hasMoreElements()) {
                sName = (String)enumKeys.nextElement();
                eleChild = _eleProperties.element(sName);
                if (eleChild == null || eleChild.hasContent()) continue;
                sValue = eleChild.getText();
                this.setProperty(currObj, sName, CMyString.decodeForCDATA(sValue));
            }
        } else {
            int nNodeCount = _eleProperties.nodeCount();
            for (int i = 0; i < nNodeCount; ++i) {
                eleChild = this.findChildElement(_eleProperties, i, false);
                if (eleChild == null) continue;
                sName = eleChild.getName();
                sValue = eleChild.getText();
                this.setProperty(currObj, sName, sValue);
            }
        }
        return currObj;
    }

    protected void setProperty(BaseObj _currObj, String _sName, String _sValue) throws WCMException {
        block2: {
            try {
                _currObj.setPropertyWithString(_sName, _sValue);
            }
            catch (WCMException e) {
                if (e.getErrNo() == 1101) break block2;
                throw e;
            }
        }
    }

    public String getXmlEncoding() {
        return this.m_sXmlEncoding;
    }

    public void setXmlEncoding(String _sXmlEncoding) {
        this.m_sXmlEncoding = _sXmlEncoding;
    }

    private XmlObject[] addNewXMLObject(XmlObject[] _pXMLObjects, XmlObject xmlObject) {
        int nOldLength = _pXMLObjects.length;
        XmlObject[] pTemp = new XmlObject[nOldLength + 1];
        if (nOldLength > 0) {
            System.arraycopy(_pXMLObjects, 0, pTemp, 0, nOldLength);
        }
        pTemp[nOldLength] = xmlObject;
        return pTemp;
    }
}

