/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class WCMTagParserHelper {
    private static Logger s_logger = Logger.getLogger(WCMTagParserHelper.class);

    public static int getChildIndex(PublishTagContext _context) throws WCMException {
        int nChildIndex = _context.getAttribute("CHILDINDEX", -1);
        if (nChildIndex < -2) {
            throw new WCMException(233, "Child index " + nChildIndex + " is out of the minimum limitation " + -2);
        }
        return nChildIndex;
    }

    public static int getChildIndex(TagItem _tagItem) throws WCMException {
        int nChildIndex = _tagItem.getIntAttribute("CHILDINDEX", -1);
        if (nChildIndex < -2) {
            throw new WCMException(233, "Child index " + nChildIndex + " is out of the minimum limitation " + -2);
        }
        return nChildIndex;
    }

    public static BaseChannel findFolderHost(TagItem _tagItem, PublishTagContext _context, boolean _bMustBeChannel) throws WCMException {
        return WCMTagParserHelper.findFolderHost(_tagItem, _context, _bMustBeChannel, false);
    }

    public static BaseChannel findFolderHost(TagItem _tagItem, PublishTagContext _context, boolean _bMustBeChannel, boolean _bIsFromAllCataTag) throws WCMException {
        BaseChannel folder;
        int nChildIndex = WCMTagParserHelper.getChildIndex(_context);
        BaseChannel channelOrSite = WCMTagParserHelper.findIdAppointedFolder(_context, _bIsFromAllCataTag);
        if (channelOrSite == null || channelOrSite.isDeleted()) {
            return null;
        }
        int nChannelType = _context.getAttribute("CHANNELTYPE", 0);
        if (nChannelType == 1 || nChannelType == 2) {
            return WCMTagParserHelper.findTopNewsOrPicChannel(channelOrSite, nChannelType);
        }
        switch (nChildIndex) {
            case -2: {
                if (channelOrSite.isSite()) {
                    throw new WCMException(235, "Site has no parent!");
                }
                folder = ((Channel)channelOrSite).getParent();
                if (folder != null) break;
                if (((Channel)channelOrSite).getParentId() != 0) {
                    throw new WCMException(235, channelOrSite.getInfo() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label1", "\u7684\u7236\u9891\u9053\u6ca1\u6709\u627e\u5230!"));
                }
                folder = channelOrSite.getSite();
                break;
            }
            case -1: {
                if (channelOrSite.isSite() && _bMustBeChannel) {
                    _context.addWarning(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label2", "\u7f6e\u6807 ") + _tagItem.toString() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label3", "\u7684\u76f8\u5173\u5bf9\u8c61\u4e0d\u662f\u9891\u9053"));
                    return null;
                }
                folder = channelOrSite;
                break;
            }
            default: {
                folder = channelOrSite.getChildAt(nChildIndex);
                if (folder != null) break;
                s_logger.debug((Object)("Child " + nChildIndex + " of " + channelOrSite.getInfo() + " is not found!"));
            }
        }
        return folder;
    }

    public static BaseChannel findFolderHostByOldModal(TagItem _tagItem, PublishTagContext _context, boolean _bMustBeChannel) throws WCMException {
        BaseChannel folder;
        int nChildIndex = WCMTagParserHelper.getChildIndex(_context);
        BaseChannel channelOrSite = WCMTagParserHelper.findIdAppointedFolder(_context, false);
        switch (nChildIndex) {
            case -2: {
                if (channelOrSite.isSite()) {
                    throw new WCMException(235, "Site has no parent!");
                }
                folder = ((Channel)channelOrSite).getParent();
                if (folder != null) break;
                if (((Channel)channelOrSite).getParentId() != 0) {
                    throw new WCMException(235, channelOrSite.getInfo() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label1", "\u7684\u7236\u9891\u9053\u6ca1\u6709\u627e\u5230!"));
                }
                folder = channelOrSite.getSite();
                break;
            }
            case -1: {
                if (channelOrSite.isSite() && _bMustBeChannel) {
                    throw new WCMException(235, "Host in tag <" + _tagItem.getName() + "> must be channel but not site!");
                }
                folder = channelOrSite;
                break;
            }
            default: {
                folder = channelOrSite.getChildAt(nChildIndex);
                if (folder != null) break;
                s_logger.error((Object)("Child " + nChildIndex + " of " + channelOrSite.getInfo() + " is not found!"));
            }
        }
        return folder;
    }

    public static BaseChannel findTopNewsOrPicChannel(BaseChannel _parent, int _nChannelType) throws WCMException {
        if (_parent == null) {
            throw new WCMException(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label4", "\u6ca1\u6709\u6307\u5b9a\u7236\u9891\u9053\uff01"));
        }
        BaseChannel parent = _parent;
        User system = User.getSystem();
        int nChildrenSize = parent.getChildrenSize(system);
        for (int i = 0; i < nChildrenSize && i < 2; ++i) {
            Channel child = parent.getChildAt(i);
            if (child == null || child.getType() != _nChannelType) continue;
            return child;
        }
        if (parent.isSite()) {
            throw new WCMException(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label5", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7c7b\u578b[") + _nChannelType + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label6", "]\u7684\u9891\u9053\uff01"));
        }
        return WCMTagParserHelper.findTopNewsOrPicChannel(parent.getHost(), _nChannelType);
    }

    private static BaseChannel findIdAppointedFolder(PublishTagContext _context, boolean _bIsFromAllCataTag) throws WCMException {
        IPublishFolder _root;
        IPublishElement _upperHost;
        String sName = _context.getAttribute("ID");
        BaseChannel oSiteOrChannel = WCMTagParserHelper.makeBaseChannelFromID(sName, _upperHost = _context.getUpperHost(), _root = _context.getRoot(), _bIsFromAllCataTag);
        if (oSiteOrChannel != null && !oSiteOrChannel.isDeleted()) {
            return oSiteOrChannel;
        }
        String sMsg = I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label7", "\u6307\u5b9a\u7684\u9891\u9053 [") + sName + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label8", "]\u5728") + _root.getInfo() + I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label9", "\u6ca1\u6709\u627e\u5230!");
        s_logger.warn((Object)sMsg);
        s_logger.warn((Object)"========Template Info=========");
        s_logger.warn((Object)_context.getPageContext().getTemplate());
        s_logger.warn((Object)"========TagItem Info=========");
        s_logger.warn((Object)_context.getTagItem());
        if (PublishServerConfigMapper.isIgnoreIfHostNotFound()) {
            _context.addWarning(sMsg);
            return null;
        }
        throw new WCMException(233, sMsg);
    }

    private static BaseChannel makeBaseChannelFromID(String _sName, IPublishElement _upperHost, IPublishFolder _root, boolean _bIsFromAllCataTag) throws WCMException {
        if (_upperHost == null) {
            throw new WCMException("Upper Host is Null!");
        }
        int nHashcode = 0;
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            nHashcode = _bIsFromAllCataTag ? 2545479 : 75627155;
        } else {
            String sName = _sName.toUpperCase();
            String sKey = "SITEID:";
            String pKey = "PARENT:";
            if (sName.startsWith(sKey)) {
                int nSiteId = 0;
                try {
                    nSiteId = Integer.parseInt(_sName.substring(sKey.length()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nSiteId > 0) {
                    return WebSite.findById(nSiteId);
                }
                nHashcode = _bIsFromAllCataTag ? 2545479 : 75627155;
            } else if (sName.startsWith("CHANNELID:")) {
                int nChannelId = 0;
                try {
                    nChannelId = Integer.parseInt(_sName.substring("CHANNELID:".length()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nChannelId > 0) {
                    return Channel.findById(nChannelId);
                }
                nHashcode = _bIsFromAllCataTag ? 2545479 : 75627155;
            } else if (_sName.indexOf(".") >= 0) {
                int nPathLev = 0;
                String[] pName = CMyString.split(sName, ".");
                int len = pName.length;
                for (int i = 0; i < len; ++i) {
                    int nPathHash = pName[i].trim().hashCode();
                    if (nPathHash != -1942094678) {
                        nPathLev = 0;
                        break;
                    }
                    ++nPathLev;
                }
                if (nPathLev > 0) {
                    BaseChannel channelOrSite = WCMTagParserHelper.getCurrChannelOrSite(_upperHost);
                    if (channelOrSite == null) {
                        return null;
                    }
                    if (channelOrSite.isSite()) {
                        return channelOrSite;
                    }
                    while (nPathLev > 0 && channelOrSite != null && !channelOrSite.isSite()) {
                        channelOrSite = channelOrSite.getHost();
                        --nPathLev;
                    }
                    return channelOrSite;
                }
            } else {
                if (sName.startsWith(pKey) && !sName.equalsIgnoreCase(pKey)) {
                    int index = 0;
                    try {
                        index = Integer.parseInt(_sName.substring(pKey.length()));
                    }
                    catch (Exception pName) {
                        // empty catch block
                    }
                    if (index < -1) {
                        return null;
                    }
                    BaseChannel channelOrSite = WCMTagParserHelper.getCurrChannelOrSite(_upperHost);
                    if (index == -1) {
                        if (channelOrSite == null) {
                            return null;
                        }
                        if (channelOrSite.isSite()) {
                            return null;
                        }
                        while (!channelOrSite.getHost().isSite()) {
                            channelOrSite = channelOrSite.getHost();
                        }
                    } else {
                        for (int count = 0; count < index; ++count) {
                            if (channelOrSite.getParentId() == 0) {
                                channelOrSite = channelOrSite.getSite();
                                break;
                            }
                            channelOrSite = channelOrSite.getHost();
                        }
                    }
                    return channelOrSite;
                }
                nHashcode = sName.hashCode();
            }
        }
        if (nHashcode != 2545479 && nHashcode != 75627155 && nHashcode != -1942094678) {
            return Channel.findByName(_root.getId(), _sName);
        }
        BaseChannel channelOrSite = WCMTagParserHelper.getCurrChannelOrSite(_upperHost);
        if (channelOrSite == null) {
            return null;
        }
        switch (nHashcode) {
            case 2545479: {
                if (!channelOrSite.isSite()) {
                    channelOrSite = channelOrSite.getSite();
                }
                return channelOrSite;
            }
            case 75627155: {
                return channelOrSite;
            }
            case -1942094678: {
                if (!channelOrSite.isSite()) {
                    channelOrSite = channelOrSite.getHost();
                }
                return channelOrSite;
            }
        }
        return Channel.findByName(_root.getId(), _sName);
    }

    private static BaseChannel getCurrChannelOrSite(IPublishElement _upperHost) throws WCMException {
        BaseChannel channelOrSite = null;
        try {
            channelOrSite = _upperHost instanceof IPublishFolder ? (BaseChannel)_upperHost.getSubstance() : (BaseChannel)_upperHost.getFolder().getSubstance();
        }
        catch (ClassCastException ex) {
            throw new WCMException(10, "Upper host must be a channel or a site!");
        }
        return channelOrSite;
    }

    public static Document findDocumentHost(PublishTagContext _context) throws WCMException {
        IPublishElement publishElement = _context.getUpperHost();
        if (!(publishElement instanceof PublishContentDocumentImpl)) {
            _context.addWarning(I18NMessage.get(WCMTagParserHelper.class, "WCMTagParserHelper.label10", "\u5f53\u524dUpperHost\u4e0d\u662fDocument\uff01"));
            return null;
        }
        PublishContentDocumentImpl documentImpl = (PublishContentDocumentImpl)publishElement;
        return (Document)documentImpl.getSubstance();
    }
}

