/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.components.wcm.publish.IFolderPubStatusCacheMgr;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.components.wcm.publish.WCMPubStatusConfigs;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class FolderPubStatusCacheMgrImpl
implements IFolderPubStatusCacheMgr {
    private static Logger logger = Logger.getLogger(FolderPubStatusCacheMgrImpl.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    @Override
    public int[] findStatusesCanDoPub(int _nFolderType, int _nFolderId) throws WCMException {
        int[][] pTemp;
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.init();
        }
        if ((pTemp = (int[][])cache.get(this.getKey(_nFolderType, _nFolderId))) == null) {
            return new int[0];
        }
        return pTemp[0];
    }

    @Override
    public int[] findStatusesCanDoIncreasePub(int _nFolderType, int _nFolderId) throws WCMException {
        int[][] pTemp;
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.init();
        }
        if ((pTemp = (int[][])cache.get(this.getKey(_nFolderType, _nFolderId))) == null) {
            return null;
        }
        return pTemp[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        FolderPubStatusCacheMgrImpl folderPubStatusCacheMgrImpl = this;
        synchronized (folderPubStatusCacheMgrImpl) {
            cache.set(this.getKey(), "true");
            WCMPubStatusConfigs configs = WCMPubStatusConfigs.openWCMObjs(null, null);
            int nSize = configs.size();
            for (int i = 0; i < nSize; ++i) {
                WCMPubStatusConfig config = (WCMPubStatusConfig)configs.getAt(i);
                if (config == null) continue;
                int[][] pTemp = new int[][]{this.makeStatusesCanDoPubFromConfig(config), this.makeStatusesCanDoIncreasePubFromConfig(config)};
                cache.set(this.getKey(config.getFolderType(), config.getFolderId()), pTemp);
            }
        }
        return true;
    }

    private String getKey() {
        return FolderPubStatusCacheMgrImpl.class.getName();
    }

    private String getKey(int type, int id) {
        return this.getKey() + "." + type + "." + id;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof WCMPubStatusConfig)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.init();
        }
        WCMPubStatusConfig config = (WCMPubStatusConfig)_oObjAdded;
        int[][] pTemp = new int[][]{this.makeStatusesCanDoPubFromConfig(config), this.makeStatusesCanDoIncreasePubFromConfig(config)};
        cache.set(this.getKey(config.getFolderType(), config.getFolderId()), pTemp);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof WCMPubStatusConfig)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.init();
        }
        WCMPubStatusConfig config = (WCMPubStatusConfig)_oObjDeleted;
        cache.clear(this.getKey(config.getFolderType(), config.getFolderId()));
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof WCMPubStatusConfig)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(FolderPubStatusCacheMgrImpl.class, "FolderPubStatusCacheMgrImpl.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!_oObjModified.isChangeProperty("STATUSESCANDOPUB")) {
            return;
        }
        String sNewStatuses = _oObjModified.getNewPropertyAsString("STATUSESCANDOPUB");
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.init();
        }
        WCMPubStatusConfig config = (WCMPubStatusConfig)_oObjModified;
        int[][] pTemp = new int[][]{this.makeStatusesCanDoPubFromConfig(sNewStatuses), this.makeStatusesCanDoIncreasePubFromConfig(sNewStatuses)};
        cache.set(this.getKey(config.getFolderType(), config.getFolderId()), pTemp);
    }

    private int[] makeStatusesCanDoPubFromConfig(WCMPubStatusConfig config) {
        String sStatuses = null;
        if (config == null) {
            logger.warn((Object)"Publish config not found!");
        } else {
            sStatuses = config.getStatusesCanDoPub();
            if (sStatuses == null || (sStatuses = sStatuses.trim()).length() == 0) {
                logger.warn((Object)("Publish config of " + config.getFolderType() + ": not set!"));
            }
        }
        return this.makeStatusesCanDoPubFromConfig(sStatuses);
    }

    private int[] makeStatusesCanDoPubFromConfig(String _sStatuses) {
        if (_sStatuses == null || _sStatuses.length() == 0) {
            _sStatuses = String.valueOf(10);
        } else if (_sStatuses.indexOf(String.valueOf(10)) < 0) {
            _sStatuses = _sStatuses + ',' + String.valueOf(10);
        }
        return CMyString.splitToInt(_sStatuses, ",");
    }

    private int[] makeStatusesCanDoIncreasePubFromConfig(WCMPubStatusConfig config) {
        String sStatuses = config.getStatusesCanDoPub();
        if (sStatuses == null || (sStatuses = sStatuses.trim()).length() == 0) {
            return null;
        }
        return this.makeStatusesCanDoIncreasePubFromConfig(sStatuses);
    }

    private int[] makeStatusesCanDoIncreasePubFromConfig(String _sStatuses) {
        if (_sStatuses == null || _sStatuses.length() == 0) {
            return new int[0];
        }
        _sStatuses = ',' + _sStatuses + ',';
        _sStatuses = (_sStatuses = CMyString.replaceStr(_sStatuses, ",10,", ",")).length() >= 3 ? _sStatuses.substring(1, _sStatuses.length() - 1) : null;
        return CMyString.splitToInt(_sStatuses, ",");
    }
}

