/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;
import java.text.DecimalFormat;
import java.text.ParseException;

public class TagMapAreaParser
implements ITagParser {
    private static TagBeanInfo s_TagBeanInfo = null;
    private DecimalFormat m_floatParser = new DecimalFormat("0.00%");

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_MAPAREA");
            tbi.setDesc("\u7535\u5b50\u62a5\u7248\u9762\u56feMap\u7f6e\u6807");
            TagBeanAttrInfo tbai = null;
            tbai = new TagBeanAttrInfo();
            tbai.setName("ISURLABS");
            tbai.setDesc("\u662f\u5426\u4f7f\u7528\u7edd\u5bf9\u8def\u5f84");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WIDTH");
            tbai.setDesc("\u7248\u9762\u56fe\u7684\u5bbd");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("HEIGHT");
            tbai.setDesc("\u7248\u9762\u56fe\u7684\u9ad8");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AREASHAPE");
            tbai.setDesc("\u70ed\u533a\u7684\u5f62\u72b6");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("poly");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TRUNCATETITLE");
            tbai.setDesc("\u6807\u9898\u622a\u65ad\u540e\u7684\u5b57\u7b26\u6570");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TRUNCATEDFLAG");
            tbai.setDesc("\u6807\u9898\u622a\u65ad\u540e\u7684\u66ff\u6362\u5b57\u7b26");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("...");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishElement host = _context.getUpperHost();
        if (host == null || !(host instanceof IPublishContent)) {
            return null;
        }
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", "", "");
        filter.setSelect("DocId,Map,DocTitle,DocChannel,DocType,CrTime");
        int ix = 0;
        Document hostDoc = (Document)host.getSubstance();
        String sImgSize = hostDoc.getAttributeValue("pagesize");
        int nImgWidth = 0;
        int nImgHeight = 0;
        if (!CMyString.isEmpty(sImgSize) && sImgSize.indexOf(",") != -1) {
            int[] temp = CMyString.splitToInt(sImgSize, ",");
            nImgWidth = temp[0];
            nImgHeight = temp[1];
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append("DocChannel=?");
        buff.append(" AND PublishDate=?");
        filter.addSearchValues(ix++, hostDoc.getChannelId());
        String sPublishDate = hostDoc.getPropertyAsString("PublishDate");
        filter.addSearchValues(ix++, sPublishDate);
        buff.append(" AND DocStatus>=1");
        filter.setWhere(buff.toString());
        buff = null;
        Documents docs = new Documents(null);
        docs.open(filter);
        if (docs.isEmpty()) {
            return null;
        }
        String sResult = this.makeMapArea(_context, docs, nImgWidth, nImgHeight, hostDoc.getId());
        return new String[]{sResult};
    }

    private String makeMapArea(PublishTagContext _context, Documents _docs, int _nDefaultWidth, int _nDefaultHeight, int _nPageDocId) throws WCMException {
        boolean zTruncated;
        int nHeight;
        int nWidth = _context.getAttribute("WIDTH", 0);
        if (nWidth <= 0) {
            nWidth = _nDefaultWidth;
        }
        if ((nHeight = _context.getAttribute("HEIGHT", 0)) <= 0) {
            nHeight = _nDefaultHeight;
        }
        StringBuffer result = new StringBuffer(256);
        PublishPathCompass compass = _context.getPathCompass();
        boolean zRelativeUrl = !_context.getAttribute("ISURLABS", false);
        String areaShape = _context.getAttribute("AREASHAPE");
        if (areaShape == null || areaShape.trim().length() == 0) {
            areaShape = "poly";
        }
        boolean zRectShape = "rect".equals(areaShape.toLowerCase());
        String linkUrl = null;
        String pagePath = _context.getPageHttpPath();
        IPublishContent content = null;
        IPublishFolder folder = null;
        String title = null;
        int nTruncatedLen = _context.getAttribute("TRUNCATETITLE", 0);
        String sTruncatedFlag = "...";
        boolean bl = zTruncated = nTruncatedLen > 0;
        if (zTruncated) {
            sTruncatedFlag = _context.getAttribute("TRUNCATEDFLAG");
        }
        int nPageDocId = _nPageDocId;
        int size = _docs.size();
        for (int i = 0; i < size; ++i) {
            Document doc = (Document)_docs.getAt(i);
            if (doc == null || nPageDocId == doc.getId()) continue;
            result.append("<Area");
            result.append(" coords='");
            result.append(this.calAreaCoords0(doc, nWidth, nHeight, zRectShape));
            result.append("'");
            result.append(" shape='").append(areaShape).append("'");
            content = PublishElementFactory.makeContentFrom(doc, folder);
            if (folder == null) {
                folder = content.getFolder();
            }
            linkUrl = compass.getHttpUrl(content, 0);
            if (zRelativeUrl) {
                linkUrl = HtmlUtil.calRelativePath(linkUrl, pagePath);
            }
            result.append(" href='").append(linkUrl).append("'");
            title = doc.getTitle();
            if (zTruncated && title.length() > nTruncatedLen) {
                title = title.substring(0, nTruncatedLen);
                title = title + sTruncatedFlag;
            }
            result.append(" title='").append(title).append("'");
            result.append(">");
        }
        return result.toString();
    }

    protected String calAreaCoords0(Document _doc, int _width, int _height, boolean _zRectShape) {
        float width = _width;
        float height = _height;
        String coordssrc = _doc.getPropertyAsString("MAP");
        if (CMyString.isEmpty(coordssrc)) {
            return "";
        }
        String[] coords = coordssrc.split(",");
        int temp = 0;
        StringBuffer result = new StringBuffer(128);
        for (int i = 0; i < coords.length; ++i) {
            result.append(",");
            temp = (i & 1) == 0 ? (int)(width * this.parseFloat(coords[i])) : (int)(height * this.parseFloat(coords[i]));
            result.append(temp);
        }
        if (_zRectShape) {
            _zRectShape = !_zRectShape;
        }
        return result.substring(1);
    }

    protected String calAreaCoords(Document _doc, int _width, int _height, boolean _zRectShape) {
        float width = _width;
        float height = _height;
        StringBuffer result = new StringBuffer(128);
        String coordssrc = _doc.getPropertyAsString("MAP");
        if (coordssrc == null || coordssrc.trim().length() == 0) {
            return "";
        }
        String[] coords = coordssrc.split(";");
        String[] temp = null;
        int[] intTemp = new int[4];
        int xMin = _width;
        int xMax = 0;
        int yMin = _height;
        int yMax = 0;
        for (int i = 0; i < coords.length; ++i) {
            int j;
            temp = coords[i].split(",");
            for (j = 0; j < 4; ++j) {
                intTemp[0] = (int)(this.parseFloat(temp[0]) * width);
                intTemp[1] = (int)(this.parseFloat(temp[1]) * height);
                intTemp[2] = (int)(this.parseFloat(temp[2]) * width + (float)intTemp[0]);
                intTemp[3] = (int)(this.parseFloat(temp[3]) * height + (float)intTemp[1]);
            }
            if (_zRectShape) {
                if (xMin > intTemp[0]) {
                    xMin = intTemp[0];
                }
                if (xMax < intTemp[2]) {
                    xMax = intTemp[2];
                }
                if (yMin > intTemp[1]) {
                    yMin = intTemp[1];
                }
                if (yMax >= intTemp[3]) continue;
                yMax = intTemp[3];
                continue;
            }
            for (j = 0; j < intTemp.length; ++j) {
                result.append(",").append(intTemp[j]);
            }
        }
        if (_zRectShape) {
            result.append(xMin).append(",").append(yMin).append(",");
            result.append(xMax + 1).append(",").append(yMax + 2);
            return result.toString();
        }
        return result.substring(1);
    }

    private float parseFloat(String s) {
        try {
            if (!s.endsWith("%")) {
                s = s + "%";
            }
            return this.m_floatParser.parse(s).floatValue();
        }
        catch (ParseException e) {
            return 0.0f;
        }
    }

    public void clear() {
        this.m_floatParser = null;
    }

    public static void main(String[] args) {
    }
}

