/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.store.FileService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EPressConf {
    public static final String ATTR_HAS_COVERPAGE = "hascoverpage";
    private static final String TRSWCMEPRESS_CONF = "/TRSWCMEPress.properties";
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private final String kEY_CHANNELS = "m_channels";
    private final String KEY_CONF = "m_conf";

    private EPressConf() {
        this.load();
    }

    private String getFullChannelsKey(String key) {
        return EPressConf.class.getName() + "." + "m_channels" + "." + key;
    }

    private String getFullConfKey() {
        return EPressConf.class.getName() + "." + "m_conf";
    }

    public static final EPressConf instance() {
        return InstanceHolder.INSTANCE;
    }

    public void add(String key, int parentid) throws WCMException {
        if (cache.exists(this.getFullChannelsKey(key)).booleanValue()) {
            throw new WCMException(10, "\u7cfb\u7edf\u5df2\u5b58\u5728\u6807\u8bc6\u4e3a[" + key + "]\u7684\u7535\u5b50\u62a5\u9891\u9053");
        }
        this.loadChannels(key, String.valueOf(parentid));
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getChannels(String key) {
        if (!this.existsEPress(key)) {
            return null;
        }
        Map channels = (Map)cache.get(this.getFullChannelsKey(key));
        if (channels != null && channels.isEmpty()) {
            Map map = channels;
            synchronized (map) {
                try {
                    this.loadChannels(key, (String)cache.hget(this.getFullConfKey(), key));
                }
                catch (WCMException wCMException) {
                    // empty catch block
                }
            }
            channels = (Map)cache.get(this.getFullChannelsKey(key));
        }
        return channels;
    }

    public Map getChannels(int channelId) {
        if (!this.existsEPress(channelId)) {
            return null;
        }
        String sKey = this.getEPressKeyById(channelId);
        if (sKey != null) {
            return this.getChannels(sKey);
        }
        return null;
    }

    public boolean existsEPress(String uuid) {
        if (uuid == null) {
            return false;
        }
        String sId = (String)cache.hget(this.getFullConfKey(), uuid);
        Channel parent = null;
        if (sId != null) {
            try {
                parent = Channel.findById(Integer.parseInt(sId));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parent != null;
    }

    public boolean existsEPress(int channelId) {
        Channel parent = null;
        if (cache.hexists(this.getFullConfKey(), String.valueOf(channelId)).booleanValue()) {
            try {
                parent = Channel.findById(channelId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parent != null;
    }

    private String getEPressKeyById(int chnlId) {
        String sValue = String.valueOf(chnlId);
        if (cache.hexists(this.getFullConfKey(), sValue).booleanValue()) {
            return sValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        InputStream ins = null;
        try {
            Class<?> clazz = this.getClass();
            ins = clazz.getResourceAsStream(TRSWCMEPRESS_CONF);
            if (ins == null) {
                ins = clazz.getResourceAsStream(TRSWCMEPRESS_CONF.substring(1));
            }
            Properties props = new Properties();
            props.load(ins);
            Iterator<Object> keysItr = props.keySet().iterator();
            String key = null;
            while (keysItr.hasNext()) {
                key = (String)keysItr.next();
                this.loadChannels(key, props.getProperty(key));
            }
            props.clear();
        }
        catch (Exception exception) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void loadChannels(String key, String parent) throws WCMException {
        int id = Integer.parseInt(parent);
        Channel channel = Channel.findById(id);
        if (channel == null) {
            cache.clear(this.getFullConfKey());
            return;
        }
        cache.hset(this.getFullConfKey(), key, parent);
        List<Channel> list = channel.getChildren(null);
        int size = list.size();
        HashMap<String, Integer> channles = new HashMap<String, Integer>(size + 1);
        boolean zHasCoverPage = "true".equals(channel.getAttributeValue(ATTR_HAS_COVERPAGE));
        for (int i = 0; i < size; ++i) {
            channel = list.get(i);
            if (channel == null) continue;
            if (zHasCoverPage) {
                channles.put(String.valueOf(i), channel.getKey());
                continue;
            }
            channles.put(String.valueOf(i + 1), channel.getKey());
        }
        list.clear();
        cache.set(this.getFullChannelsKey(key), channles);
    }

    public void reload() {
        this.load();
    }

    private synchronized void save() throws WCMException {
        Properties props = new Properties();
        Set<Object> keySet = cache.hkeys(this.getFullConfKey());
        Iterator<Object> itrKeys = keySet.iterator();
        String propKey = null;
        while (itrKeys.hasNext()) {
            propKey = (String)itrKeys.next();
            props.setProperty(propKey, (String)cache.get(propKey));
        }
        OutputStream fos = null;
        try {
            Class<?> clazz = this.getClass();
            URL confFile = clazz.getResource(TRSWCMEPRESS_CONF);
            fos = new FileService(confFile.getFile()).getOutputStream();
            props.store(fos, CMyDateTime.now().toString("yyyy-MM-dd HH:mm"));
        }
        catch (Exception e) {
            throw new WCMException(50, "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            props.clear();
        }
    }

    public String toXml(String root) {
        if (root == null || root.trim().length() == 0) {
            root = "target";
        }
        StringBuffer buff = new StringBuffer(128);
        Set<Object> keySet = cache.hkeys(this.getFullConfKey());
        Iterator<Object> keysItr = keySet.iterator();
        String sKey = null;
        String sId = null;
        int iId = 0;
        Channel channel = null;
        buff.append("<?xml version=\"1.0\" encoding=\"GBK\"?>");
        buff.append("<");
        buff.append(root).append("s");
        buff.append(">");
        while (keysItr.hasNext()) {
            sKey = (String)keysItr.next();
            sId = (String)cache.get(sKey);
            try {
                iId = Integer.parseInt(sId);
                channel = Channel.findById(iId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (channel == null) continue;
            buff.append("<");
            buff.append(root);
            buff.append(">");
            buff.append("<desc><![CDATA[");
            buff.append(channel.getDesc());
            buff.append("]]></desc>");
            buff.append("<uuid>");
            buff.append(sKey);
            buff.append("</uuid>");
            buff.append("</");
            buff.append(root);
            buff.append(">");
        }
        buff.append("</");
        buff.append(root).append("s");
        buff.append(">");
        return buff.toString();
    }

    Iterator itrEPressChnlIds() {
        Set<Object> keySet = cache.hkeys(this.getFullConfKey());
        HashMap<Object, Object> m_conf = new HashMap<Object, Object>(5, 0.2f);
        for (Object str : keySet) {
            m_conf.put(str, cache.hget(this.getFullConfKey(), str));
        }
        return m_conf.values().iterator();
    }

    public void notifyOnDelObj(BaseObj objDeleted) {
        if (objDeleted == null || objDeleted.getWCMType() != 101) {
            return;
        }
        String id = String.valueOf(objDeleted.getId());
        if (cache.hexists(this.getFullConfKey(), id).booleanValue()) {
            Set<Object> keySet = cache.hkeys(this.getFullConfKey());
            Iterator<Object> itr = keySet.iterator();
            String key = null;
            while (itr.hasNext()) {
                key = (String)itr.next();
                if (!id.equals((String)cache.get(key))) continue;
                cache.clear(key);
                cache.clear(key);
                break;
            }
        }
    }

    private static class InstanceHolder {
        static final EPressConf INSTANCE = new EPressConf();

        private InstanceHolder() {
        }
    }
}

