/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.center.ClassInfoViewMgr;
import com.trs.components.metadata.center.IClassInfoViewMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoMgr;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.components.metadata.service.ClassInfoViewService;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.HashMap;

public class ClassInfoViewServiceProvider
implements ISelfDefinedServiceProvider {
    private ClassInfoViewService m_oClassInfoViewServices = null;
    private IClassInfoViewMgr m_oClassInfoViewMgr = null;
    private ClassInfoMgr m_oClassInfoMgr = new ClassInfoMgr();
    private PublishServer m_oPublishServer = null;
    private TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");

    public ClassInfoViewServiceProvider() {
        this.m_oClassInfoViewServices = new ClassInfoViewService();
        this.m_oPublishServer = PublishServer.getInstance();
        this.m_oClassInfoViewMgr = (ClassInfoViewMgr)DreamFactory.createObjectById("IClassInfoViewMgr");
    }

    public MetaViews queryViews(MethodContext _methodContext) throws Throwable {
        User _currUser = this.getLoginUser();
        String sClassInfoId = _methodContext.getValue("classInfoId");
        boolean _bContainChildClassInfo = _methodContext.getValue("withChildren", false);
        return this.m_oClassInfoViewServices.queryViews(_currUser, sClassInfoId, _methodContext.getExtraWCMFilter(), _bContainChildClassInfo);
    }

    public MetaViews queryViewsByClassInfo(MethodContext _methodContext) throws Throwable {
        ClassInfo oClassInfo;
        User currUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter();
        String sWhere = "select 1 from XWCMViewFieldInfo where XWCMViewInfo.ViewInfoId = XWCMViewFieldInfo.ViewId and XWCMViewFieldInfo.FieldType=?";
        filter.addSearchValues(10);
        int nClassInfoId = _methodContext.getValue("ClassInfoId", 0);
        if (nClassInfoId != 0 && (oClassInfo = ClassInfo.findById(nClassInfoId)) != null) {
            sWhere = sWhere + " and XWCMViewFieldInfo.ClassId=?";
            filter.addSearchValues(oClassInfo.getRootId());
        }
        filter.setWhere("exists (" + sWhere + ")");
        return MetaViews.openWCMObjs(currUser, filter);
    }

    public Documents queryDocuments(MethodContext _methodContext) throws Throwable {
        User _currUser = this.getLoginUser();
        String sClassInfoId = _methodContext.getValue("classInfoId");
        boolean _bContainChildClassInfo = _methodContext.getValue("withChildren", false);
        WCMFilter filter = new WCMFilter(null, null, "crtime desc", null);
        int nViewId = _methodContext.getValue("viewId", 0);
        String sDocTitle = _methodContext.getValue("docTitle");
        if (nViewId != 0 && sDocTitle != null) {
            filter.setWhere("docKind=? and docTitle like ?");
            filter.addSearchValues(nViewId);
            filter.addSearchValues("%" + sDocTitle + "%");
        } else if (nViewId != 0) {
            filter.setWhere("docKind=?");
            filter.addSearchValues(nViewId);
        } else if (sDocTitle != null) {
            filter.setWhere("docTitle like ?");
            filter.addSearchValues("%" + sDocTitle + "%");
        }
        Documents documents = this.m_oClassInfoViewServices.queryDocuments(_currUser, sClassInfoId, filter, _bContainChildClassInfo);
        this.extendDocumentProperties(_methodContext, documents);
        return documents;
    }

    public ClassInfos queryClassInfos(MethodContext _methodContext) throws Throwable {
        User _currUser = this.getLoginUser();
        String sDocumentIds = _methodContext.getValue("docId");
        if (CMyString.isEmpty(sDocumentIds) && CMyString.isEmpty(sDocumentIds = _methodContext.getValue("docIds"))) {
            throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label1", "\u6ca1\u6709\u6307\u5b9a\u53c2\u6570docId/docIds"));
        }
        WCMFilter oFilter = new WCMFilter();
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("ClassInfoId in (");
        sbWhere.append("select ClassInfoId from XWCMClassInfoView");
        sbWhere.append(" where MetaDataId in (");
        sbWhere.append(this.getSQLByIds(oFilter, sDocumentIds));
        sbWhere.append(")");
        int nClassInfoId = _methodContext.getValue("classInfoId", 0);
        if (nClassInfoId != 0) {
            ClassInfo oClassInfo = ClassInfo.findById(nClassInfoId);
            if (oClassInfo == null) {
                throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label2", "\u6307\u5b9a\u7684\u5206\u7c7b\u5df2\u7ecf\u5220\u9664\uff0c\u5206\u7c7bID[") + nClassInfoId + "]");
            }
            String sIds = String.valueOf(nClassInfoId);
            String sChildrendIds = this.m_oClassInfoMgr.queryChildrenWithAllLevel(_currUser, oClassInfo, null);
            if (sChildrendIds != null) {
                sIds = sIds + "," + sChildrendIds;
            }
            sbWhere.append(" and ClassInfoId in (");
            sbWhere.append(this.getSQLByIds(oFilter, sIds));
            sbWhere.append(")");
        }
        sbWhere.append(")");
        oFilter.setWhere(sbWhere.toString());
        return ClassInfos.openWCMObjs(_currUser, oFilter);
    }

    public ClassInfos queryClassInfos1(MethodContext _methodContext) throws Throwable {
        User _currUser = this.getLoginUser();
        String sDocumentIds = _methodContext.getValue("docId");
        if (CMyString.isEmpty(sDocumentIds) && CMyString.isEmpty(sDocumentIds = _methodContext.getValue("docIds"))) {
            throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label1", "\u6ca1\u6709\u6307\u5b9a\u53c2\u6570docId/docIds"));
        }
        WCMFilter oFilter = null;
        int nClassInfoId = _methodContext.getValue("classInfoId", 0);
        if (nClassInfoId != 0) {
            ClassInfo oClassInfo = ClassInfo.findById(nClassInfoId);
            if (oClassInfo == null) {
                throw new WCMException(I18NMessage.get(ClassInfoViewServiceProvider.class, "ClassInfoViewServiceProvider.label2", "\u6307\u5b9a\u7684\u5206\u7c7b\u5df2\u7ecf\u5220\u9664\uff0c\u5206\u7c7bID[") + nClassInfoId + "]");
            }
            String sIds = String.valueOf(nClassInfoId);
            String sChildrendIds = this.m_oClassInfoMgr.queryChildrenWithAllLevel(_currUser, oClassInfo, null);
            if (sChildrendIds != null) {
                sIds = sIds + "," + sChildrendIds;
            }
            oFilter = new WCMFilter();
            StringBuffer sbWhere = this.getSQLByIds(oFilter, sIds);
            sbWhere.append(")");
            sbWhere.insert(0, "ClassInfoId in (");
            oFilter.setWhere(sbWhere.toString());
        }
        return this.m_oClassInfoViewServices.queryClassInfos(_currUser, sDocumentIds, oFilter);
    }

    private StringBuffer getSQLByIds(WCMFilter _oFilter, String _sIds) {
        String[] aIds = _sIds.split(",");
        StringBuffer sbWhere = new StringBuffer(aIds.length * 2);
        for (int i = 0; i < aIds.length; ++i) {
            sbWhere.append("?,");
            _oFilter.addSearchValues(aIds[i]);
        }
        if (sbWhere.length() > 0) {
            sbWhere.setLength(sbWhere.length() - 1);
        }
        return sbWhere;
    }

    public String queryDocNumMapping(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        HashMap<String, Integer> oDocNumWithChild = new HashMap<String, Integer>();
        WCMFilter filter = null;
        String docTitle = _methodContext.getValue("docTitle");
        if (docTitle != null && docTitle.length() >= 0) {
            filter = new WCMFilter();
            String sWhere = "MetaDataId in (select docId from WCMDocument where docTitle like ?)";
            filter.setWhere(sWhere);
            filter.addSearchValues("%" + docTitle + "%");
        }
        ClassInfos oClassInfos = null;
        String sClassInfoIds = _methodContext.getValue("classInfoIds");
        if (sClassInfoIds != null) {
            oClassInfos = ClassInfos.findByIds(loginUser, sClassInfoIds);
        } else {
            ClassInfo _oClassInfo = null;
            String sClassInfoId = _methodContext.getValue("classInfoId");
            if (sClassInfoId != null) {
                _oClassInfo = ClassInfo.findById(Integer.parseInt(sClassInfoId));
            }
            if (_oClassInfo == null) {
                oDocNumWithChild.put("0", new Integer(this.m_oClassInfoViewMgr.queryDocumentNum(loginUser, null, filter)));
            }
            oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, _oClassInfo, null);
        }
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo oClassInfo = (ClassInfo)oClassInfos.getAt(i);
            if (oClassInfo == null) continue;
            oDocNumWithChild.put(String.valueOf(oClassInfo.getId()), new Integer(this.m_oClassInfoViewMgr.queryDocumentNum(loginUser, oClassInfo, filter)));
        }
        if (oDocNumWithChild.size() == 0) {
            oDocNumWithChild.put("NoObject", new Integer(0));
        }
        _methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(oDocNumWithChild, 0);
    }

    public String queryDocNumMapping2(MethodContext _methodContext) throws Throwable {
        HashMap oDocNumWithChild = new HashMap();
        String sSQL = "Select ClassInfoId, Count(distinct MetaDataId) As DocNum from XWCMClassInfoView Group By ClassInfoId";
        CMyResultSets oResoutSets = new CMyResultSets();
        oResoutSets.open(sSQL, "ClassInfoId");
        ClassInfo oClassInfo = ClassInfo.findById(_methodContext.getValue("classInfoId", 0));
        this.queryDocNumMapping(oDocNumWithChild, oClassInfo, oResoutSets);
        _methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(oDocNumWithChild, 0);
    }

    private int queryDocNumMapping(HashMap _oDocNumWithChild, ClassInfo _oClassInfo, CMyResultSets oResoutSets) throws WCMException {
        User loginUser = this.getLoginUser();
        int docNum = 0;
        ClassInfos _oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, _oClassInfo, null);
        int _nSize = _oClassInfos.size();
        for (int j = 0; j < _nSize; ++j) {
            ClassInfo oClassInfo = (ClassInfo)_oClassInfos.getAt(j);
            if (oClassInfo == null) continue;
            docNum += this.queryDocNumMapping(_oDocNumWithChild, oClassInfo, oResoutSets);
        }
        if (_oClassInfo == null) {
            _oDocNumWithChild.put("0", new Integer(docNum));
        } else {
            BaseObj aObj = oResoutSets.getById(_oClassInfo.getId());
            if (aObj != null) {
                docNum += aObj.getPropertyAsInt("DocNum", 0);
            }
            _oDocNumWithChild.put(String.valueOf(_oClassInfo.getId()), new Integer(docNum));
        }
        return docNum;
    }

    public String preview(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ClassInfos oClassInfos = null;
        int nParentId = _methodContext.getValue("ParentId", 0);
        if (nParentId > 0) {
            ClassInfo parent = ClassInfo.findById(nParentId);
            if (parent != null && parent.isRoot()) {
                WCMFilter filter = new WCMFilter("", "RootId=?", "");
                filter.addSearchValues(nParentId);
                oClassInfos = ClassInfos.openWCMObjs(loginUser, filter);
            } else {
                oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, parent, null);
            }
        }
        String[] pWarning = new String[1];
        HashMap<String, Object> hResult = new HashMap<String, Object>(2);
        int nURLCount = 0;
        Object[] pResult = new Object[oClassInfos.size()];
        HashMap<String, Object> hTemp = null;
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            String[] pURL;
            hTemp = new HashMap<String, Object>(2);
            ClassInfo classInfo = (ClassInfo)oClassInfos.getAt(i);
            hTemp.put("Name", classInfo.getName());
            PublishFolderClassImpl folder = (PublishFolderClassImpl)PublishElementFactory.makeElementFrom(classInfo);
            this.employMgr.setOutlineTemplates(folder, _methodContext.getValue("TemplateIds"), true);
            try {
                pURL = this.m_oPublishServer.previewFolder(folder, pWarning);
                if (pWarning[0] != null) {
                    hTemp.put("Warning", pWarning[0]);
                }
            }
            catch (Exception e) {
                pURL = new String[]{};
                int nPos = e.getMessage().indexOf(10);
                String sMessage = e.getMessage();
                if (nPos > 0) {
                    sMessage = sMessage.substring(0, nPos);
                }
                hTemp.put("Exception", sMessage);
                hTemp.put("ExceptionDetail", CMyException.getStackTraceText(e));
            }
            nURLCount += pURL.length;
            hTemp.put("URLs", pURL);
            pResult[i] = hTemp;
        }
        hResult.put("URLCount", String.valueOf(nURLCount));
        hResult.put("Data", pResult);
        _methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hResult, 0);
    }

    public void publish(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseObjs oClassInfos = null;
        int nParentId = _methodContext.getValue("ParentId", 0);
        if (nParentId > 0) {
            ClassInfo parent = ClassInfo.findById(nParentId);
            if (parent != null && parent.isRoot()) {
                WCMFilter filter = new WCMFilter("", "RootId=?", "");
                filter.addSearchValues(nParentId);
                oClassInfos = ClassInfos.openWCMObjs(loginUser, filter);
            } else {
                oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, parent, null);
            }
        }
        Object[] pResult = new Object[oClassInfos.size()];
        HashMap<String, String> hTemp = null;
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            hTemp = new HashMap<String, String>(2);
            ClassInfo classInfo = (ClassInfo)oClassInfos.getAt(i);
            hTemp.put("Name", classInfo.getName());
            PublishFolderClassImpl folder = (PublishFolderClassImpl)PublishElementFactory.makeElementFrom(classInfo);
            this.employMgr.setOutlineTemplates(folder, _methodContext.getValue("TemplateIds"), true);
            this.m_oPublishServer.publishFolder(folder, 8);
            pResult[i] = hTemp;
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void extendDocumentProperties(MethodContext _methodContext, Documents _documents) throws WCMException {
        if (_documents == null || _documents.isEmpty()) {
            return;
        }
        HashMap<Integer, MetaView> viewsHashMap = new HashMap<Integer, MetaView>(20);
        int nPageSize = -1;
        int nPageIndex = 1;
        if (_methodContext != null) {
            nPageSize = _methodContext.getPageSize();
            nPageIndex = _methodContext.getPageIndex();
        }
        CPager currPager = new CPager(nPageSize);
        currPager.setCurrentPageIndex(nPageIndex);
        currPager.setItemCount(_documents.size());
        for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
            int viewId;
            Document document = (Document)_documents.getAt(i - 1);
            if (document == null || (viewId = document.getPropertyAsInt("DocKind", 0)) == 0) continue;
            Integer key = new Integer(viewId);
            MetaView metaView = (MetaView)viewsHashMap.get(key);
            if (metaView == null) {
                metaView = MetaView.findById(viewId);
                if (metaView == null) continue;
                viewsHashMap.put(key, metaView);
            }
            document.getProperties().put("VIEWDESC", metaView.getDesc());
            document.getProperties().put("VIEWNAME", metaView.getName());
        }
    }
}

