/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyString;
import java.util.regex.Pattern;

public class MetaDBFieldListenerForChannelSynRule
implements IObjectLCListenerOnModify {
    private IMetaDataDefMgr m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
    private IMetaViewEmployerMgr m_MetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof MetaDBField)) {
            return;
        }
        MetaDBField oMataDBField = (MetaDBField)_oObjModified;
        if (!oMataDBField.isChangeProperty("fieldName")) {
            return;
        }
        String sOldFieldName = oMataDBField.getPropertyAsString("fieldName");
        String sNewFieldName = oMataDBField.getNewPropertyAsString("fieldName");
        MetaViews oViews = this.m_oMetaDataDefMgr.getViewsUsingField(null, oMataDBField);
        int nSize = oViews.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView oView = (MetaView)oViews.getAt(i);
            if (oView == null) continue;
            Channels oChannels = this.m_MetaViewEmployerMgr.getEmployers(oView, null);
            int nInnerSize = oChannels.size();
            for (int j = 0; j < nInnerSize; ++j) {
                Channel oChannel = (Channel)oChannels.getAt(j);
                if (oChannel == null) continue;
                this.replace(oChannel, "docTitle", sOldFieldName, sNewFieldName);
                this.replace(oChannel, "docContent", sOldFieldName, sNewFieldName);
                oChannel.save();
            }
        }
    }

    private void replace(Channel _oChannel, String _sAttrName, String _sOldValue, String _sNewValue) throws WCMException {
        String attrValue = _oChannel.getAttributeValue(_sAttrName);
        if (!CMyString.isEmpty(attrValue)) {
            String newAttrValue = Pattern.compile("\\$\\{" + _sOldValue + "\\}", 2).matcher(attrValue).replaceAll("\\$\\{" + _sNewValue + "\\}");
            _oChannel.setAttribute(_sAttrName, newAttrValue);
        }
    }
}

