/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoCacheMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class ClassInfo
extends CMSObj {
    private static final long serialVersionUID = 1L;
    public static final int OBJ_TYPE = 694710472;
    public static final String DB_TABLE_NAME = "XWCMCLASSINFO";
    public static final String DB_ID_NAME = "CLASSINFOID";
    private static final String QUERY_HAS_CHILDREN = "select 1 from XWCMClassInfo where ParentId=?";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 694710472;
    }

    public String getName() {
        return this.getPropertyAsString("CNAME");
    }

    public boolean setName(String _sName) throws WCMException {
        return this.setProperty("CNAME", _sName);
    }

    public String getDesc() {
        return this.getPropertyAsString("CDESC");
    }

    public boolean setDesc(String _sDesc) throws WCMException {
        return this.setProperty("CDESC", _sDesc);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public ClassInfo getParent() throws WCMException {
        return ClassInfo.findById(this.getParentId());
    }

    public boolean setParentId(int _nParentId) throws WCMException {
        return this.setProperty("PARENTID", _nParentId);
    }

    public int getRootId() {
        if (this.isRoot()) {
            return this.getId();
        }
        return this.getPropertyAsInt("ROOTID", 0);
    }

    public boolean setOrder(int _nOrder) throws WCMException {
        return this.setProperty("ClassOrder", _nOrder);
    }

    public int getOrder() {
        return this.getPropertyAsInt("ClassOrder", 0);
    }

    public boolean setRootId(int _nRootId) throws WCMException {
        return this.setProperty("ROOTID", _nRootId);
    }

    public String getCode() {
        return this.getPropertyAsString("CCODE");
    }

    public boolean setCode(String _sCode) throws WCMException {
        return this.setProperty("CCODE", _sCode);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("CNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(ClassInfo.class, "ClassInfo.label1", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(ClassInfo.isValid)"));
            }
            if (this.getProperty("ROOTID") == null) {
                throw new WCMException(1106, I18NMessage.get(ClassInfo.class, "ClassInfo.label2", "\u5c5e\u6027RootId\u6ca1\u6709\u8bbe\u7f6e(ClassInfo.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ClassInfo.class, "ClassInfo.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ClassInfo.isValid)"));
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            if (this.getProperty("ParentId") == null) {
                this.setParentId(0);
            }
            super.insert(_currUser);
        }
    }

    public boolean isRoot() {
        return this.getParentId() == 0;
    }

    public boolean isLeaf() throws WCMException {
        int nResult = DBManager.getDBManager().sqlExecuteIntQuery(QUERY_HAS_CHILDREN, new int[]{this.getId()});
        return nResult != 1;
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("ClassOrder")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("ClassOrder", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (this.isChangeProperty("PARENTID")) {
                    nNewOrder = nMaxOrder + 1;
                } else if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = --nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "ClassOrder>=" + nMoveBeginAt + " AND ClassOrder <= " + nMoveEndAt + " and ParentId=" + this.getNewParentId();
        String sMoveSql = "UPDATE XWCMCLASSINFO SET ClassOrder = ClassOrder+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        ClassInfos oClassInfos = null;
        if (this.isCached()) {
            WCMFilter aFilter = new WCMFilter("", sRegionWhere, "ClassOrder desc");
            oClassInfos = ClassInfos.openWCMObjs(null, aFilter);
        }
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        if (this.isCached() && oClassInfos != null) {
            for (int i = 0; i < oClassInfos.size(); ++i) {
                ClassInfo oClassInfo = (ClassInfo)oClassInfos.getAt(i);
                if (oClassInfo == null) continue;
                oClassInfo.refreshProperty("ClassOrder", oClassInfo.getOrder() + nMoveDirection);
            }
        }
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(ClassOrder) from XWCMCLASSINFO where ParentId=?";
        int nParentId = this.getNewParentId();
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(ClassOrder) from XWCMCLASSINFO where ParentId=?", new int[]{nParentId});
    }

    public static int getMaxOrder(int _nParentId) throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(ClassOrder) from XWCMCLASSINFO where ParentId=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(ClassOrder) from XWCMCLASSINFO where ParentId=?", new int[]{_nParentId});
    }

    private int getNewParentId() {
        int nParentId = this.getParentId();
        if (this.isChangeProperty("PARENTID")) {
            nParentId = this.getNewPropertyAsInt("PARENTID", 0);
        }
        return nParentId;
    }

    public static final ClassInfo findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (ClassInfo)BaseObj.findById(ClassInfo.class, _nId);
    }

    public static final ClassInfo createNewInstance() throws WCMException {
        return (ClassInfo)BaseObj.createNewInstance(ClassInfo.class);
    }

    public static final ClassInfo findByKey(Object _oKey) throws WCMException {
        return (ClassInfo)BaseObj.findByKey(ClassInfo.class, _oKey);
    }

    @Override
    public String toString() {
        return this.getName() + "[ID=" + this.getId() + "]";
    }

    public ClassInfos getChildren() throws WCMException {
        return this.getChildren(false);
    }

    public ClassInfos getChildren(boolean _bNotMakeNewObjs) throws WCMException {
        IClassInfoCacheMgr classInfoCacheMgr = (IClassInfoCacheMgr)DreamFactory.createObjectById("IClassInfoCacheMgr");
        return classInfoCacheMgr.getChildren(this.getId(), _bNotMakeNewObjs);
    }

    public static ClassInfos findRootClassInfos() throws WCMException {
        return ClassInfo.findRootClassInfos(false);
    }

    public static ClassInfos findRootClassInfos(boolean _bNotMakeNewObjs) throws WCMException {
        IClassInfoCacheMgr classInfoCacheMgr = (IClassInfoCacheMgr)DreamFactory.createObjectById("IClassInfoCacheMgr");
        return classInfoCacheMgr.getChildren(0, _bNotMakeNewObjs);
    }

    public static ClassInfo findByName(String _sClassInfoName) throws WCMException {
        if (CMyString.isEmpty(_sClassInfoName)) {
            return null;
        }
        IClassInfoCacheMgr classInfoCacheMgr = (IClassInfoCacheMgr)DreamFactory.createObjectById("IClassInfoCacheMgr");
        ClassInfo classInfo = classInfoCacheMgr.findClassInfoByName(_sClassInfoName);
        if (classInfo != null) {
            return classInfo;
        }
        WCMFilter filterByName = new WCMFilter("", "CName=?", "");
        filterByName.setMaxRowNumber(1);
        filterByName.addSearchValues(_sClassInfoName);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, filterByName);
        if (classInfos.isEmpty()) {
            return null;
        }
        return (ClassInfo)classInfos.getAt(0);
    }
}

