/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center.xml;

import com.trs.DreamFactory;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverterForSpecialProperty;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MetaViewDataToXML
extends BaseObjToXmlConverterForSpecialProperty {
    private static Logger logger = Logger.getLogger(MetaViewDataToXML.class);
    private IMetaDataDefCacheMgr m_oCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private MetaView m_oView = null;
    private ArrayList m_arAppFiles = new ArrayList();

    public MetaViewDataToXML(MetaView _view) {
        this.m_oView = _view;
    }

    public ArrayList getAppFiles() {
        return this.m_arAppFiles;
    }

    @Override
    protected String[][] getSpecialProperty(BaseObj _currObj, int _nPropertyId, String _sPropertyName, Object _currValue) throws ConvertException {
        try {
            MetaViewField viewField = this.m_oCacheMgr.getMetaViewField(this.m_oView.getId(), _sPropertyName);
            if (viewField == null) {
                return null;
            }
            switch (viewField.getType()) {
                case 8: {
                    MetaViewData.FieldAppendix[] oFieldAppendixes = MetaViewData.getFieldAppendixes(_currValue.toString());
                    for (int i = 0; i < oFieldAppendixes.length; ++i) {
                        this.m_arAppFiles.add(oFieldAppendixes[i].getName());
                    }
                    break;
                }
                case 12: 
                case 16: {
                    HTMLContent htmlContent = new HTMLContent(_currValue.toString());
                    this.m_arAppFiles.addAll(htmlContent.getWCMFiles());
                    MetaViewData viewData = (MetaViewData)_currObj;
                    String textValue = viewData.getRealProperty(_sPropertyName);
                    boolean bExcludeStyle4HTML = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("EXPORT_METADATA_WITHOUTSTYLE", "false"));
                    if (bExcludeStyle4HTML) {
                        textValue = CMyString.excludeTag("style", textValue);
                    }
                    return new String[][]{{textValue}};
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception to record files!", (Throwable)e);
        }
        try {
            MetaViewData viewData = (MetaViewData)_currObj;
            return new String[][]{{"RealValue", viewData.getRealProperty(_sPropertyName)}};
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(MetaViewDataToXML.class, "MetaViewDataToXML.label1", "\u8f6c\u6362[") + _sPropertyName + I18NMessage.get(MetaViewDataToXML.class, "MetaViewDataToXML.label2", "]\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected void registerHostSpecialProperties() {
        HashMap hFields = null;
        try {
            hFields = this.m_oCacheMgr.getMetaViewFields(this.m_oView.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int nIndex = 1;
        for (MetaViewField viewField : hFields.values()) {
            block6: {
                switch (viewField.getType()) {
                    case -1: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 16: {
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                this.registerHostSpecialProperty(viewField.getName(), nIndex);
            }
            ++nIndex;
        }
    }

    @Override
    protected Element toXmlElement(BaseObj obj, String fieldsList) throws WCMException {
        Element currElement = super.toXmlElement(obj, fieldsList);
        currElement.element("PROPERTIES").addElement("CHNLNAME");
        MetaViewData currMetaViewData = (MetaViewData)obj;
        if (currMetaViewData != null) {
            String sChnlName = currMetaViewData.getChannel().getName();
            currElement.element("PROPERTIES").element("CHNLNAME").addCDATA(sChnlName);
        }
        return currElement;
    }

    @Override
    protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
        MetaViewData viewData = (MetaViewData)_baseObj;
        Document document = Document.findById(viewData.getMetaDataId());
        if (document == null) {
            logger.error((Object)(I18NMessage.get(MetaViewDataToXML.class, "MetaViewDataToXML.label3", "\u6570\u636e\u53ef\u80fd\u6709\u8bef\uff0c\u6240\u5c5e\u6587\u6863\u4e0d\u5b58\u5728\uff01[ID=") + viewData.getMetaDataId() + "]"));
            return null;
        }
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes appendixes = appendixMgr.getAppendixes(document, -1);
        appendixes.setMaxBufferSize(appendixes.size());
        int nSize = appendixes.size();
        for (int i = 0; i < nSize; ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || appendix.getFlag() == 40) continue;
            this.m_arAppFiles.add(appendix.getFile());
        }
        ObjToXmlConverter convertor = new ObjToXmlConverter();
        return new Element[]{convertor.toXmlElement(appendixes, null)};
    }

    @Override
    public String getElementTag(BaseObj _baseObj) {
        return "MetaViewData";
    }

    @Override
    public String getElementTag(BaseObjs _baseObjs) {
        return "MetaViewDataS";
    }
}

