/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewEmploy;
import com.trs.components.infoview.persistent.InfoViewEmploys;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import java.util.ArrayList;
import java.util.List;

public class InfoViewEmployMgr {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public int clearByInfoView(InfoView _oInfoView) throws WCMException {
        if (_oInfoView == null) {
            return 0;
        }
        return this.clearByInfoView(_oInfoView.getId());
    }

    public int clearByInfoView(int nInfoViewId) throws WCMException {
        WCMFilter filter = new WCMFilter("", "InfoViewID=?", "");
        filter.addSearchValues(0, nInfoViewId);
        InfoViewEmploys employs = new InfoViewEmploys(this.getLoginUser());
        employs.open(filter);
        int nRecord = employs.size();
        employs.removeAll(true);
        return nRecord;
    }

    public int clearByEmployer(CMSObj _oChnlOrSite) throws WCMException {
        if (_oChnlOrSite == null) {
            return 0;
        }
        return this.clearByEmployer(_oChnlOrSite.getWCMType(), _oChnlOrSite.getId());
    }

    public int clearByEmployer(int _nEmployerType, int _nEmployerId) throws WCMException {
        String sWhere = "EMPLOYERID=? AND EMPLOYERTYPE=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(0, _nEmployerId);
        filter.addSearchValues(1, _nEmployerType);
        InfoViewEmploys employs = new InfoViewEmploys(this.getLoginUser());
        employs.open(filter);
        int nRecord = employs.size();
        employs.removeAll(true);
        return nRecord;
    }

    public List getInfoViewEmployers(InfoView _employed) throws WCMException {
        if (_employed == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewEmployMgr.class, "InfoViewEmployMgr.label1", "\u65e0\u6548\u7684\u8868\u5355[null],\u65e0\u6cd5\u83b7\u53d6\u5176\u4f7f\u7528\u4f4d\u7f6e!"));
        }
        return this.getInfoViewEmployers(_employed.getId());
    }

    public List getInfoViewEmployers(int _iInfoViewID) throws WCMException {
        return this.getInfoViewEmployers(_iInfoViewID, null);
    }

    public List getInfoViewEmployers(int _iInfoViewID, WCMFilter _filter) throws WCMException {
        ArrayList<CMSObj> list = null;
        BaseObjs employs = null;
        try {
            String sWhere = "InfoViewID=" + _iInfoViewID;
            WCMFilter filter = new WCMFilter("", sWhere, "");
            if (_filter != null) {
                filter.mergeWith(_filter);
            }
            employs = new InfoViewEmploys(this.getLoginUser());
            employs.open(filter);
            list = new ArrayList<CMSObj>(employs.size());
            for (int i = 0; i < employs.size(); ++i) {
                InfoViewEmploy ive = (InfoViewEmploy)employs.getAt(i);
                if (ive == null) continue;
                list.add(ive.getEmployer());
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(InfoViewEmployMgr.class, "InfoViewEmployMgr.label2", "\u83b7\u53d6\u8868\u5355\u7684\u4f7f\u7528\u573a\u6240\u96c6\u5408\u51fa\u9519!"), ex);
        }
        finally {
            if (employs != null) {
                employs.clear();
            }
        }
        return list;
    }

    public List getEmployedInfoViews(CMSObj _employer) throws WCMException {
        if (_employer == null) {
            throw new WCMException(10, I18NMessage.get(InfoViewEmployMgr.class, "InfoViewEmployMgr.label3", "\u6307\u5b9a\u7684\u7ad9\u70b9/\u9891\u9053\u65e0\u6548\uff01"));
        }
        return this.getEmployedInfoViews(_employer.getWCMType(), _employer.getId());
    }

    public List getEmployedInfoViews(int _iEmployerType, int _iEmployerId) throws WCMException {
        return this.getEmployedInfoViews(_iEmployerType, _iEmployerId, null);
    }

    public List getEmployedInfoViews(int _iEmployerType, int _iEmployerId, WCMFilter _filter) throws WCMException {
        ArrayList<InfoView> list = null;
        InfoViewEmploys employs = null;
        try {
            StringBuffer buff = new StringBuffer(128);
            buff.append("EMPLOYERID=").append(_iEmployerId);
            buff.append(" AND EMPLOYERTYPE=").append(_iEmployerType);
            WCMFilter filter = new WCMFilter("", buff.toString(), "");
            if (_filter != null) {
                filter.mergeWith(_filter);
            }
            employs = new InfoViewEmploys(this.getLoginUser());
            employs.open(filter);
            list = new ArrayList<InfoView>(employs.size());
            for (int i = 0; i < employs.size(); ++i) {
                InfoViewEmploy ive = (InfoViewEmploy)employs.getAt(i);
                if (ive == null) continue;
                list.add(ive.getInfoView());
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to query template employs of the specified employer!", ex);
        }
        return list;
    }

    public void setEmployedInfoView(CMSObj _employer, int _iInfoViewID) throws WCMException {
        int[] ids = new int[]{_iInfoViewID};
        this.setEmployedInfoViews(_employer, ids);
    }

    public void setEmployedInfoViews(CMSObj _employer, int[] _iInfoViewIDs) throws WCMException {
        InfoViewEmploy ive;
        if (_iInfoViewIDs.length < 1) {
            this.clearByEmployer(_employer);
            return;
        }
        User oCurrentUser = ContextHelper.getLoginUser();
        StringBuffer buff = new StringBuffer();
        buff.append("EMPLOYERID=").append(_employer.getId());
        buff.append(" AND EMPLOYERTYPE=").append(_employer.getWCMType());
        WCMFilter filter = new WCMFilter("", buff.toString(), "");
        InfoViewEmploys employs = new InfoViewEmploys(oCurrentUser);
        employs.open(filter);
        for (int i = 0; i < employs.size(); ++i) {
            boolean zFound = false;
            ive = (InfoViewEmploy)employs.getAt(i);
            for (int j = 0; j < _iInfoViewIDs.length; ++j) {
                int iInfoViewID = _iInfoViewIDs[j];
                if (ive.getInfoViewId() != iInfoViewID) continue;
                zFound = true;
                _iInfoViewIDs[j] = 0;
            }
            if (zFound) continue;
            ive.delete(oCurrentUser);
        }
        for (int j = 0; j < _iInfoViewIDs.length; ++j) {
            int iInfoViewID = _iInfoViewIDs[j];
            if (iInfoViewID <= 0) continue;
            ive = new InfoViewEmploy();
            ive.setEmployer(_employer);
            ive.setInfoViewId(iInfoViewID);
            ive.save(oCurrentUser);
        }
    }
}

