/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.comment.domain.DocumentTopicRelationMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class DocumentTopic
extends CMSObj {
    public static final int OBJ_TYPE = 1723559682;
    public static final String DB_TABLE_NAME = "XWCMDOCUMENTTOPIC";
    public static final String DB_ID_NAME = "DOCUMENTTOPICID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1723559682;
    }

    public String getTitle() {
        return this.getPropertyAsString("TITLE");
    }

    public boolean setTitle(String _sTitle) throws WCMException {
        return this.setProperty("TITLE", _sTitle);
    }

    public String getUrl() {
        return this.getPropertyAsString("URL");
    }

    public boolean setUrl(String _sUrl) throws WCMException {
        return this.setProperty("URL", _sUrl);
    }

    public String getDescription() {
        return this.getPropertyAsString("DESCRIPTION");
    }

    public boolean setDescription(String _sDescription) throws WCMException {
        return this.setProperty("DESCRIPTION", _sDescription);
    }

    public int getCategory() {
        return this.getPropertyAsInt("CATEGORY", 0);
    }

    public boolean setCategory(int _nCategory) throws WCMException {
        return this.setProperty("CATEGORY", _nCategory);
    }

    public int getChannelId() {
        return this.getPropertyAsInt("CHANNELID", 0);
    }

    public boolean setChannelId(int _nChannelId) throws WCMException {
        return this.setProperty("CHANNELID", _nChannelId);
    }

    public Channel getChannel() {
        Channel result = null;
        try {
            result = Channel.findById(this.getChannelId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public WebSite getSite() {
        Channel oChannel = this.getChannel();
        if (oChannel != null) {
            try {
                return oChannel.getSite();
            }
            catch (WCMException wCMException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (!this.isAddMode() && !this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(DocumentTopic.class, "DocumentTopic.label1", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(DocumentTopic.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public static final DocumentTopic findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (DocumentTopic)BaseObj.findById(DocumentTopic.class, _nId);
    }

    public static final DocumentTopic createNewInstance() throws WCMException {
        return (DocumentTopic)BaseObj.createNewInstance(DocumentTopic.class);
    }

    public static final DocumentTopic findByKey(Object _oKey) throws WCMException {
        return (DocumentTopic)BaseObj.findByKey(DocumentTopic.class, _oKey);
    }

    @Override
    public void deleteOthersBeforeDelete() {
        super.deleteOthersBeforeDelete();
        DocumentTopicRelationMgr mgr = (DocumentTopicRelationMgr)DreamFactory.createObjectById("DocumentTopicRelationMgr");
        try {
            mgr.deleteTopicDocRelation(this.id);
        }
        catch (WCMException ex) {
            throw new RuntimeException("Failed to delete topicwith [ID=" + this.id + "], for you failed to delete the relation befor deleting this Topic", ex);
        }
    }
}

