/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.ckm;

import com.trs.DreamFactory;
import com.trs.ckm.soap.CollErrorInfoDetail;
import com.trs.components.ckm.ICKMServer;
import com.trs.components.ckm.PositionComparator;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.Reports;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.apache.log4j.Logger;

public class ICKMServerTest
extends TestCase {
    private static Logger logger = Logger.getLogger(ICKMServerTest.class);
    ICKMServer m_oCKMServer = (ICKMServer)DreamFactory.createObjectById("ICKMServer");

    public void testValidateCKMServer() {
        logger.error((Object)"testValidateCKMServer");
        String sServer = "localhost";
        String sPort = "8000";
        String sUserName = "admin";
        String sPassword = "admin";
        Reports reports = this.m_oCKMServer.validateCKMServer(sServer, sPort, sUserName, sPassword);
        ICKMServerTest.assertNotNull((Object)reports);
        ICKMServerTest.assertNotNull((Object)reports.getSucessedReporterAt(0));
    }

    public void testSetCKMServer() {
        String sServer = "127.0.0.1";
        String sPort = "8000";
        String sUserName = "admin";
        String sPassword = "admin";
        this.m_oCKMServer.setCKMServer(sServer, sPort, sUserName, sPassword);
        ICKMServerTest.assertEquals((String)"TRSCKMServer", (String)sServer, (String)this.m_oCKMServer.getCKMServerIP());
        ICKMServerTest.assertEquals((String)"TRSCKMServer Port", (String)sPort, (String)this.m_oCKMServer.getCKMServerPort());
        ICKMServerTest.assertEquals((String)"TRSCKMServer User", (String)sUserName, (String)this.m_oCKMServer.getCKMServerUserName());
        ICKMServerTest.assertEquals((String)"TRSCKMServer Password", (String)sPassword, (String)this.m_oCKMServer.getCKMServerPassword());
    }

    public void testEnableCKMService() {
        boolean bEnableSimSearch = false;
        boolean bEnableAutoExtract = true;
        boolean bEnableAutoCheck = true;
        this.m_oCKMServer.enableCKMService(bEnableSimSearch, bEnableAutoExtract, bEnableAutoCheck);
        ICKMServerTest.assertEquals((String)"bEnableSimSearch", (boolean)bEnableSimSearch, (boolean)this.m_oCKMServer.isEnableSimSearch());
        ICKMServerTest.assertEquals((String)"bEnableAutoExtract", (boolean)bEnableAutoExtract, (boolean)this.m_oCKMServer.isEnableAutoExtract());
        ICKMServerTest.assertEquals((String)"bEnableAutoCheck", (boolean)bEnableAutoCheck, (boolean)this.m_oCKMServer.isEnableAutoCheck());
    }

    public void testExtractAbstract() {
        try {
            String sContent = CMyFile.readFile("c://test_abstract_auto.txt", "GBK");
            String[] pResult = this.m_oCKMServer.extractAbstractAndKeywords(sContent);
            if (pResult != null) {
                logger.info((Object)"=========ABStract===========");
                logger.info((Object)pResult[0]);
                logger.info((Object)"=========Keywords===========");
                logger.info((Object)pResult[1]);
            }
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(ICKMServerTest.class, "ICKMServerTest.label1", "\u6d4b\u8bd5[testExtractAbstract]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
            ICKMServerTest.fail((String)(I18NMessage.get(ICKMServerTest.class, "ICKMServerTest.label2", "\u6d4b\u8bd5[testExtractAbstract]\u51fa\u73b0\u5f02\u5e38\uff01\n") + CMyException.getStackTraceText(ex)));
        }
    }

    private int getNextReplacePos(int _nErrorPos, String _sErrorWord, String _sContent) throws Exception {
        byte[] btContent = _sContent.getBytes("GB18030");
        byte[] btWord = _sErrorWord.getBytes("GB18030");
        int nCurrPos = _nErrorPos;
        int i = 0;
        while (i < btWord.length) {
            byte btTemp = btContent[nCurrPos];
            while (this.isIgnore(btTemp)) {
                btTemp = btContent[++nCurrPos];
            }
            if (btWord[i] != btTemp) {
                throw new WCMException(10, I18NMessage.get(ICKMServerTest.class, "ICKMServerTest.label3", "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u5b57\u7b26[_sErrorWord=") + _sErrorWord + ", nCurrPos=" + nCurrPos + ", i=" + i + ", ]");
            }
            ++i;
            ++nCurrPos;
        }
        return nCurrPos;
    }

    private boolean isIgnore(byte btTemp) {
        if (btTemp == 32) {
            return true;
        }
        if (btTemp == 13) {
            return true;
        }
        return btTemp == 10;
    }

    public void testCollate() {
        try {
            String sContent = CMyFile.readFile("e:\\ckmtest.txt", "GBK");
            this.m_oCKMServer.startup();
            CollErrorInfoDetail[] pResult = this.m_oCKMServer.collateText(sContent);
            List<CollErrorInfoDetail> list = Arrays.asList(pResult);
            Collections.sort(list, new PositionComparator());
            CollErrorInfoDetail detail = null;
            if (pResult != null) {
                int nErrorPos = 0;
                int nNextReplacePos = 0;
                int nLastErrorPos = 0;
                byte[] btContent = sContent.getBytes("GB18030");
                String sErrorInfo = "";
                String sErrorWord = "";
                StringBuffer sbReplaced = new StringBuffer();
                for (int i = 0; i < list.size(); ++i) {
                    detail = list.get(i);
                    if (detail == null) continue;
                    sErrorInfo = detail.geterrinfo();
                    sErrorWord = detail.getwordlist()[0].getword();
                    nErrorPos = detail.getwordlist()[0].getpos();
                    if (nErrorPos == nLastErrorPos || nErrorPos < 0 || nErrorPos < nNextReplacePos || nErrorPos > btContent.length) continue;
                    byte[] btRight = new byte[nErrorPos - nNextReplacePos];
                    int j = 0;
                    while (nNextReplacePos < nErrorPos) {
                        btRight[j] = btContent[nNextReplacePos];
                        ++nNextReplacePos;
                        ++j;
                    }
                    System.out.println(i);
                    System.out.println(sErrorWord);
                    System.out.println("[" + new String(btRight) + "]");
                    sbReplaced.append(new String(btRight, "GB18030"));
                    sbReplaced.append("<SPAN style=\"background-color:red; font-weight:bold\" ");
                    sbReplaced.append(" title=\"");
                    sbReplaced.append(sErrorInfo);
                    sbReplaced.append("\">");
                    sbReplaced.append(sErrorWord);
                    sbReplaced.append("</SPAN>");
                    nNextReplacePos = this.getNextReplacePos(nErrorPos, sErrorWord, sContent);
                    nLastErrorPos = nErrorPos;
                }
                if (nNextReplacePos < btContent.length) {
                    byte[] btRight = new byte[btContent.length - nNextReplacePos];
                    int j = 0;
                    while (nNextReplacePos < btContent.length) {
                        btRight[j] = btContent[nNextReplacePos];
                        ++nNextReplacePos;
                        ++j;
                    }
                    sbReplaced.append(new String(btRight, "GB18030"));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(ICKMServerTest.class, "ICKMServerTest.label1", "\u6d4b\u8bd5[testExtractAbstract]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
            ICKMServerTest.fail((String)(I18NMessage.get(ICKMServerTest.class, "ICKMServerTest.label2", "\u6d4b\u8bd5[testExtractAbstract]\u51fa\u73b0\u5f02\u5e38\uff01\n") + CMyException.getStackTraceText(ex)));
        }
    }

    public void testSimSearch() {
        try {
            Document document = Document.findById(718);
            Documents documents = this.m_oCKMServer.simSearch(document.getId(), document.getContent());
            int nSize = documents.size();
            for (int i = 0; i < nSize; ++i) {
                Document simDocument = (Document)documents.getAt(i);
                if (simDocument == null) continue;
                logger.info((Object)simDocument);
            }
        }
        catch (Exception ex) {
            logger.error((Object)I18NMessage.get(ICKMServerTest.class, "ICKMServerTest.label4", "\u6d4b\u8bd5[testSimSearch]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
            ICKMServerTest.fail((String)(I18NMessage.get(ICKMServerTest.class, "ICKMServerTest.label5", "\u6d4b\u8bd5[testSimSearch]\u51fa\u73b0\u5f02\u5e38\uff01\n") + CMyException.getStackTraceText(ex)));
        }
    }
}

