/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.infra.common.WCMException;

public class ContentProcessInfo {
    private boolean m_bEnd = false;
    private User m_oStartUser = null;
    private String m_sStartUserName = null;
    private Flow m_oContentFlow = null;
    private IFlowContent m_oContent = null;
    private Users m_oCurrToUsers = null;

    public ContentProcessInfo(boolean _bEnd, Flow _contentFlow, User _oStartUser) {
        this.m_bEnd = _bEnd;
        this.m_oStartUser = _oStartUser;
        this.m_sStartUserName = this.m_oStartUser.getName();
        this.m_oContentFlow = _contentFlow;
    }

    public ContentProcessInfo(boolean _bEnd, Flow _contentFlow, String _sUserName) {
        this.m_bEnd = _bEnd;
        this.m_sStartUserName = _sUserName;
        this.m_oContentFlow = _contentFlow;
    }

    public ContentProcessInfo(boolean _bEnd, IFlowContent _content, String _sUserName) throws WCMException {
        this.m_bEnd = _bEnd;
        this.m_sStartUserName = _sUserName;
        this.m_oContent = _content;
        this.m_oContentFlow = this.m_oContent.getOwnerFlow();
    }

    public ContentProcessInfo(boolean _bEnd, IFlowContent _content, String _sUserName, Users _oToUsers) throws WCMException {
        this.m_bEnd = _bEnd;
        this.m_sStartUserName = _sUserName;
        this.m_oContent = _content;
        this.m_oContentFlow = this.m_oContent.getOwnerFlow();
        this.m_oCurrToUsers = _oToUsers;
    }

    public boolean isEnd() {
        return this.m_bEnd;
    }

    public void setEnd(boolean end) {
        this.m_bEnd = end;
    }

    public Users getCurrToUses() {
        return this.m_oCurrToUsers;
    }

    public void setCurrToUses(Users _toUsers) {
        this.m_oCurrToUsers = _toUsers;
    }

    public User getStartUser() {
        if (this.m_oStartUser == null && this.m_sStartUserName != null) {
            this.m_oStartUser = User.findByName(this.m_sStartUserName);
            if (this.m_oStartUser == null) {
                this.m_sStartUserName = null;
            }
        }
        return this.m_oStartUser;
    }

    public void setStartUser(User startUser) {
        this.m_oStartUser = startUser;
    }

    public String getStartUserName() {
        return this.m_sStartUserName;
    }

    public void setStartUserName(String userName) {
        this.m_sStartUserName = userName;
    }

    public Flow getContentFlow() throws WCMException {
        if (this.m_oContentFlow == null) {
            this.m_oContentFlow = this.m_oContent.getOwnerFlow();
        }
        return this.m_oContentFlow;
    }

    public void setContentFlow(Flow contentFlow) {
        this.m_oContentFlow = contentFlow;
    }

    public int getContentFlowId() {
        if (this.m_oContentFlow == null) {
            return 0;
        }
        return this.m_oContentFlow.getId();
    }

    public IFlowContent getContent() {
        return this.m_oContent;
    }

    public void setContent(IFlowContent content) {
        this.m_oContent = content;
    }

    public boolean canReInFlow() throws WCMException {
        if (this.getContentFlow() == null) {
            return false;
        }
        if (!this.isEnd()) {
            return false;
        }
        return this.m_sStartUserName != null && this.m_sStartUserName.length() > 0;
    }

    public boolean canInFlow() throws WCMException {
        if (this.getContentFlow() == null) {
            return false;
        }
        return this.m_sStartUserName == null || this.m_sStartUserName.length() == 0;
    }

    public boolean canStopFlow() {
        if (this.isEnd()) {
            return false;
        }
        return this.m_sStartUserName != null && this.m_sStartUserName.length() > 0;
    }
}

