/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IWorkflowDelegateMgr;
import com.trs.cms.process.engine.WorkflowDelegate;
import com.trs.cms.process.engine.WorkflowDelegates;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class WorkflowDelegateMgr
implements IWorkflowDelegateMgr {
    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    @Override
    public void delete(User _user) throws Throwable {
        if (_user == null) {
            throw new WCMException("\u60a8\u6ca1\u6709\u4f20\u5165\u76f8\u5173\u7684\u7528\u6237\u53c2\u6570\uff01");
        }
        int nUserId = _user.getId();
        User loginUser = this.getLoginUser();
        WCMFilter filter = new WCMFilter("", "CURRUSERID=?", "", "");
        filter.addSearchValues(nUserId);
        WorkflowDelegates oDelegates = WorkflowDelegates.openWCMObjs(loginUser, filter);
        if (oDelegates.size() == 0) {
            return;
        }
        WorkflowDelegate oDelegate = (WorkflowDelegate)oDelegates.getAt(0);
        oDelegate.delete(loginUser);
    }

    @Override
    public Users getDelegateUsers(Users users, boolean isReturnCurrUser) throws Throwable {
        if (users.size() == 0) {
            throw new WCMException("\u60a8\u4f20\u5165\u7684\u53c2\u6570\u96c6\u7684\u957f\u5ea6\u4e3a0\uff01");
        }
        Users resultUsers = new Users(this.getLoginUser());
        int nSize = users.size();
        for (int i = 0; i < nSize; ++i) {
            Users oTempUsers;
            User user = (User)users.getAt(i);
            if (user == null || (oTempUsers = this.getDelegateUsers(user, isReturnCurrUser)).size() == 0) continue;
            resultUsers.addElements(oTempUsers);
        }
        return resultUsers;
    }

    @Override
    public Users getDelegateUsers(User _user, boolean isReturnCurrUser) throws Throwable {
        if (_user == null) {
            throw new WCMException("\u60a8\u6ca1\u6709\u4f20\u5165\u76f8\u5173\u7684\u7528\u6237\u53c2\u6570\uff01");
        }
        int nUserId = _user.getId();
        User loginUser = this.getLoginUser();
        Users resultUsers = new Users(loginUser);
        if (isReturnCurrUser) {
            resultUsers.addElement(_user);
        }
        WCMFilter filter = new WCMFilter("", "CURRUSERID=?", "");
        filter.addSearchValues(nUserId);
        WorkflowDelegates oDelegates = WorkflowDelegates.openWCMObjs(loginUser, filter);
        if (oDelegates.size() <= 0) {
            resultUsers.addElement(_user);
            return resultUsers;
        }
        WorkflowDelegate oDelegate = (WorkflowDelegate)oDelegates.getAt(0);
        boolean isEnableDelegate = oDelegate.isIsEnable();
        if (isEnableDelegate) {
            String sUserIds = oDelegate.getDelegateUserIds();
            if (!CMyString.isEmpty(sUserIds)) {
                resultUsers = Users.findByIds(loginUser, sUserIds);
            }
            if (resultUsers.size() <= 0) {
                resultUsers.addElement(_user);
            }
        }
        return resultUsers;
    }

    @Override
    public WorkflowDelegate save(WorkflowDelegate delegate) throws Throwable {
        if (delegate == null) {
            throw new WCMException("\u59d4\u6258\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01");
        }
        delegate.save(this.getLoginUser());
        return delegate;
    }

    @Override
    public WorkflowDelegate getDelegateByUser(User _user) throws Throwable {
        if (_user == null) {
            throw new WCMException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        int nUserId = _user.getId();
        WCMFilter filter = new WCMFilter("", "CurrUserId=?", "");
        filter.addSearchValues(nUserId);
        WorkflowDelegates oDelegates = WorkflowDelegates.openWCMObjs(this.getLoginUser(), filter);
        if (oDelegates.size() == 0) {
            return null;
        }
        WorkflowDelegate oDelegate = (WorkflowDelegate)oDelegates.getAt(0);
        return oDelegate;
    }
}

