/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.logger;

import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.webframework.AbstractLogger;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.context.MethodContext;

public class WebSiteRestoreLogger
extends AbstractLogger {
    @Override
    public int startLog(MethodConfig _methodConf, MethodContext _methodContext) {
        try {
            StringBuffer buff = new StringBuffer(64);
            buff.append(_methodConf.getDesc());
            boolean zAll = _methodContext.getValue("RestoreAll", false);
            WebSite logobj = null;
            if (zAll) {
                logobj = Site.INSTANCE;
                buff.append(I18NMessage.get(WebSiteRestoreLogger.class, "WebSiteRestoreLogger.label1", ";\u5168\u90e8\u6062\u590d"));
            } else {
                String sIds = _methodContext.getValue("ObjectIds");
                WebSites sites = WebSites.findByIds(null, sIds);
                int size = sites.size();
                for (int i = 0; i < size; ++i) {
                    WebSite site = (WebSite)sites.getAt(i);
                    if (site == null) continue;
                    buff.append(site).append(",");
                    if (logobj != null) continue;
                    logobj = site;
                }
            }
            return this.log(_methodConf, buff.toString(), logobj);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public String getClassDesc() {
        return "\u6062\u590d\u7ad9\u70b9";
    }

    private static class Site
    extends WebSite {
        static final Site INSTANCE = new Site();

        private Site() {
        }

        @Override
        public String getName() {
            return I18NMessage.get(WebSiteRestoreLogger.class, "WebSiteRestoreLogger.label2", "\u865a\u62df\u7ad9\u70b9");
        }
    }
}

