/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ContentExtendValues;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.DocBakMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.DocBak;
import com.trs.components.wcm.content.persistent.DocBaks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class DocumentBakServiceProvider
implements IGlueServiceProvider {
    private DocBakMgr m_oDocBakMgr = (DocBakMgr)DreamFactory.createObjectById("DocBakMgr");
    private AppendixMgr m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
    private RelationMgr m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
    private ContentExtFieldMgr m_oExtFieldMgr = null;

    public DocumentBakServiceProvider() {
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
    }

    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocumentId", 0);
        Document currDocument = Document.findById(nDocId);
        this.validateRight(loginUser, null, currDocument, 33, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label1", "\u5220\u9664\u6587\u6863\u7248\u672c"));
        DocBaks docBaks = this.m_oDocBakMgr.findDocBaks(currDocument, null);
        String nVersions = _methodContext.getValue("ObjectIds");
        if (nVersions != null && !nVersions.equals("")) {
            nVersions = "," + nVersions + ",";
            int nSize = docBaks.size();
            for (int i = 0; i < nSize; ++i) {
                DocBak docBak = (DocBak)docBaks.getAt(i);
                if (docBak == null || nVersions.indexOf("," + docBak.getVersion() + ",") == -1) continue;
                this.m_oDocBakMgr.deleteDocBak(docBak);
            }
        }
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocumentId", 0);
        if (nDocId <= 0) {
            return null;
        }
        Document currDocument = Document.findById(nDocId);
        if (currDocument == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nDocId), WCMTypes.getLowerObjName(605)}));
        }
        this.validateRight(loginUser, null, currDocument, 32, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label2", "\u83b7\u53d6\u6587\u6863\u7248\u672c\u5217\u8868"));
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        DocBaks docBaks = this.m_oDocBakMgr.findDocBaks(currDocument, extraFilter);
        return docBaks;
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocumentId", 0);
        int nVersion = _methodContext.getObjectId();
        Document currDocument = Document.findById(nDocId);
        if (currDocument == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nDocId), WCMTypes.getLowerObjName(605)}));
        }
        this.validateRight(loginUser, null, currDocument, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label3", "\u83b7\u53d6\u6587\u6863\u7248\u672c"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(currDocument, nVersion);
        if (docBak == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nVersion), WCMTypes.getLowerObjName(611)}));
        }
        return docBak;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        return null;
    }

    public String backup(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Documents documents = Documents.findByIds(loginUser, _methodContext.getValue("DocIds"));
        this.validateRight(loginUser, null, documents, 32, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label4", "\u4fdd\u5b58\u7248\u672c"));
        Reports reports = new Reports(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label5", "\u4fdd\u5b58\u6587\u6863\u7248\u672c"));
        boolean bExcludeTrashed = _methodContext.getValue("ExcludeTrashed", false);
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)documents.getAt(i);
            if (document == null) continue;
            if (bExcludeTrashed && document.getStatusId() < 0) {
                throw new WCMException(document.getTitle() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label6", "[\u6587\u6863-") + document.getId() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label7", "]\u5c1a\u5728\u5e9f\u7a3f\u7bb1\u4e2d\uff0c\u60a8\u6682\u65f6\u65e0\u6cd5\u5bf9\u5176\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01"));
            }
            try {
                int nNewVersion = this.m_oDocBakMgr.bakupDocument(document).getVersion();
                reports.addSucessedReport(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label8", "\u4fdd\u5b58\u6587\u6863[") + document.getTitle() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label9", "]\u7248\u672c\u6210\u529f\uff01\u7248\u672c\u53f7\u4e3a\uff1a") + (nNewVersion + 1));
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label20", "\u4fdd\u5b58\u6587\u6863[") + document.getTitle() + I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label10", "]\u7248\u672c\u5931\u8d25\uff01"), e);
            }
        }
        return reports.toJSONXML();
    }

    public void recover(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocumentId", 0);
        int nVersion = _methodContext.getValue("Version", 0);
        String sSelectFields = _methodContext.getValue("SelectFields");
        Document currDocument = Document.findById(nDocId, sSelectFields);
        if (currDocument == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nDocId), WCMTypes.getLowerObjName(605)}));
        }
        this.validateRight(loginUser, null, currDocument, 32, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label11", "\u6062\u590d\u5f53\u524d\u6587\u6863\u7248\u672c"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(currDocument, nVersion);
        if (docBak == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nVersion), WCMTypes.getLowerObjName(611)}));
        }
        this.m_oDocBakMgr.recoverDocument(docBak, currDocument);
    }

    public Appendixes queryAppendixes(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nAppendixType = _methodContext.getValue("AppendixType", 60);
        int nDocId = _methodContext.getValue("DocumentId", 0);
        int nVersion = _methodContext.getValue("Version", 0);
        String sSelectFields = _methodContext.getValue("SelectFields");
        Document currDocument = Document.findById(nDocId, sSelectFields);
        this.validateRight(loginUser, null, currDocument, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label12", "\u83b7\u53d6\u6587\u6863\u9644\u4ef6"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(currDocument, nVersion);
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        return this.m_oAppendixMgr.getAppendixes(docBak, nAppendixType, extraFilter);
    }

    public Relations queryRelations(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocumentId", 0);
        int nVersion = _methodContext.getValue("Version", 0);
        String sSelectFields = _methodContext.getValue("SelectFields");
        Document currDocument = Document.findById(nDocId, sSelectFields);
        this.validateRight(loginUser, null, currDocument, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label13", "\u83b7\u53d6\u76f8\u5173\u6587\u6863"));
        DocBak docBak = this.m_oDocBakMgr.getDocBak(currDocument, nVersion);
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        return this.m_oRelationMgr.getRelations(docBak, extraFilter);
    }

    public ContentExtendValues queryExtendFields(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nDocId = _methodContext.getValue("DocumentId", 0);
        int nVersion = _methodContext.getValue("Version", 0);
        String sSelectFields = _methodContext.getValue("SelectFields");
        Document currDocument = Document.findById(nDocId, sSelectFields);
        DocBak docBak = this.m_oDocBakMgr.getDocBak(currDocument, nVersion);
        Channel channel = currDocument.getChannel();
        if (channel == null) {
            return new ContentExtendValues(loginUser);
        }
        this.validateRight(loginUser, (BaseChannel)channel, currDocument, 34, I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label14", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
        WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
        ContentExtFields extFields = this.m_oExtFieldMgr.getExtFields(channel, filter, false);
        ContentExtendValues extendValues = new ContentExtendValues(loginUser, extFields.size(), 1);
        int nSize = extFields.size();
        for (int i = 0; i < nSize; ++i) {
            ContentExtField extend = (ContentExtField)extFields.getAt(i);
            if (extend == null) continue;
            String sValue = docBak.getPropertyAsString(extend.getName());
            String sTYpe = CMyString.filterForHTMLValue(extend.getAttributeValue("FIELDTYPE"));
            String[] arValues = null;
            if (sValue != null && sTYpe != null && "678".indexOf(sTYpe) != -1) {
                String sEValue = CMyString.filterForHTMLValue(extend.getAttributeValue("ENMVALUE"));
                if (CMyString.isEmpty(sEValue)) continue;
                arValues = sEValue.split("~");
                String[] sDValue = sValue.split(",");
                boolean bCheckBox = true;
                int len = arValues.length;
                for (int ix = 0; ix < len; ++ix) {
                    String[] arValue = this.pairSplit(arValues[ix]);
                    for (int ip = 0; ip < sDValue.length; ++ip) {
                        if (!sDValue[ip].trim().equalsIgnoreCase(arValue[1])) continue;
                        sValue = bCheckBox ? arValue[0] : sValue + "," + arValue[0];
                        bCheckBox = false;
                    }
                }
            }
            sValue = sValue + "~" + sTYpe;
            extendValues.addElement(i + 1, extend.getDesc(), extend.getName(), sValue);
        }
        return extendValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] pairSplit(String sPair) {
        String[] arValue = new String[]{"", ""};
        if (sPair.indexOf("`") != -1) {
            String[] tempArr = sPair.split("`");
            if (tempArr.length == 2) {
                arValue[0] = tempArr[0];
                arValue[1] = tempArr[1];
                return arValue;
            } else {
                if (tempArr.length != 1) return arValue;
                arValue[0] = arValue[1] = tempArr[0];
            }
            return arValue;
        } else {
            arValue[0] = sPair;
            arValue[1] = sPair;
        }
        return arValue;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validateRight(User _loginUser, BaseChannel _channelOrSite, Documents _documents, int _nRightIndex, String _sOperDesc) throws WCMException {
        int nSize = _documents.size();
        for (int i = 0; i < nSize; ++i) {
            Document document = (Document)_documents.getAt(i);
            if (document == null) continue;
            this.validateRight(_loginUser, _channelOrSite, document, _nRightIndex, _sOperDesc);
        }
    }

    private void validateRight(User _loginUser, BaseChannel _channelOrSite, Document _document, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!DocumentAuthServer.hasRight(_loginUser, _channelOrSite, _document, _nRightIndex)) {
            throw new WCMException(CMyString.format(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label20", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[{0}]\u6ca1\u6709\u6743\u9650{1}:{2}."), new Object[]{_loginUser.getName(), _sOperDesc, _document}));
        }
    }
}

