/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class DocumentAuthHelper {
    private static Logger logger = Logger.getLogger(DocumentAuthHelper.class);

    public static WCMFilter makeFilterWithRight(User _loginUser, BaseObjs _oSitesOrChannels) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return null;
        }
        WCMFilter filterBrowser = new WCMFilter();
        int nRightIndexBrowser = 34;
        boolean bWithDeptFilter = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("WITH_DEPT_FILTER", "false"));
        if (DBManager.getDBManager().getFieldInfo("WCMCHNLDOC", "CRDEPT") == null) {
            bWithDeptFilter = false;
        }
        boolean bIsDepartmentAdmin = false;
        String sLoginUserDeptInfo = null;
        if (bWithDeptFilter) {
            IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
            sLoginUserDeptInfo = departmentMgr.getDepartmentInfo(_loginUser);
            bIsDepartmentAdmin = departmentMgr.isDepartmentAdmin(_loginUser);
        }
        String sQueryDeptDocuments = null;
        String sQueryCurrDeptDocuments = null;
        if (!CMyString.isEmpty(sLoginUserDeptInfo)) {
            sQueryCurrDeptDocuments = "WCMChnlDoc.CrDept = ?";
            sQueryDeptDocuments = "WCMChnlDoc.CrDept like ?";
            if (bIsDepartmentAdmin) {
                sQueryDeptDocuments = "(" + sQueryCurrDeptDocuments + " or " + sQueryDeptDocuments + ")";
            }
        }
        if (_oSitesOrChannels.size() == 1) {
            BaseChannel oChannelOrSite = (BaseChannel)_oSitesOrChannels.getAt(0);
            if (!AuthServer.hasRight(_loginUser, (CMSObj)oChannelOrSite, nRightIndexBrowser)) {
                if (bIsDepartmentAdmin) {
                    filterBrowser.setWhere("(WCMCHNLDOC.cruser=? or " + sQueryCurrDeptDocuments + ")");
                    filterBrowser.addSearchValues(_loginUser.getName());
                    filterBrowser.addSearchValues(sLoginUserDeptInfo);
                } else {
                    filterBrowser.setWhere("WCMCHNLDOC.cruser=?");
                    filterBrowser.addSearchValues(_loginUser.getName());
                }
            } else if (bWithDeptFilter) {
                filterBrowser.setWhere(sQueryDeptDocuments);
                if (bIsDepartmentAdmin) {
                    filterBrowser.addSearchValues(sLoginUserDeptInfo);
                }
                filterBrowser.addSearchValues(sLoginUserDeptInfo + "\\%");
            }
        } else if (_oSitesOrChannels.size() > 1) {
            _oSitesOrChannels.setMaxBufferSize(_oSitesOrChannels.size());
            boolean bHasRightOnAllChannels = DocumentAuthHelper.hasRightOnAllChannels(_loginUser, _oSitesOrChannels, nRightIndexBrowser);
            boolean bExistsDoDeptFilterChannel = DocumentAuthHelper.existsDoDeptFilterChannel(_oSitesOrChannels);
            if (bHasRightOnAllChannels && !bExistsDoDeptFilterChannel) {
                return filterBrowser;
            }
            int nChannelDeptFilterMode = DocumentAuthHelper.makeChannelFilterMode(_oSitesOrChannels);
            if (bHasRightOnAllChannels && nChannelDeptFilterMode != 2) {
                if (nChannelDeptFilterMode == 1) {
                    filterBrowser.setWhere(sQueryDeptDocuments);
                    if (bIsDepartmentAdmin) {
                        filterBrowser.addSearchValues(sLoginUserDeptInfo);
                    }
                    filterBrowser.addSearchValues(sLoginUserDeptInfo + "\\%");
                }
                return filterBrowser;
            }
            StringBuffer sbBrowserWhere = new StringBuffer();
            for (int i = _oSitesOrChannels.size() - 1; i >= 0; --i) {
                BaseChannel oChannelOrSite = (BaseChannel)_oSitesOrChannels.getAt(i);
                if (oChannelOrSite == null || oChannelOrSite.isSite()) continue;
                Channel channel = (Channel)oChannelOrSite;
                if (sbBrowserWhere.length() > 0) {
                    sbBrowserWhere.append(" or ");
                }
                if (bHasRightOnAllChannels || AuthServer.hasRight(_loginUser, (CMSObj)oChannelOrSite, nRightIndexBrowser)) {
                    sbBrowserWhere.append("(");
                    sbBrowserWhere.append("WCMCHNLDOC.docchannel=?");
                    filterBrowser.addSearchValues(oChannelOrSite.getId());
                    if (channel.isDoDeptFilter()) {
                        sbBrowserWhere.append(" and ");
                        sbBrowserWhere.append(sQueryDeptDocuments);
                        if (bIsDepartmentAdmin) {
                            filterBrowser.addSearchValues(sLoginUserDeptInfo);
                        }
                        filterBrowser.addSearchValues(sLoginUserDeptInfo + "\\%");
                    }
                    sbBrowserWhere.append(")");
                    continue;
                }
                sbBrowserWhere.append("(");
                if (channel.isDoDeptFilter() && bIsDepartmentAdmin) {
                    sbBrowserWhere.append("(WCMCHNLDOC.docchannel=? and (WCMCHNLDOC.cruser=? or " + sQueryCurrDeptDocuments + "))");
                } else {
                    sbBrowserWhere.append("(WCMCHNLDOC.docchannel=? and WCMCHNLDOC.cruser=?)");
                }
                filterBrowser.addSearchValues(oChannelOrSite.getId());
                filterBrowser.addSearchValues(_loginUser.getName());
                if (channel.isDoDeptFilter() && bIsDepartmentAdmin) {
                    filterBrowser.addSearchValues(sLoginUserDeptInfo);
                }
                sbBrowserWhere.append(")");
            }
            if (sbBrowserWhere.length() > 0) {
                filterBrowser.setWhere(sbBrowserWhere.toString());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.error((Object)"who call me!", (Throwable)new Exception());
            logger.debug((Object)("Filter with auth of [" + _loginUser.getName() + "]\n" + filterBrowser));
        }
        return filterBrowser;
    }

    private static boolean hasRightOnAllChannels(User _loginUser, BaseObjs _oSitesOrChannels, int _nRightIndexBrowser) throws WCMException {
        boolean bHasRightOnAllChannels = false;
        for (int i = _oSitesOrChannels.size() - 1; i >= 0; --i) {
            BaseChannel oChannelOrSite = (BaseChannel)_oSitesOrChannels.getAt(i);
            if (oChannelOrSite == null || oChannelOrSite.isSite() || AuthServer.hasRight(_loginUser, (CMSObj)oChannelOrSite, _nRightIndexBrowser)) continue;
            bHasRightOnAllChannels = false;
            break;
        }
        return bHasRightOnAllChannels;
    }

    private static boolean existsDoDeptFilterChannel(BaseObjs _oSitesOrChannels) {
        for (int i = _oSitesOrChannels.size() - 1; i >= 0; --i) {
            Channel channel;
            BaseChannel oChannelOrSite = (BaseChannel)_oSitesOrChannels.getAt(i);
            if (oChannelOrSite == null || oChannelOrSite.isSite() || !(channel = (Channel)oChannelOrSite).isDoDeptFilter()) continue;
            return true;
        }
        return false;
    }

    private static int makeChannelFilterMode(BaseObjs _oSitesOrChannels) {
        int nChannelFilterMode = -1;
        for (int i = _oSitesOrChannels.size() - 1; i >= 0; --i) {
            BaseChannel oChannelOrSite = (BaseChannel)_oSitesOrChannels.getAt(i);
            if (oChannelOrSite == null || oChannelOrSite.isSite()) continue;
            Channel channel = (Channel)oChannelOrSite;
            if (channel.isDoDeptFilter()) {
                if (nChannelFilterMode == -1) {
                    nChannelFilterMode = 1;
                    continue;
                }
                return 2;
            }
            if (nChannelFilterMode == -1) {
                nChannelFilterMode = 0;
                continue;
            }
            return 2;
        }
        return nChannelFilterMode;
    }
}

