/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.RegexUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.jsp.JspException;

public class StringUtil {
    public static final char[] TRSServerReservedChars = new char[]{'=', '(', ')', '[', ']', ',', '/', '@', '>', '<', '!', '&', '*', '^', '-', '+', '\'', '\\'};

    public static boolean checkEqualsIgnoreNull(String str1, String str2) {
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        return str1.equals(str2);
    }

    public static boolean checkEquals(String str1, String str2) {
        return !(str1 == null ? str2 != null : !str1.equals(str2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkUserIP(String userip, String dbip) {
        try {
            userip = StringUtil.replaceString(userip, ".", "P");
            dbip = StringUtil.replaceString(dbip, ".", "P");
            String[] dbipm = new String[]{dbip};
            if (dbip.indexOf(";") >= 0) {
                dbipm = dbip.split(";");
            }
            if (dbip.indexOf(" ") >= 0) {
                dbipm = dbip.split(" ");
            }
            int j = 0;
            while (true) {
                if (j >= dbipm.length) {
                    return false;
                }
                String ip = dbipm[j];
                if (ip != null && ip.length() > 0) {
                    String[] dbip1 = ip.split("P");
                    String[] userip1 = userip.split("P");
                    if (userip1 == null || userip1.length != 4) {
                        return false;
                    }
                    if (dbip1 == null || dbip1.length != 4) {
                        return false;
                    }
                    boolean stat = true;
                    int i = 0;
                    while (true) {
                        if (i >= dbip1.length) {
                            if (!stat) break;
                            return true;
                        }
                        if (!dbip1[i].equals("*") && !dbip1[i].equals(userip1[i])) {
                            stat = false;
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        catch (Exception e) {
            System.out.println("checkIP " + e);
            return false;
        }
    }

    public static String[] processHTMLLabel(String inputStr) {
        String noHtmlValue = inputStr;
        String changeHtmlValue = inputStr;
        try {
            List list = new ArrayList();
            if (inputStr.indexOf("<") >= 0) {
                String strRegex = "<(.*?)>";
                list = RegexUtil.getMatchGroupList(inputStr, strRegex, 0);
                if (list != null && list.size() > 0) {
                    int j = 0;
                    while (j < list.size()) {
                        String strName = (String)list.get(j);
                        noHtmlValue = StringUtil.replaceString(noHtmlValue, strName, "");
                        String newstrName = StringUtil.replaceString(strName, "<", "\u3008");
                        newstrName = StringUtil.replaceString(newstrName, ">", "\u3009");
                        changeHtmlValue = StringUtil.replaceString(changeHtmlValue, strName, newstrName);
                        ++j;
                    }
                }
                noHtmlValue = noHtmlValue.replaceAll(strRegex, "");
                changeHtmlValue = changeHtmlValue.replaceAll(strRegex, "");
            }
            noHtmlValue = StringUtil.replaceString(noHtmlValue, "<", "&lt;");
            noHtmlValue = StringUtil.replaceString(noHtmlValue, ">", "&gt;");
            changeHtmlValue = StringUtil.replaceString(changeHtmlValue, "<", "&lt;");
            changeHtmlValue = StringUtil.replaceString(changeHtmlValue, ">", "&gt;");
            changeHtmlValue = StringUtil.replaceString(changeHtmlValue, "\u3008", "<");
            changeHtmlValue = StringUtil.replaceString(changeHtmlValue, "\u3009", ">");
        }
        catch (Exception e) {
            System.out.println("processHTMLLabel \u9519\u8bef\uff01" + inputStr + " " + e);
        }
        String[] ret = new String[]{noHtmlValue, changeHtmlValue};
        return ret;
    }

    public static String formatShow(String content) {
        String englishOneBlanks = " ";
        String englishTwoBlanks = "  ";
        String chineseTwoBlanks = "\u3000\u3000";
        try {
            content = StringUtil.replaceString(content, "\r\n", "<br>");
            content = StringUtil.replaceString(content, "\n", "<br>");
            content = StringUtil.replaceString(content, "\r", "<br>");
            content = StringUtil.replaceString(content, "<BR>", "<br>");
            content = content.replaceAll(englishTwoBlanks, "");
            content = content.replaceAll(chineseTwoBlanks, "");
            content = content.replaceAll("<br>" + englishOneBlanks, "<br>");
            content = content.replaceAll("(<br>){2,}", "<br>");
            String[] brarr = content.split("<br>");
            int i = 0;
            while (i < brarr.length) {
                String lastChar;
                String picdemo = brarr[i];
                if (!(picdemo == null || picdemo.equals("") || picdemo.length() > 50 || (lastChar = picdemo.substring(picdemo.length() - 1)).equals(",") || lastChar.equals(".") || lastChar.equals("\uff0c") || lastChar.equals("\u3002") || lastChar.equals("<") || lastChar.equals(">"))) {
                    String newpicdemo = "<table width=100%><tr><td align=center>" + picdemo + "</td></tr></table>";
                    content = StringUtil.replaceString(content, "><br>" + picdemo, ">" + newpicdemo);
                }
                ++i;
            }
            if ((content = content.replaceAll("<br>", "<br>" + chineseTwoBlanks)).indexOf("&nbsp;&nbsp;") != 0 && content.indexOf(chineseTwoBlanks) != 0) {
                content = String.valueOf(chineseTwoBlanks) + content;
            }
            content = content.trim();
        }
        catch (Exception e) {
            System.out.println("\u6b63\u6587\u683c\u5f0f\u5316\u663e\u793a\u9519\u8bef\uff01" + e);
        }
        return content;
    }

    public static String highlight(String content, String[] keywords, String[] colors) {
        if (StringUtil.isEmpty(content)) {
            return "";
        }
        String defaultColor = "red";
        if (keywords != null && keywords.length > 0) {
            int i = 0;
            while (i < keywords.length) {
                String keyword = keywords[i];
                boolean isValidColor = colors != null && colors.length > i;
                String color = isValidColor ? colors[i] : defaultColor;
                String[] oldParts = content.split("(?i)<(img|object).*?>");
                int j = 0;
                while (j < oldParts.length) {
                    String oldPart = oldParts[j];
                    String newPart = StringUtil.replaceString(oldPart, keyword, "<font color=\"" + color + "\">" + keyword + "</font>");
                    if (!newPart.equals(oldPart)) {
                        content = StringUtil.replaceString(content, oldPart, newPart);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return content;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.trim().length() != 0;
    }

    public static String replaceString(String source, String keyword, String replacement) {
        int lineEnd;
        if (source == null) {
            return "";
        }
        if (StringUtil.isEmpty(keyword) || replacement == null || keyword.equals(replacement)) {
            return source;
        }
        StringBuffer buffer = new StringBuffer(source.length() * 2);
        int lineBegin = 0;
        while ((lineEnd = source.indexOf(keyword, lineBegin)) != -1) {
            buffer.append(source.substring(lineBegin, lineEnd));
            buffer.append(replacement);
            lineBegin = lineEnd + keyword.length();
        }
        buffer.append(source.substring(lineBegin, source.length()));
        return buffer.toString();
    }

    public static List distillImagesFromContent(String content, String imageDir) {
        if (StringUtil.isEmpty(content) || StringUtil.isEmpty(imageDir)) {
            return Collections.EMPTY_LIST;
        }
        if (!imageDir.endsWith("/") && !imageDir.endsWith("\\")) {
            imageDir = String.valueOf(imageDir) + "/";
        }
        List list = RegexUtil.getMatchGroupList(content, "(?i)<img +src *= *(['\"])?[^>]*[/\\\\]([^/\\\\'\">]+)\\1?[ >]", 2);
        int i = 0;
        while (i < list.size()) {
            String filename = (String)list.get(i);
            list.set(i, String.valueOf(imageDir) + filename.trim());
            ++i;
        }
        return list;
    }

    public static String setStrEndWith(String string, char chrEnd) {
        if (string == null) {
            return null;
        }
        if (string.charAt(string.length() - 1) != chrEnd) {
            return String.valueOf(string) + chrEnd;
        }
        return string;
    }

    public static String replace4TRS(String keyword) {
        return StringUtil.replace4TRS(keyword, false);
    }

    public static String replace4TRS(String keyword, boolean escapeSimilarSearchChar) {
        if (keyword == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(keyword.length() * 2);
        int i = 0;
        while (i < keyword.length()) {
            char ch = keyword.charAt(i);
            boolean escaped = false;
            int j = 0;
            while (j < TRSServerReservedChars.length) {
                if (ch == TRSServerReservedChars[j]) {
                    buffer.append("\\");
                    escaped = true;
                    break;
                }
                ++j;
            }
            if (!escaped && escapeSimilarSearchChar && (ch == '%' || ch == '?')) {
                buffer.append("\\");
            }
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean ifExist(String str1, String str2, String charcode) {
        if (str1 == null || str2 == null) {
            return false;
        }
        String[] temp = str2.split(charcode);
        int i = 0;
        while (i < temp.length) {
            String string = temp[i];
            if (!string.equals("") && string.equals(str1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String subStringTag(String string, int reserveLength) throws JspException {
        return StringUtil.subStringTag(string, 0, reserveLength, 1024, "...")[0];
    }

    public static String[] subStringTag(String string, int startPosition, int reserveLength, int windowwidth, String charStr) throws JspException {
        String retString = "";
        boolean escapeXml = true;
        try {
            String inString = string;
            if (startPosition > 0 && inString.length() > startPosition) {
                inString = inString.substring(startPosition);
            }
            String[] ret = StringUtil.processHTMLLabel(inString);
            String noHtmlValue = ret[0];
            String newValue = inString = ret[1];
            if (reserveLength != 0) {
                if (reserveLength < 0) {
                    if (windowwidth == 0) {
                        windowwidth = 1024;
                    }
                    reserveLength = windowwidth >= 1280 ? reserveLength * -2 + 15 : (windowwidth >= 1024 ? reserveLength * -2 + 5 : (reserveLength *= -2));
                }
                int actuallength = reserveLength * 2;
                int totallength = 0;
                boolean html = false;
                boolean titleEnd = false;
                int i = 0;
                while (i < inString.length()) {
                    String charValue = inString.substring(i, i + 1);
                    if (charValue.equals("<")) {
                        ++actuallength;
                        ++totallength;
                        html = true;
                        if (titleEnd) {
                            newValue = String.valueOf(newValue) + charValue;
                        }
                    } else if (charValue.equals(">")) {
                        ++actuallength;
                        ++totallength;
                        html = false;
                        if (titleEnd) {
                            newValue = String.valueOf(newValue) + charValue;
                        }
                    } else if (html) {
                        ++actuallength;
                        ++totallength;
                    } else if (!titleEnd) {
                        char intCode = inString.charAt(i);
                        totallength = intCode >= '\u0000' && intCode <= '\u0080' ? ++totallength : (totallength += 2);
                        if (totallength > actuallength) {
                            newValue = String.valueOf(inString.substring(0, i)) + charStr;
                            titleEnd = true;
                        }
                    }
                    ++i;
                }
                if (titleEnd) {
                    String altValue = noHtmlValue.replaceAll(" ", "&nbsp;");
                    altValue = altValue.replaceAll("\"", "\u201c");
                    altValue = altValue.replaceAll("'", "\u2018");
                    String tempret = newValue;
                    newValue = "<span title=" + altValue + ">" + newValue + "</span>";
                    if (tempret.indexOf("<") >= 0) {
                        newValue = String.valueOf(newValue) + "</b></u></i></font>";
                    }
                }
                if ((newValue = newValue.replaceAll("<>", "")).indexOf("<") >= 0 && newValue.indexOf(">") >= 0) {
                    escapeXml = false;
                }
                if (newValue.indexOf("&gt;") >= 0 || newValue.indexOf("&lt;") >= 0) {
                    escapeXml = false;
                }
                if (reserveLength == 80) {
                    newValue = StringUtil.replaceString(newValue, "<im", "");
                    if ((newValue = StringUtil.replaceString(newValue, "<IM", "")).equals("")) {
                        newValue = String.valueOf(newValue) + "<br>";
                    } else if (totallength < actuallength / 2) {
                        newValue = String.valueOf(newValue) + "<br>";
                    } else if (totallength < actuallength) {
                        newValue = String.valueOf(newValue);
                    }
                }
                if (newValue.equals("")) {
                    newValue = inString.length() > 0 ? "\u65e0" : "";
                }
                retString = newValue;
            } else {
                retString = inString;
            }
        }
        catch (Exception ex) {
            System.out.println("StringTag:" + ex.getMessage());
            retString = string;
            escapeXml = true;
        }
        String[] retStrings = new String[]{retString, escapeXml ? "true" : "false"};
        return retStrings;
    }

    public static String cutString(String string, int length) {
        if (string == null || string.equals("")) {
            return string;
        }
        if (string.length() > length) {
            string = String.valueOf(string.substring(0, length)) + "...";
        }
        return string;
    }

    public static int getStringLen(String str) {
        int totallength = 0;
        int i = 0;
        while (i < str.length()) {
            String s = str.substring(i, i + 1);
            int intCode = s.hashCode();
            totallength = intCode >= 0 && intCode <= 128 ? ++totallength : (totallength += 2);
            ++i;
        }
        return totallength;
    }

    public static String subString(String str, int len) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int totallength = StringUtil.getStringLen(str);
        if (len == 0 || len > totallength) {
            return str;
        }
        String ret = str;
        totallength = 0;
        int i = 0;
        while (i < str.length()) {
            String s = str.substring(i, i + 1);
            int intCode = s.hashCode();
            totallength = intCode >= 0 && intCode <= 128 ? ++totallength : (totallength += 2);
            if (totallength > len - 3) {
                ret = String.valueOf(str.substring(0, i)) + "...";
                break;
            }
            ++i;
        }
        return ret;
    }

    public static String addString(String add1, String add2, String delm) {
        if (add1 == null || add1.equals("")) {
            return add2;
        }
        if (add2 == null || add2.equals("")) {
            return add1;
        }
        return String.valueOf(add1) + delm + add2;
    }
}

