/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.FileUtil;
import java.io.File;
import java.util.List;
import javax.activation.FileDataSource;
import junit.framework.TestCase;

public class FileUtilTest
extends TestCase {
    private File writeFile;
    private File readFile;

    protected void setUp() throws Exception {
        super.setUp();
        FileDataSource fds = new FileDataSource("resource/\u6587\u4ef6\u8bfb\u5199\u6d4b\u8bd5.txt");
        this.writeFile = fds.getFile();
        fds = new FileDataSource("resource/\u97e9\u6587\u5185\u5bb9.txt");
        this.readFile = fds.getFile();
    }

    public void testAppendFile() throws Exception {
        String filePath = "E:\\1111\\111.txt";
        String content = "sdfsdf\u6587\u4ef6\u8bfb\u5199\u6d4b\u8bd5sdfsdf";
        FileUtil.appendFile(filePath, "\r\n", content);
    }

    public void testListAllFiles() throws Exception {
        String folder = "E:\\temp\\7942\\db";
        List list = FileUtil.listAllFiles(folder);
        int i = 0;
        while (i < list.size()) {
            String dir = (String)list.get(i);
            System.out.println(dir);
            ++i;
        }
    }

    public void testGetAllFolders() throws Exception {
        String folder = "E:\\temp\\7942\\db";
        String folders = FileUtil.getAllFolders(folder);
        String[] dirs = folders.split(",");
        int i = 0;
        while (i < dirs.length) {
            System.out.println(dirs[i]);
            ++i;
        }
    }

    public void testGetFileExtendName() throws Exception {
        FileUtilTest.assertEquals((String)"", (String)FileUtil.getFileExtendName(null));
        FileUtilTest.assertEquals((String)"", (String)FileUtil.getFileExtendName("test"));
        FileUtilTest.assertEquals((String)"txt", (String)FileUtil.getFileExtendName("temp.txt"));
    }

    public void testGetFileName() throws Exception {
        FileUtilTest.assertEquals((String)"", (String)FileUtil.getFileName(null));
        FileUtilTest.assertEquals((String)"test", (String)FileUtil.getFileName("test"));
        FileUtilTest.assertEquals((String)"temp.txt", (String)FileUtil.getFileName("c:\\temp.txt"));
    }

    public void testWriteFile() throws Exception {
        String readContent = FileUtil.readTextFile(this.readFile);
        FileUtil.writeFile(this.writeFile, readContent, "UTF-8");
        String writeContent = FileUtil.readTextFile(this.writeFile, "UTF-8");
        FileUtilTest.assertEquals((String)writeContent.trim(), (String)readContent.trim());
    }
}

