/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.db;

import org.xmlmiddleware.utils.InvertedTokenList;
import org.xmlmiddleware.utils.TokenList;

public class JDBCTypes {
    public static String JDBCTYPE_BIGINT = "BIGINT";
    public static String JDBCTYPE_BINARY = "BINARY";
    public static String JDBCTYPE_BIT = "BIT";
    public static String JDBCTYPE_CHAR = "CHAR";
    public static String JDBCTYPE_DATE = "DATE";
    public static String JDBCTYPE_DECIMAL = "DECIMAL";
    public static String JDBCTYPE_DOUBLE = "DOUBLE";
    public static String JDBCTYPE_FLOAT = "FLOAT";
    public static String JDBCTYPE_INTEGER = "INTEGER";
    public static String JDBCTYPE_LONGVARBINARY = "LONGVARBINARY";
    public static String JDBCTYPE_LONGVARCHAR = "LONGVARCHAR";
    public static String JDBCTYPE_NUMERIC = "NUMERIC";
    public static String JDBCTYPE_OTHER = "OTHER";
    public static String JDBCTYPE_REAL = "REAL";
    public static String JDBCTYPE_SMALLINT = "SMALLINT";
    public static String JDBCTYPE_TIME = "TIME";
    public static String JDBCTYPE_TIMESTAMP = "TIMESTAMP";
    public static String JDBCTYPE_TINYINT = "TINYINT";
    public static String JDBCTYPE_VARBINARY = "VARBINARY";
    public static String JDBCTYPE_VARCHAR = "VARCHAR";
    public static String[] JDBCTYPES = new String[]{JDBCTYPE_BIGINT, JDBCTYPE_BINARY, JDBCTYPE_BIT, JDBCTYPE_CHAR, JDBCTYPE_DATE, JDBCTYPE_DECIMAL, JDBCTYPE_DOUBLE, JDBCTYPE_FLOAT, JDBCTYPE_INTEGER, JDBCTYPE_LONGVARBINARY, JDBCTYPE_LONGVARCHAR, JDBCTYPE_NUMERIC, JDBCTYPE_OTHER, JDBCTYPE_REAL, JDBCTYPE_SMALLINT, JDBCTYPE_TIME, JDBCTYPE_TIMESTAMP, JDBCTYPE_TINYINT, JDBCTYPE_VARBINARY, JDBCTYPE_VARCHAR};
    public static final int[] JDBCTYPE_TOKENS = new int[]{-5, -2, -7, 1, 91, 3, 8, 6, 4, -4, -1, 2, 1111, 7, 5, 92, 93, -6, -3, 12};
    private static final InvertedTokenList jdbcTypes = new InvertedTokenList(JDBCTYPE_TOKENS, JDBCTYPES, null);
    private static final TokenList jdbcNames = new TokenList(JDBCTYPES, JDBCTYPE_TOKENS, 0);

    public static String getName(int n) {
        return jdbcTypes.getTokenName(n);
    }

    public static int getType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null.");
        }
        return jdbcNames.getToken(string);
    }

    public static boolean typeIsValid(int n) {
        return jdbcTypes.getTokenName(n) != null;
    }

    public static boolean nameIsValid(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name argument must not be null.");
        }
        return jdbcNames.getToken(string) != 0;
    }

    public static boolean typeIsOther(int n) {
        return n == 1111;
    }

    public static boolean typeIsBinary(int n) {
        return n == -2 || n == -4 || n == -3;
    }

    public static boolean typeIsChar(int n) {
        return n == 1 || n == -1 || n == 12;
    }

    public static boolean typeIsDateTime(int n) {
        return n == 91 || n == 92 || n == 93;
    }

    public static boolean typeIsNumeric(int n) {
        return n == -5 || n == -7 || n == 3 || n == 8 || n == 6 || n == 4 || n == 2 || n == 7 || n == 5 || n == -6;
    }

    public static int convertDateTimeType(int n) {
        switch (n) {
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 11: {
                return 93;
            }
        }
        return n;
    }
}

