/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps.utils;

import java.util.Enumeration;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.ClassMapBase;
import org.xmlmiddleware.xmldbms.maps.ClassTableMap;
import org.xmlmiddleware.xmldbms.maps.ColumnMap;
import org.xmlmiddleware.xmldbms.maps.ElementInsertionList;
import org.xmlmiddleware.xmldbms.maps.ElementInsertionMap;
import org.xmlmiddleware.xmldbms.maps.InlineClassMap;
import org.xmlmiddleware.xmldbms.maps.PropertyMap;
import org.xmlmiddleware.xmldbms.maps.PropertyMapBase;
import org.xmlmiddleware.xmldbms.maps.PropertyTableMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassMap;
import org.xmlmiddleware.xmldbms.maps.RelatedClassTableMap;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmldbms.maps.XMLDBMSMap;

public class MapInverter {
    public void createDatabaseView(XMLDBMSMap xMLDBMSMap) throws XMLMiddlewareException {
        if (xMLDBMSMap == null) {
            throw new IllegalStateException("XMLDBMSMap object must be set before the database view can be created.");
        }
        xMLDBMSMap.removeAllClassTableMaps();
        this.invertClassMaps(xMLDBMSMap);
    }

    public void createXMLView(XMLDBMSMap xMLDBMSMap) throws XMLMiddlewareException {
        if (xMLDBMSMap == null) {
            throw new IllegalStateException("XMLDBMSMap object must be set before the XML view can be created.");
        }
        xMLDBMSMap.removeAllClassMaps();
        this.invertClassTableMaps(xMLDBMSMap);
    }

    private void invertClassMaps(XMLDBMSMap xMLDBMSMap) throws XMLMiddlewareException {
        Enumeration enumeration = xMLDBMSMap.getClassMaps();
        while (enumeration.hasMoreElements()) {
            this.invertClassMap(xMLDBMSMap, (ClassMap)enumeration.nextElement());
        }
    }

    private void invertClassMap(XMLDBMSMap xMLDBMSMap, ClassMap classMap) throws XMLMiddlewareException {
        if (classMap.getUsedClassMap() != null) {
            return;
        }
        ClassTableMap classTableMap = xMLDBMSMap.createClassTableMap(classMap.getTable());
        classTableMap.setElementTypeName(classMap.getElementTypeName());
        ClassMap classMap2 = classMap.getBaseClassMap();
        if (classMap2 != null) {
            classTableMap.setBaseTable(classMap2.getTable());
            classTableMap.setBaseLinkInfo(classMap.getBaseLinkInfo());
        }
        this.invertMarkupMaps(xMLDBMSMap, classTableMap, classMap, ElementInsertionList.create());
    }

    private void invertMarkupMaps(XMLDBMSMap xMLDBMSMap, ClassTableMap classTableMap, ClassMapBase classMapBase, ElementInsertionList elementInsertionList) throws XMLMiddlewareException {
        PropertyMap propertyMap;
        Enumeration enumeration = classMapBase.getAttributeMaps();
        while (enumeration.hasMoreElements()) {
            propertyMap = (PropertyMap)enumeration.nextElement();
            this.invertPropertyMap(classTableMap, propertyMap, elementInsertionList);
        }
        propertyMap = classMapBase.getPCDATAMap();
        if (propertyMap != null) {
            this.invertPropertyMap(classTableMap, propertyMap, elementInsertionList);
        }
        enumeration = classMapBase.getChildMaps();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof PropertyMap) {
                this.invertPropertyMap(classTableMap, (PropertyMap)e, elementInsertionList);
                continue;
            }
            if (e instanceof RelatedClassMap) {
                this.invertRelatedClassMap(xMLDBMSMap, classTableMap, (RelatedClassMap)e, elementInsertionList);
                continue;
            }
            this.invertInlineClassMap(xMLDBMSMap, classTableMap, (InlineClassMap)e, elementInsertionList);
        }
    }

    private void invertPropertyMap(ClassTableMap classTableMap, PropertyMap propertyMap, ElementInsertionList elementInsertionList) throws XMLMiddlewareException {
        PropertyMapBase propertyMapBase;
        Table table = propertyMap.getTable();
        if (table == null) {
            ColumnMap columnMap = ColumnMap.create(propertyMap.getColumn());
            columnMap.setXMLName(propertyMap.getXMLName(), propertyMap.getType());
            if (elementInsertionList.size() != 0) {
                columnMap.setElementInsertionList((ElementInsertionList)elementInsertionList.clone());
            }
            classTableMap.addColumnMap(columnMap);
            propertyMapBase = columnMap;
        } else {
            PropertyTableMap propertyTableMap = PropertyTableMap.create(table);
            propertyTableMap.setColumn(propertyMap.getColumn());
            propertyTableMap.setLinkInfo(propertyMap.getLinkInfo());
            propertyTableMap.setXMLName(propertyMap.getXMLName(), propertyMap.getType());
            if (elementInsertionList.size() != 0) {
                propertyTableMap.setElementInsertionList((ElementInsertionList)elementInsertionList.clone());
            }
            classTableMap.addPropertyTableMap(propertyTableMap);
            propertyMapBase = propertyTableMap;
        }
        boolean bl = propertyMap.isTokenList();
        propertyMapBase.setIsTokenList(bl);
        if (bl) {
            propertyMapBase.setTokenListOrderInfo(propertyMap.getTokenListOrderInfo());
        }
        if (propertyMap.getType() != 2) {
            propertyMapBase.setOrderInfo(propertyMap.getOrderInfo());
        }
        if (propertyMapBase.getType() == 1) {
            propertyMapBase.setContainsXML(propertyMap.containsXML());
        }
    }

    private void invertRelatedClassMap(XMLDBMSMap xMLDBMSMap, ClassTableMap classTableMap, RelatedClassMap relatedClassMap, ElementInsertionList elementInsertionList) throws XMLMiddlewareException {
        ClassTableMap classTableMap2 = xMLDBMSMap.createClassTableMap(relatedClassMap.getClassMap().getTable());
        RelatedClassTableMap relatedClassTableMap = RelatedClassTableMap.create(classTableMap2);
        classTableMap.addRelatedClassTableMap(relatedClassTableMap);
        relatedClassTableMap.setElementTypeName(relatedClassMap.getElementTypeName());
        relatedClassTableMap.setLinkInfo(relatedClassMap.getLinkInfo());
        relatedClassTableMap.setOrderInfo(relatedClassMap.getOrderInfo());
        if (elementInsertionList.size() != 0) {
            relatedClassTableMap.setElementInsertionList((ElementInsertionList)elementInsertionList.clone());
        }
    }

    private void invertInlineClassMap(XMLDBMSMap xMLDBMSMap, ClassTableMap classTableMap, InlineClassMap inlineClassMap, ElementInsertionList elementInsertionList) throws XMLMiddlewareException {
        ElementInsertionMap elementInsertionMap = ElementInsertionMap.create(inlineClassMap.getElementTypeName());
        elementInsertionList.addElementInsertionMap(elementInsertionMap);
        elementInsertionMap.setOrderInfo(inlineClassMap.getOrderInfo());
        this.invertMarkupMaps(xMLDBMSMap, classTableMap, inlineClassMap, elementInsertionList);
        elementInsertionList.removeElementInsertionMap(elementInsertionList.size() - 1);
    }

    private void invertClassTableMaps(XMLDBMSMap xMLDBMSMap) throws XMLMiddlewareException {
        Enumeration enumeration = xMLDBMSMap.getClassTableMaps();
        while (enumeration.hasMoreElements()) {
            this.invertClassTableMap(xMLDBMSMap, (ClassTableMap)enumeration.nextElement());
        }
    }

    private void invertClassTableMap(XMLDBMSMap xMLDBMSMap, ClassTableMap classTableMap) throws XMLMiddlewareException {
        ClassMap classMap = xMLDBMSMap.createClassMap(classTableMap.getElementTypeName());
        classMap.setTable(classTableMap.getTable());
        Table table = classTableMap.getBaseTable();
        if (table != null) {
            ClassTableMap classTableMap2 = xMLDBMSMap.getClassTableMap(table);
            ClassMap classMap2 = xMLDBMSMap.createClassMap(classTableMap2.getElementTypeName());
            classMap.setBaseClassMap(classMap2);
            classMap.setBaseLinkInfo(classTableMap.getBaseLinkInfo());
        }
        this.invertColumnMaps(classMap, classTableMap.getColumnMaps());
        this.invertPropertyTableMaps(classMap, classTableMap.getPropertyTableMaps());
        this.invertRelatedClassTableMaps(xMLDBMSMap, classMap, classTableMap.getRelatedClassTableMaps());
    }

    private void invertColumnMaps(ClassMap classMap, Enumeration enumeration) throws XMLMiddlewareException {
        while (enumeration.hasMoreElements()) {
            ColumnMap columnMap = (ColumnMap)enumeration.nextElement();
            InlineClassMap inlineClassMap = this.constructInlineClassMaps(classMap, columnMap.getElementInsertionList());
            ClassMapBase classMapBase = inlineClassMap != null ? inlineClassMap : classMap;
            this.invertPropertyMapBase(classMapBase, columnMap);
        }
    }

    private void invertPropertyTableMaps(ClassMap classMap, Enumeration enumeration) throws XMLMiddlewareException {
        while (enumeration.hasMoreElements()) {
            PropertyTableMap propertyTableMap = (PropertyTableMap)enumeration.nextElement();
            InlineClassMap inlineClassMap = this.constructInlineClassMaps(classMap, propertyTableMap.getElementInsertionList());
            ClassMapBase classMapBase = inlineClassMap != null ? inlineClassMap : classMap;
            this.invertPropertyMapBase(classMapBase, propertyTableMap);
        }
    }

    private void invertPropertyMapBase(ClassMapBase classMapBase, PropertyMapBase propertyMapBase) throws XMLMiddlewareException {
        int n = propertyMapBase.getType();
        PropertyMap propertyMap = PropertyMap.create(propertyMapBase.getXMLName(), n);
        switch (n) {
            case 2: {
                classMapBase.addAttributeMap(propertyMap);
                break;
            }
            case 3: {
                classMapBase.addPCDATAMap(propertyMap);
                break;
            }
            case 1: {
                classMapBase.addChildMap(propertyMap);
                break;
            }
        }
        propertyMap.setColumn(propertyMapBase.getColumn());
        if (propertyMapBase instanceof PropertyTableMap) {
            propertyMap.setTable(((PropertyTableMap)propertyMapBase).getTable(), ((PropertyTableMap)propertyMapBase).getLinkInfo());
        }
        boolean bl = propertyMapBase.isTokenList();
        propertyMap.setIsTokenList(bl);
        if (bl) {
            propertyMap.setTokenListOrderInfo(propertyMapBase.getTokenListOrderInfo());
        }
        if (n != 2) {
            propertyMap.setOrderInfo(propertyMapBase.getOrderInfo());
        }
        if (n == 1) {
            propertyMap.setContainsXML(propertyMapBase.containsXML());
        }
    }

    private void invertRelatedClassTableMaps(XMLDBMSMap xMLDBMSMap, ClassMap classMap, Enumeration enumeration) throws XMLMiddlewareException {
        while (enumeration.hasMoreElements()) {
            RelatedClassTableMap relatedClassTableMap = (RelatedClassTableMap)enumeration.nextElement();
            InlineClassMap inlineClassMap = this.constructInlineClassMaps(classMap, relatedClassTableMap.getElementInsertionList());
            ClassMapBase classMapBase = inlineClassMap != null ? inlineClassMap : classMap;
            this.invertRelatedClassTableMap(xMLDBMSMap, classMapBase, relatedClassTableMap);
        }
    }

    private void invertRelatedClassTableMap(XMLDBMSMap xMLDBMSMap, ClassMapBase classMapBase, RelatedClassTableMap relatedClassTableMap) throws XMLMiddlewareException {
        RelatedClassMap relatedClassMap = RelatedClassMap.create(relatedClassTableMap.getElementTypeName());
        classMapBase.addChildMap(relatedClassMap);
        ClassMap classMap = xMLDBMSMap.createClassMap(relatedClassTableMap.getClassTableMap().getElementTypeName());
        relatedClassMap.setClassMap(classMap);
        relatedClassMap.setLinkInfo(relatedClassTableMap.getLinkInfo());
        relatedClassMap.setOrderInfo(relatedClassTableMap.getOrderInfo());
    }

    private InlineClassMap constructInlineClassMaps(ClassMap classMap, ElementInsertionList elementInsertionList) throws XMLMiddlewareException {
        InlineClassMap inlineClassMap = null;
        if (elementInsertionList == null) {
            return null;
        }
        ClassMapBase classMapBase = classMap;
        int n = 0;
        while (n < elementInsertionList.size()) {
            ElementInsertionMap elementInsertionMap = elementInsertionList.getElementInsertionMap(n);
            inlineClassMap = ((ClassMapBase)classMapBase).createInlineClassMap(elementInsertionMap.getElementTypeName());
            inlineClassMap.setOrderInfo(elementInsertionMap.getOrderInfo());
            classMapBase = inlineClassMap;
            ++n;
        }
        return inlineClassMap;
    }
}

