/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmiddleware.xmldbms.maps;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xmlmiddleware.conversions.formatters.BooleanFormatter;
import org.xmlmiddleware.conversions.formatters.CharFormatter;
import org.xmlmiddleware.conversions.formatters.DateFormatter;
import org.xmlmiddleware.conversions.formatters.NoFormatter;
import org.xmlmiddleware.conversions.formatters.NumberFormatter;
import org.xmlmiddleware.conversions.formatters.StringFormatter;
import org.xmlmiddleware.db.JDBCTypes;
import org.xmlmiddleware.utils.XMLMiddlewareException;
import org.xmlmiddleware.xmldbms.maps.ClassMap;
import org.xmlmiddleware.xmldbms.maps.ClassTableMap;
import org.xmlmiddleware.xmldbms.maps.MapBase;
import org.xmlmiddleware.xmldbms.maps.Table;
import org.xmlmiddleware.xmlutils.XMLName;

public class XMLDBMSMap
extends MapBase {
    private boolean emptyStringIsNull = false;
    private Hashtable defaultFormatters = new Hashtable();
    private Hashtable namedFormatters = new Hashtable();
    private Hashtable classMaps = new Hashtable();
    private Hashtable classTableMaps = new Hashtable();
    private Hashtable tables = new Hashtable();
    private Hashtable uris = new Hashtable();
    private Hashtable prefixes = new Hashtable();

    public XMLDBMSMap() {
        this.resetDefaultFormatters();
    }

    public final boolean emptyStringIsNull() {
        return this.emptyStringIsNull;
    }

    public void setEmptyStringIsNull(boolean bl) {
        this.emptyStringIsNull = bl;
    }

    public final StringFormatter getDefaultFormatter(int n) {
        if (!JDBCTypes.typeIsValid(n)) {
            throw new IllegalArgumentException("Not a valid JDBC type: " + n);
        }
        return (StringFormatter)this.defaultFormatters.get(new Integer(n));
    }

    public final Hashtable getDefaultFormatters() {
        return (Hashtable)this.defaultFormatters.clone();
    }

    public void setDefaultFormatter(int n, StringFormatter stringFormatter) {
        if (!JDBCTypes.typeIsValid(n)) {
            throw new IllegalArgumentException("Not a valid JDBC type: " + n);
        }
        MapBase.checkArgNull(stringFormatter, "formatter");
        this.defaultFormatters.put(new Integer(n), stringFormatter);
    }

    public void resetDefaultFormatters() {
        NoFormatter noFormatter = new NoFormatter();
        CharFormatter charFormatter = new CharFormatter();
        NumberFormatter numberFormatter = new NumberFormatter(NumberFormat.getNumberInstance());
        this.setDefaultFormatter(-2, noFormatter);
        this.setDefaultFormatter(-3, noFormatter);
        this.setDefaultFormatter(-4, noFormatter);
        this.setDefaultFormatter(1, charFormatter);
        this.setDefaultFormatter(12, charFormatter);
        this.setDefaultFormatter(-1, charFormatter);
        this.setDefaultFormatter(8, numberFormatter);
        this.setDefaultFormatter(6, numberFormatter);
        this.setDefaultFormatter(7, numberFormatter);
        this.setDefaultFormatter(3, numberFormatter);
        this.setDefaultFormatter(2, numberFormatter);
        this.setDefaultFormatter(-5, numberFormatter);
        this.setDefaultFormatter(4, numberFormatter);
        this.setDefaultFormatter(5, numberFormatter);
        this.setDefaultFormatter(-6, numberFormatter);
        this.setDefaultFormatter(-7, new BooleanFormatter());
        this.setDefaultFormatter(91, new DateFormatter(DateFormat.getDateInstance()));
        this.setDefaultFormatter(92, new DateFormatter(DateFormat.getTimeInstance()));
        this.setDefaultFormatter(93, new DateFormatter(DateFormat.getDateTimeInstance()));
    }

    public final StringFormatter getNamedFormatter(String string) {
        return (StringFormatter)this.namedFormatters.get(string);
    }

    public final Hashtable getNamedFormatters() {
        return (Hashtable)this.namedFormatters.clone();
    }

    public void addNamedFormatter(String string, StringFormatter stringFormatter) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "name");
        MapBase.checkArgNull(stringFormatter, "formatter");
        if (this.namedFormatters.get(string) != null) {
            throw new XMLMiddlewareException("Formatter with the name " + string + " already exists.");
        }
        this.namedFormatters.put(string, stringFormatter);
    }

    public void removeNamedFormatter(String string, StringFormatter stringFormatter) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "name");
        if (this.namedFormatters.remove(string) == null) {
            throw new XMLMiddlewareException("No formatter with the name " + string + " found.");
        }
    }

    public void removeAllNamedFormatters() {
        this.namedFormatters.clear();
    }

    public final String getNamespaceURI(String string) {
        MapBase.checkArgNull(string, "prefix");
        return (String)this.uris.get(string);
    }

    public final String getNamespacePrefix(String string) {
        MapBase.checkArgNull(string, "uri");
        return (String)this.prefixes.get(string);
    }

    public final Hashtable getNamespaceURIs() {
        return (Hashtable)this.uris.clone();
    }

    public final Hashtable getNamespacePrefixes() {
        return (Hashtable)this.prefixes.clone();
    }

    public void addNamespace(String string, String string2) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "prefix");
        MapBase.checkArgNull(string2, "uri");
        if (this.uris.get(string) != null) {
            throw new XMLMiddlewareException("Prefix already used: " + string);
        }
        if (this.prefixes.get(string2) != null) {
            throw new XMLMiddlewareException("URI already used: " + string2);
        }
        this.uris.put(string, string2);
        this.prefixes.put(string2, string);
    }

    public void removeNamespaceByPrefix(String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "prefix");
        String string2 = (String)this.uris.remove(string);
        if (string2 == null) {
            throw new XMLMiddlewareException("Prefix not found: " + string);
        }
        this.prefixes.remove(string2);
    }

    public void removeNamespaceByURI(String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "uri");
        String string2 = (String)this.prefixes.remove(string);
        if (string2 == null) {
            throw new XMLMiddlewareException("URI not found: " + string);
        }
        this.uris.remove(string2);
    }

    public void removeNamespaces() {
        this.uris.clear();
        this.prefixes.clear();
    }

    public final ClassMap getClassMap(String string, String string2) {
        return this.getClassMap(XMLName.getUniversalName(string, string2));
    }

    public final ClassMap getClassMap(String string) {
        ClassMap classMap = null;
        ClassMap classMap2 = (ClassMap)this.classMaps.get(string);
        while (classMap2 != null) {
            classMap = classMap2;
            classMap2 = classMap.getUsedClassMap();
        }
        return classMap;
    }

    public final Enumeration getClassMaps() {
        return this.classMaps.elements();
    }

    public ClassMap createClassMap(String string, String string2) {
        return this.createClassMap(XMLName.create(string, string2));
    }

    public ClassMap createClassMap(XMLName xMLName) {
        String string = xMLName.getUniversalName();
        ClassMap classMap = (ClassMap)this.classMaps.get(string);
        if (classMap == null) {
            classMap = ClassMap.create(xMLName);
            this.classMaps.put(string, classMap);
        }
        return classMap;
    }

    public void addClassMap(ClassMap classMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(classMap, "classMap");
        String string = classMap.getElementTypeName().getUniversalName();
        Object v = this.classMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Element type " + string + " already mapped.");
        }
        this.classMaps.put(string, classMap);
    }

    public void removeClassMap(String string, String string2) throws XMLMiddlewareException {
        this.removeClassMap(XMLName.getUniversalName(string, string2));
    }

    public void removeClassMap(String string) throws XMLMiddlewareException {
        MapBase.checkArgNull(string, "universalName");
        Object v = this.classMaps.remove(string);
        if (v == null) {
            throw new XMLMiddlewareException("Element type " + string + " not mapped.");
        }
    }

    public void removeAllClassMaps() {
        this.classMaps.clear();
    }

    public final ClassTableMap getClassTableMap(String string, String string2, String string3, String string4) {
        return (ClassTableMap)this.classTableMaps.get(Table.getHashName(string, string2, string3, string4));
    }

    public final ClassTableMap getClassTableMap(Table table) {
        return (ClassTableMap)this.classTableMaps.get(table.getHashName());
    }

    public final Enumeration getClassTableMaps() {
        return this.classTableMaps.elements();
    }

    public ClassTableMap createClassTableMap(Table table) {
        MapBase.checkArgNull(table, "table");
        String string = table.getHashName();
        ClassTableMap classTableMap = (ClassTableMap)this.classTableMaps.get(string);
        if (classTableMap == null) {
            classTableMap = ClassTableMap.create(table);
            this.classTableMaps.put(string, classTableMap);
        }
        return classTableMap;
    }

    public void addClassTableMap(ClassTableMap classTableMap) throws XMLMiddlewareException {
        MapBase.checkArgNull(classTableMap, "classTableMap");
        String string = classTableMap.getTable().getHashName();
        Object v = this.classTableMaps.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Table already mapped: " + classTableMap.getTable().getUniversalName());
        }
        this.classTableMaps.put(string, classTableMap);
    }

    public void removeClassTableMap(String string, String string2, String string3, String string4) throws XMLMiddlewareException {
        Object v = this.classTableMaps.remove(Table.getHashName(string, string2, string3, string4));
        if (v == null) {
            throw new XMLMiddlewareException("Table not mapped as a class table: " + Table.getUniversalName(string, string2, string3, string4));
        }
    }

    public void removeClassTableMap(Table table) throws XMLMiddlewareException {
        Object v = this.classTableMaps.remove(table.getHashName());
        if (v == null) {
            throw new XMLMiddlewareException("Table not mapped as a class table: " + table.getUniversalName());
        }
    }

    public void removeAllClassTableMaps() {
        this.classTableMaps.clear();
    }

    public final Table getTable(String string, String string2, String string3, String string4) {
        return (Table)this.tables.get(Table.getHashName(string, string2, string3, string4));
    }

    public final Enumeration getTables() {
        return this.tables.elements();
    }

    public Table createTable(String string, String string2, String string3, String string4) {
        String string5 = Table.getHashName(string, string2, string3, string4);
        Table table = (Table)this.tables.get(string5);
        if (table == null) {
            table = Table.create(string, string2, string3, string4);
            this.tables.put(string5, table);
        }
        return table;
    }

    public void addTable(Table table) throws XMLMiddlewareException {
        MapBase.checkArgNull(table, "table");
        String string = table.getHashName();
        Object v = this.tables.get(string);
        if (v != null) {
            throw new XMLMiddlewareException("Table already exists: " + table.getUniversalName());
        }
        this.tables.put(string, table);
    }

    public void removeTable(String string, String string2, String string3, String string4) throws XMLMiddlewareException {
        Object v = this.tables.remove(Table.getHashName(string, string2, string3, string4));
        if (v == null) {
            throw new XMLMiddlewareException("Table does not exist: " + Table.getUniversalName(string, string2, string3, string4));
        }
    }

    public void removeTable(Table table) throws XMLMiddlewareException {
        Object v = this.tables.remove(table.getHashName());
        if (v == null) {
            throw new XMLMiddlewareException("Table does not exist: " + table.getUniversalName());
        }
    }

    public void removeAllTables() {
        this.tables.clear();
    }

    public Table checkMetadata() {
        Enumeration enumeration = this.getTables();
        while (enumeration.hasMoreElements()) {
            Table table = (Table)enumeration.nextElement();
            if (table.checkMetadata() == null) continue;
            return table;
        }
        return null;
    }
}

