/*
 * Decompiled with CFR 0.152.
 */
package com.trs.weblet.util.verfiycode;

import com.trs.infra.util.store.FileService;
import com.trs.weblet.util.verfiycode.BitMapData;
import com.trs.weblet.util.verfiycode.BitMapInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public class VerifyCode {
    private final String m_sDigitImage;
    private final int m_iDigitCount;
    private final int m_iDigitWidth;
    private final int m_iDigitBytes;
    private final int m_iImageWidth;
    private final int m_iImageHeigh;
    private final int m_iBytesWidth;
    private final int m_iBytesHeigh;
    private final BitMapData m_bmpMaterial;
    private final int m_iCommonSize;
    private final byte[] m_aCommonHead;
    private final Random m_oNoiseMaker;
    private Exception m_eErrMessage;
    private int m_iNoiseLevel;

    public VerifyCode(String sDigitImage, int iDigitWidth) {
        this.m_sDigitImage = sDigitImage;
        this.m_iDigitCount = iDigitWidth;
        this.m_bmpMaterial = this.loadMaterial();
        this.m_iDigitWidth = this.m_bmpMaterial.getWidth() / 10;
        this.m_iDigitBytes = this.m_iDigitWidth / 8;
        this.m_iImageWidth = this.m_iDigitWidth * this.m_iDigitCount;
        this.m_iImageHeigh = this.m_bmpMaterial.getHeight();
        this.m_iBytesWidth = this.m_iImageWidth + 31 >> 5 << 2;
        this.m_iBytesHeigh = this.m_iImageHeigh;
        this.m_aCommonHead = new byte[62];
        this.m_iCommonSize = this.prepareHead();
        this.m_oNoiseMaker = new Random(System.currentTimeMillis());
        this.m_iNoiseLevel = 3;
    }

    private BitMapData loadMaterial() {
        String sImage = this.m_sDigitImage;
        try {
            BitMapData bmpTemp = new BitMapData();
            BitMapInputStream is = new BitMapInputStream(new FileService(sImage).getInputStream());
            bmpTemp.load(is);
            is.close();
            return bmpTemp;
        }
        catch (Exception e) {
            this.m_eErrMessage = e;
            return null;
        }
    }

    private final int prepareHead() {
        byte[] baHeadBuff = this.m_aCommonHead;
        BitMapData bmp = this.m_bmpMaterial;
        int iDigit = this.m_iDigitCount;
        try {
            BitMapData bmpTemp = new BitMapData();
            bmpTemp.setHeight(bmp.getHeight());
            bmpTemp.setWidth(bmp.getWidth() / 10 * iDigit);
            bmpTemp.setPalette(bmp.getPalette());
            byte[] tmpData = bmpTemp.getFileData();
            System.arraycopy(tmpData, 0, baHeadBuff, 0, baHeadBuff.length);
            return bmpTemp.getFileSize();
        }
        catch (Exception e) {
            this.m_eErrMessage = e;
            return 0;
        }
    }

    private int getNoiseByte() {
        if (this.m_iNoiseLevel > 0) {
            int iNoise = this.m_oNoiseMaker.nextInt();
            switch (this.m_iNoiseLevel) {
                case 4: {
                    iNoise &= iNoise >> 8;
                }
                case 3: {
                    iNoise &= iNoise >> 8;
                }
                case 2: {
                    iNoise &= iNoise >> 8;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    iNoise = 0;
                }
            }
            return iNoise;
        }
        return 0;
    }

    public static void main(String[] args) {
        VerifyCode vc = new VerifyCode("E:\\temp\\digit.24x32.bmp", 4);
        vc.setNoiseLevel(4);
        try {
            System.out.println(vc.getCommonSize());
            OutputStream os = new FileService("E:\\temp\\test.bmp").getOutputStream();
            os.write(vc.getImageData(123456789));
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Exception getErrMessage() {
        return this.m_eErrMessage;
    }

    public int getDigitCount() {
        return this.m_iDigitCount;
    }

    public String getDigitImage() {
        return this.m_sDigitImage;
    }

    public int getNoiseLevel() {
        return this.m_iNoiseLevel;
    }

    public void setNoiseLevel(int i) {
        if (i > 4) {
            i = 4;
        }
        this.m_iNoiseLevel = i;
    }

    public int getCommonSize() {
        return this.m_iCommonSize;
    }

    public byte[] getImageData(int iVerifyCode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.m_iCommonSize + 16);
        this.writeImageTo(iVerifyCode, baos);
        return baos.toByteArray();
    }

    public void writeImageTo(int iVerifyCode, OutputStream os) throws IOException {
        if (this.m_bmpMaterial == null) {
            throw new IllegalStateException("see VerifyCode.getErrMessage()");
        }
        os.write(this.m_aCommonHead);
        int[] iaVerifyDigit = new int[this.m_iDigitCount];
        for (int i = this.m_iDigitCount - 1; i >= 0; --i) {
            iaVerifyDigit[i] = iVerifyCode % 10;
            iVerifyCode /= 10;
        }
        byte[][] srcImageData = this.m_bmpMaterial.getDataBuff();
        for (int i = 0; i < this.m_iBytesHeigh; ++i) {
            byte[] srcImageLine = srcImageData[i];
            for (int j = 0; j < this.m_iDigitCount; ++j) {
                if (this.m_iDigitBytes == 1) {
                    os.write(srcImageLine[iaVerifyDigit[j]] ^ this.getNoiseByte());
                    continue;
                }
                int iOffset = iaVerifyDigit[j] * this.m_iDigitBytes;
                for (int k = 0; k < this.m_iDigitBytes; ++k) {
                    os.write(srcImageLine[iOffset++] ^ this.getNoiseByte());
                }
            }
            int iPadBytes = this.m_iDigitCount * this.m_iDigitBytes & 3;
            if (iPadBytes == 0) continue;
            for (int k = iPadBytes; k < 4; ++k) {
                os.write(0);
            }
        }
    }

    public void fastWriteImageTo(int iVerifyCode, OutputStream os) throws IOException {
    }
}

