/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.provider;

import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.context.ServiceContext;
import com.trs.webframework.provider.IRequestFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RequestFilterHandler {
    private Map filters;
    public static final String REQUEST_FILTER_IDENTIFY = "RequestFilterIdentify";
    private static Logger logger = Logger.getLogger(RequestFilterHandler.class);
    private static RequestFilterHandler mInstance;

    public static synchronized RequestFilterHandler getInstance() {
        if (mInstance == null) {
            mInstance = new RequestFilterHandler();
        }
        return mInstance;
    }

    private void initFilters() {
        if (this.filters != null) {
            return;
        }
        this.filters = new HashMap();
        Iterator itFilters = WCMDiscoveryFactory.getDiscovery().getImplementors(IRequestFilter.class.getName());
        while (itFilters.hasNext()) {
            String sFilterClassName = (String)itFilters.next();
            try {
                IRequestFilter filter = (IRequestFilter)Class.forName(sFilterClassName).newInstance();
                String[] sKeys = filter.getKeys();
                for (int i = 0; i < sKeys.length; ++i) {
                    String sKey = sKeys[i].toUpperCase();
                    ArrayList<IRequestFilter> filters4OneKey = (ArrayList<IRequestFilter>)this.filters.get(sKey);
                    if (filters4OneKey == null) {
                        filters4OneKey = new ArrayList<IRequestFilter>();
                        this.filters.put(sKey, filters4OneKey);
                    }
                    filters4OneKey.add(filter);
                }
            }
            catch (Exception e) {
                logger.debug((Object)"\u52a0\u8f7dIRequestFilter\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public boolean doFilter(MethodContext _oMethodContext) throws WCMException {
        ServiceContext oServiceContext = _oMethodContext.getServiceContext();
        if (oServiceContext == null || oServiceContext.getRequest() == null) {
            return true;
        }
        String sRequestFilterIdentify = (String)oServiceContext.getRequest().getAttribute(REQUEST_FILTER_IDENTIFY);
        if (CMyString.isEmpty(sRequestFilterIdentify)) {
            return true;
        }
        sRequestFilterIdentify = sRequestFilterIdentify.toUpperCase();
        this.initFilters();
        List filters4OneKey = (List)this.filters.get(sRequestFilterIdentify);
        if (filters4OneKey == null || filters4OneKey.size() == 0) {
            return true;
        }
        int size = filters4OneKey.size();
        for (int i = 0; i < size; ++i) {
            IRequestFilter filter = (IRequestFilter)filters4OneKey.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u5f00\u59cb\u6267\u884cFilter:" + filter));
            }
            if (filter.doFilter(_oMethodContext)) continue;
            _oMethodContext.getServiceContext().getResponse().setHeader("CancelByRequestFilter ", filter.getClass().getName());
            return false;
        }
        return true;
    }
}

