/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.context;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.db.QueryFilter;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.webframework.FrameworkConstants;
import com.trs.webframework.config.MethodConfig;
import com.trs.webframework.config.TRSPageParameter;
import com.trs.webframework.context.ServiceContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MethodContext {
    private static final int DFVALUE_OBJECT_ID = -99999;
    private static Logger logger = Logger.getLogger(MethodContext.class);
    private String m_sObjectIds = null;
    private int m_nObjectId = -99999;
    private QueryFilter m_oQueryFilter = null;
    private Map m_hValidatedValues = null;
    private MethodConfig m_oMethodConfig;
    private ServiceContext m_oServiceContext = null;
    private Map m_oContextCacheData = null;
    private BaseObj m_oCurrHost = null;
    private String[] m_pFieldNamesNotTrim = null;

    public boolean isReturnHTML() {
        return this.getServiceContext().isReturnHTML();
    }

    public void setReturnHTML(boolean returnHTML) {
        this.getServiceContext().setReturnHTML(returnHTML);
    }

    public MethodContext(MethodConfig _methodConfig) {
        this.m_oMethodConfig = _methodConfig;
    }

    public QueryFilter getQueryFilter() {
        if (this.m_oQueryFilter == null) {
            this.makeQueryFilter();
        }
        return this.m_oQueryFilter;
    }

    public WCMFilter getExtraWCMFilter() {
        return new WCMFilter(this.getQueryFilter());
    }

    private void makeQueryFilter() {
        if (this.m_hValidatedValues == null) {
            return;
        }
        String sWhere = null;
        QueryFilter filter = new QueryFilter();
        TRSPageParameter[] pParameters = this.m_oMethodConfig.getPageParameter();
        block18: for (int i = 0; i < pParameters.length; ++i) {
            String sValue;
            TRSPageParameter parameter = pParameters[i];
            if (parameter == null) continue;
            if (parameter.isFromTable()) {
                String sFromTable = this.getValue(parameter.getName());
                sFromTable = parameter.getDefault();
                filter.setFrom(sFromTable);
                continue;
            }
            if (parameter.isSelectFields()) {
                String sSelectFields = this.getValue(parameter.getName());
                sSelectFields = parameter.getDefault();
                filter.setSelect(sSelectFields);
                continue;
            }
            if (parameter.isOrderBy()) {
                String sOrderBy = this.getValue(parameter.getName());
                if (sOrderBy == null || sOrderBy.trim().length() == 0) {
                    sOrderBy = parameter.getDefault();
                }
                filter.setOrder(sOrderBy);
                continue;
            }
            if (!parameter.isSearch() || !this.containsParameter(parameter.getName()) || (sValue = this.getValue(parameter.getName())).length() == 0 && (parameter.getDefault() == null || parameter.getDefault().length() == 0) || parameter.isExcludeValue(sValue)) continue;
            int nValueCount = 1;
            switch (parameter.getType().toLowerCase().hashCode()) {
                case 3076014: {
                    break;
                }
                case 1793702779: {
                    CMyDateTime dtValue = null;
                    char cValueEnd = sValue.toUpperCase().charAt(sValue.length() - 1);
                    int nDateRangeType = -1;
                    switch (cValueEnd) {
                        case 'D': {
                            nDateRangeType = 3;
                            break;
                        }
                        case 'M': {
                            nDateRangeType = 2;
                            break;
                        }
                        case 'Y': {
                            nDateRangeType = 1;
                            break;
                        }
                        default: {
                            String paramName = parameter.getName();
                            dtValue = this.getValue(paramName, null);
                            try {
                                if (dtValue.getHour() != 0 || dtValue.getMinute() != 0 || dtValue.getSecond() != 0) break;
                                if (paramName.toUpperCase().endsWith("START")) {
                                    dtValue.setMinDayTime();
                                }
                                if (!paramName.toUpperCase().endsWith("END")) break;
                                dtValue.setMaxDayTime();
                                break;
                            }
                            catch (CMyException e) {
                                logger.error((Object)e.getMessage());
                            }
                        }
                    }
                    if (nDateRangeType != -1) {
                        try {
                            dtValue = MethodContext.getExactTime(nDateRangeType, Integer.parseInt(sValue.substring(0, sValue.length() - 1)));
                        }
                        catch (Exception e) {
                            logger.error((Object)("\u5904\u7406\u65e5\u671f\u68c0\u7d22\u53c2\u6570[" + parameter.getName() + "]\u7684\u503c[" + sValue + "]\u5931\u8d25\uff01"), (Throwable)e);
                        }
                    }
                    if (dtValue == null) continue block18;
                    filter.addSearchValues(dtValue);
                    break;
                }
                case -1325958191: {
                    double dValue = this.getValue(parameter.getName(), parameter.getDefaultAsDouble(0.0));
                    filter.addSearchValues(dValue);
                    break;
                }
                case 97526364: {
                    float fValue = this.getValue(parameter.getName(), parameter.getDefaultAsFloat(0.0f));
                    filter.addSearchValues(fValue);
                    break;
                }
                case 104431: {
                    int nValue = this.getValue(parameter.getName(), parameter.getDefaultAsInt(0));
                    filter.addSearchValues(nValue);
                    break;
                }
                case 3327612: {
                    long lValue = this.getValue(parameter.getName(), parameter.getDefaultAsLong(0L));
                    filter.addSearchValues(lValue);
                    break;
                }
                case -891985903: {
                    int j;
                    Object[] pValues;
                    if ("pint".equalsIgnoreCase(parameter.getSearchType())) {
                        pValues = CMyString.splitToInt(sValue, ",");
                        nValueCount = pValues.length;
                        for (j = 0; j < nValueCount; ++j) {
                            filter.addSearchValues(pValues[j]);
                        }
                    } else {
                        pValues = sValue.trim().split(" ");
                        nValueCount = pValues.length;
                        for (j = 0; j < nValueCount; ++j) {
                            Object sTempSearchValue = pValues[j];
                            if (parameter.getSearchOperator() == null || parameter.getSearchOperator().equalsIgnoreCase("like")) {
                                sTempSearchValue = '%' + (String)sTempSearchValue + '%';
                            }
                            filter.addSearchValues((String)sTempSearchValue);
                        }
                    }
                    break;
                }
                default: {
                    continue block18;
                }
            }
            sWhere = sWhere != null ? sWhere + (this.getValue("IsOr", false) ? " or " : " and ") : "";
            sWhere = sWhere + parameter.getSearchExpress(nValueCount);
        }
        filter.setWhere(sWhere);
        String sSelectFields = this.getValue("SelectFields");
        if (sSelectFields != null && sSelectFields.trim().length() != 0) {
            filter.setSelect(sSelectFields);
        }
        this.m_oQueryFilter = filter;
    }

    public void setQueryFilter(QueryFilter filter) {
        this.m_oQueryFilter = filter;
    }

    public String getObjectIds() {
        if (this.m_sObjectIds == null) {
            this.m_sObjectIds = this.getValue("ObjectIds");
        }
        return this.m_sObjectIds;
    }

    public void setObjectIds(String _sObjectIds) {
        this.m_sObjectIds = _sObjectIds != null ? _sObjectIds.trim() : _sObjectIds;
    }

    public int getObjectId() {
        if (this.m_nObjectId == -99999) {
            this.m_nObjectId = this.getValue("ObjectId", -99999);
        }
        return this.m_nObjectId;
    }

    public void setObjectId(int _nId) {
        this.m_nObjectId = _nId;
    }

    private Object getParameterValue(String _sParameterName) {
        if (this.m_hValidatedValues == null || _sParameterName == null) {
            return null;
        }
        return this.m_hValidatedValues.get(_sParameterName.toUpperCase());
    }

    public String getValue(String _sParameterName) {
        Object oValue = this.getParameterValue(_sParameterName);
        if (oValue == null) {
            return null;
        }
        boolean bNeedTrim = this.isNeedTrim(_sParameterName.toUpperCase());
        if (oValue instanceof String[]) {
            String[] pValues = (String[])oValue;
            return pValues == null || pValues.length == 0 ? null : (bNeedTrim ? pValues[0].trim() : pValues[0]);
        }
        return bNeedTrim ? oValue.toString().trim() : oValue.toString();
    }

    public Object getObjectValue(String _sParameterName) {
        return this.getParameterValue(_sParameterName);
    }

    public boolean getValue(String _sParameterName, boolean _bDefaultValue) {
        String sValue = this.getValue(_sParameterName);
        if (CMyString.isEmpty(sValue)) {
            return _bDefaultValue;
        }
        if ("true".equals(sValue = sValue.trim().toLowerCase())) {
            return true;
        }
        if ("false".equals(sValue)) {
            return false;
        }
        int nValue = this.getValue(_sParameterName, _bDefaultValue ? 1 : 0);
        return nValue != 0;
    }

    public int getValue(String _sParameterName, int _nDefaultValue) {
        Object oValue = this.getParameterValue(_sParameterName);
        if (oValue == null) {
            return _nDefaultValue;
        }
        if (oValue instanceof Integer) {
            Integer iValue = (Integer)oValue;
            return iValue;
        }
        try {
            String sValue = oValue.toString().trim();
            if (sValue.length() == 0) {
                return _nDefaultValue;
            }
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + _sParameterName + I18NMessage.get(MethodContext.class, "MethodContext.label2", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[int]\uff01")));
            return _nDefaultValue;
        }
    }

    public long getValue(String _sParameterName, long _lDefaultValue) {
        Object oValue = this.getParameterValue(_sParameterName);
        if (oValue == null) {
            return _lDefaultValue;
        }
        if (oValue instanceof Long) {
            Long value = (Long)oValue;
            return value;
        }
        try {
            return Long.parseLong(oValue.toString());
        }
        catch (NumberFormatException e) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + _sParameterName + I18NMessage.get(MethodContext.class, "MethodContext.label3", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[long]\uff01")), (Throwable)e);
            return _lDefaultValue;
        }
    }

    public double getValue(String _sParameterName, double _dDefaultValue) {
        Object oValue = this.getParameterValue(_sParameterName);
        if (oValue == null) {
            return _dDefaultValue;
        }
        if (oValue instanceof Double) {
            Double value = (Double)oValue;
            return value;
        }
        try {
            return Double.parseDouble(oValue.toString());
        }
        catch (NumberFormatException e) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + _sParameterName + I18NMessage.get(MethodContext.class, "MethodContext.label4", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[double]\uff01")), (Throwable)e);
            return _dDefaultValue;
        }
    }

    public float getValue(String _sParameterName, float _fDefaultValue) {
        Object oValue = this.getParameterValue(_sParameterName);
        if (oValue == null) {
            return _fDefaultValue;
        }
        if (oValue instanceof Float) {
            Float value = (Float)oValue;
            return value.floatValue();
        }
        try {
            return Float.parseFloat(oValue.toString());
        }
        catch (NumberFormatException e) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + _sParameterName + I18NMessage.get(MethodContext.class, "MethodContext.label5", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[float]\uff01")), (Throwable)e);
            return _fDefaultValue;
        }
    }

    public CMyDateTime getValue(String _sParameterName, CMyDateTime _dtDefaultValue) {
        Object oValue = this.getParameterValue(_sParameterName);
        if (oValue == null || oValue.toString().length() == 0) {
            return _dtDefaultValue;
        }
        if (oValue instanceof CMyDateTime) {
            CMyDateTime value = (CMyDateTime)oValue;
            return value;
        }
        try {
            CMyDateTime dtValue = new CMyDateTime();
            dtValue.setDateTimeWithString(oValue.toString());
            return dtValue;
        }
        catch (CMyException e) {
            logger.warn((Object)(I18NMessage.get(MethodContext.class, "MethodContext.label1", "\u53c2\u6570[") + _sParameterName + I18NMessage.get(MethodContext.class, "MethodContext.label6", "]\u7c7b\u578b\u4e0d\u662f\u6307\u5b9a\u7c7b\u578b[CMyDateTime]\uff01")), (Throwable)e);
            return _dtDefaultValue;
        }
    }

    public void setParamValues(String _sParamName, String[] _arValues) {
        this.setObjectValue(_sParamName, _arValues);
    }

    public String[] getParamValues(String _sParamName) {
        Object oValue = this.getParameterValue(_sParamName);
        if (oValue == null || !(oValue instanceof String[])) {
            return new String[0];
        }
        return (String[])oValue;
    }

    public Map getParams() {
        if (this.m_hValidatedValues == null || this.m_hValidatedValues.isEmpty()) {
            return new HashMap(0);
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : this.m_hValidatedValues.entrySet()) {
            String sParamName = (String)entry.getKey();
            if (FrameworkConstants.isKeyWordedParam(sParamName)) continue;
            result.put(sParamName, entry.getValue());
        }
        return this.m_hValidatedValues;
    }

    private void setObjectValue(String _sParameterName, Object _value) {
        if (_sParameterName == null || _value == null) {
            return;
        }
        if (this.m_hValidatedValues == null) {
            this.m_hValidatedValues = new HashMap();
        }
        this.m_hValidatedValues.put(_sParameterName.toUpperCase(), _value);
    }

    public void setValue(String _sParameterName, Object _oValue) {
        this.setObjectValue(_sParameterName, _oValue);
    }

    public void setValue(String _sParameterName, String _sValue) {
        this.setObjectValue(_sParameterName, _sValue);
    }

    public void setValue(String _sParameterName, int _nDefaultValue) {
        this.setObjectValue(_sParameterName, new Integer(_nDefaultValue));
    }

    public void setValue(String _sParameterName, long _lDefaultValue) {
        this.setObjectValue(_sParameterName, new Long(_lDefaultValue));
    }

    public void setValue(String _sParameterName, float _fDefaultValue) {
        this.setObjectValue(_sParameterName, new Float(_fDefaultValue));
    }

    public void setValue(String _sParameterName, double _dDefaultValue) {
        this.setObjectValue(_sParameterName, new Double(_dDefaultValue));
    }

    public void setValue(String _sParameterName, CMyDateTime _dtDefaultValue) {
        this.setObjectValue(_sParameterName, _dtDefaultValue);
    }

    public Map getValues() {
        return this.m_hValidatedValues;
    }

    public void setValues(Map values) {
        this.m_hValidatedValues = values;
    }

    public boolean containsParameter(String paramName) {
        return this.m_hValidatedValues != null && this.m_hValidatedValues.containsKey(paramName.toUpperCase());
    }

    public boolean isEmptyOfParameterValues() {
        return this.m_hValidatedValues == null || this.m_hValidatedValues.isEmpty();
    }

    public void setServiceContext(ServiceContext _serviceContext) {
        this.m_oServiceContext = _serviceContext;
    }

    public ServiceContext getServiceContext() {
        return this.m_oServiceContext;
    }

    public MethodConfig getMethodConfig() {
        return this.m_oMethodConfig;
    }

    public boolean isValidObjectId() {
        return this.getObjectId() != -99999;
    }

    public boolean isReturnJSON() {
        return this.getServiceContext().isReturnJSON();
    }

    public void setReturnJSON(boolean _bReturnJSON) {
        this.getServiceContext().setReturnJSON(_bReturnJSON);
    }

    public void setContentType(String _sContentType) {
        this.getServiceContext().setContentType(_sContentType);
    }

    public void setContentTypeIsHTML() {
        this.getServiceContext().setContentTypeIsHTML();
    }

    public void putContextCacheData(Map _oCacheData) {
        this.getContextCacheData().putAll(_oCacheData);
    }

    public void putContextCacheData(Object key, Object _value) {
        if (_value == null) {
            return;
        }
        this.getContextCacheData().put(key, _value);
    }

    public Object getContextCacheData(Object key) {
        if (key == null) {
            return null;
        }
        return this.getContextCacheData().get(key);
    }

    public int getPageSize() {
        if (this.containsParameter("PAGESIZE")) {
            return this.getValue("PAGESIZE", 20);
        }
        if (this.containsParameter("PageItemCount")) {
            return this.getValue("PageItemCount", 20);
        }
        return 20;
    }

    public int getPageIndex() {
        if (this.containsParameter("PageIndex")) {
            return this.getValue("PageIndex", 1);
        }
        if (this.containsParameter("CURRPAGE")) {
            return this.getValue("CURRPAGE", 1);
        }
        return 1;
    }

    private Map getContextCacheData() {
        if (this.m_oContextCacheData == null) {
            this.m_oContextCacheData = new HashMap(1);
        }
        return this.m_oContextCacheData;
    }

    private boolean isNeedTrim(String _sFieldName) {
        if (this.m_pFieldNamesNotTrim == null) {
            Object value = this.getParameterValue("FieldNamesNotTrim");
            String sValue = null;
            this.m_pFieldNamesNotTrim = value == null || (sValue = value.toString().trim()).length() == 0 ? new String[0] : sValue.toUpperCase().split(",");
        }
        for (int i = 0; i < this.m_pFieldNamesNotTrim.length; ++i) {
            if (!this.m_pFieldNamesNotTrim[i].equalsIgnoreCase(_sFieldName)) continue;
            return false;
        }
        return true;
    }

    public BaseObj getCurrHost() {
        return this.m_oCurrHost;
    }

    public void setCurrHost(BaseObj _oCurrHost) {
        this.m_oCurrHost = _oCurrHost;
    }

    public static CMyDateTime getExactTime(int _nTimeType, int _nTimeNum) throws WCMException {
        CMyDateTime oLatelyTime = CMyDateTime.now();
        int nHours = 0;
        switch (_nTimeType) {
            case 3: {
                try {
                    nHours = 24 * _nTimeNum;
                    oLatelyTime.dateAdd(4, nHours);
                    break;
                }
                catch (CMyException e) {
                    throw new WCMException("\u5904\u7406\u65e5\u671f\u65f6\u51fa\u73b0\u5f02\u5e38\uff01");
                }
            }
            case 2: {
                int nMonth = 1 * _nTimeNum;
                try {
                    oLatelyTime.dateAdd(2, nMonth);
                    break;
                }
                catch (CMyException e) {
                    throw new WCMException("\u5904\u7406\u65e5\u671f\u65f6\u51fa\u73b0\u5f02\u5e38\uff01");
                }
            }
            case 1: {
                int nYear = 1 * _nTimeNum;
                try {
                    oLatelyTime.dateAdd(1, nYear);
                    break;
                }
                catch (CMyException e) {
                    throw new WCMException("\u5904\u7406\u65e5\u671f\u65f6\u51fa\u73b0\u5f02\u5e38\uff01");
                }
            }
        }
        return oLatelyTime;
    }
}

